/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.tracking;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.IdRes;
import androidx.annotation.MainThread;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigation;
import androidx.navigation.fragment.NavHostFragment;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.rum.NoOpRumMonitor;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.tracking.AndroidXFragmentLifecycleCallbacks;
import com.datadog.android.rum.internal.utils.ComponentPredicateExtKt;
import com.datadog.android.rum.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.tracking.AcceptAllNavDestinations;
import com.datadog.android.rum.tracking.ActivityLifecycleTrackingStrategy;
import com.datadog.android.rum.tracking.BundleExtKt;
import com.datadog.android.rum.tracking.ComponentPredicate;
import com.datadog.android.rum.tracking.NavigationViewTrackingStrategy;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001$B'\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0017J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0017J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0017J\"\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0014J\u0018\u0010 \u001a\u0004\u0018\u00010\u001a*\u00020!2\b\b\u0001\u0010\"\u001a\u00020\u0005H\u0002J\u0018\u0010#\u001a\u0004\u0018\u00010\u001a*\u00020\u000e2\b\b\u0001\u0010\"\u001a\u00020\u0005H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "navigationViewId", "", "trackArguments", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "Landroidx/navigation/NavDestination;", "(IZLcom/datadog/android/rum/tracking/ComponentPredicate;)V", "lifecycleCallbackRefs", "Ljava/util/WeakHashMap;", "Landroid/app/Activity;", "Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks;", "predicate", "Landroidx/fragment/app/Fragment;", "startedActivity", "onActivityPaused", "", "activity", "onActivityStarted", "onActivityStopped", "onDestinationChanged", "controller", "Landroidx/navigation/NavController;", "destination", "arguments", "Landroid/os/Bundle;", "startTracking", "stopTracking", "findNavControllerFromNavHostFragmentOrNull", "Landroidx/fragment/app/FragmentActivity;", "viewId", "findNavControllerOrNull", "NavControllerFragmentLifecycleCallbacks", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nNavigationViewTrackingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationViewTrackingStrategy.kt\ncom/datadog/android/rum/tracking/NavigationViewTrackingStrategy\n+ 2 ComponentPredicateExt.kt\ncom/datadog/android/rum/internal/utils/ComponentPredicateExtKt\n*L\n1#1,221:1\n25#2,3:222\n40#2,5:225\n28#2,10:230\n*S KotlinDebug\n*F\n+ 1 NavigationViewTrackingStrategy.kt\ncom/datadog/android/rum/tracking/NavigationViewTrackingStrategy\n*L\n96#1:222,3\n98#1:225,5\n96#1:230,10\n*E\n"})
public final class NavigationViewTrackingStrategy
extends ActivityLifecycleTrackingStrategy
implements ViewTrackingStrategy,
NavController.OnDestinationChangedListener {
    private final int navigationViewId;
    private final boolean trackArguments;
    @NotNull
    private final ComponentPredicate<NavDestination> componentPredicate;
    @Nullable
    private Activity startedActivity;
    @NotNull
    private WeakHashMap<Activity, NavControllerFragmentLifecycleCallbacks> lifecycleCallbackRefs;
    @NotNull
    private final ComponentPredicate<Fragment> predicate;

    public NavigationViewTrackingStrategy(@IdRes int navigationViewId, boolean trackArguments, @NotNull ComponentPredicate<NavDestination> componentPredicate) {
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        this.navigationViewId = navigationViewId;
        this.trackArguments = trackArguments;
        this.componentPredicate = componentPredicate;
        this.lifecycleCallbackRefs = new WeakHashMap();
        this.predicate = new ComponentPredicate<Fragment>(){

            public boolean accept(@NotNull Fragment component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                return !NavHostFragment.class.isAssignableFrom(component.getClass());
            }

            @Nullable
            public String getViewName(@NotNull Fragment component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                return null;
            }
        };
    }

    public /* synthetic */ NavigationViewTrackingStrategy(int n, boolean bl, ComponentPredicate componentPredicate, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            componentPredicate = new AcceptAllNavDestinations();
        }
        this(n, bl, componentPredicate);
    }

    @Override
    @MainThread
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStarted(activity);
        this.startedActivity = activity;
        this.startTracking();
    }

    @Override
    @MainThread
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.onActivityStopped(activity);
        this.stopTracking();
        this.startedActivity = null;
    }

    @Override
    @MainThread
    public void onActivityPaused(@NotNull Activity activity) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            super.onActivityPaused(activity);
            RumMonitor rumMonitor2 = (RumMonitor)this.withSdkCore(onActivityPaused.rumMonitor.1.INSTANCE);
            NavController navController = this.findNavControllerOrNull(activity, this.navigationViewId);
            if (navController == null || (navController = navController.getCurrentDestination()) == null) break block1;
            NavController it = navController;
            boolean bl = false;
            RumMonitor rumMonitor3 = rumMonitor2;
            if (rumMonitor3 != null) {
                RumMonitor.DefaultImpls.stopView$default(rumMonitor3, it, null, 2, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        void $this$runIfValid$iv;
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        RumMonitor rumMonitor2 = (RumMonitor)this.withSdkCore(onDestinationChanged.rumMonitor.1.INSTANCE);
        ComponentPredicate<NavDestination> componentPredicate = this.componentPredicate;
        InternalLogger internalLogger$iv = this.getInternalLogger$dd_sdk_android_rum_release();
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(destination)) {
            try {
                NavDestination it = destination;
                boolean bl = false;
                Map<String, Object> attributes = this.trackArguments ? BundleExtKt.convertToRumViewAttributes(arguments) : MapsKt.emptyMap();
                ComponentPredicate<NavDestination> $this$resolveViewName$iv = this.componentPredicate;
                boolean $i$f$resolveViewName = false;
                String customName$iv = $this$resolveViewName$iv.getViewName(destination);
                CharSequence charSequence = customName$iv;
                String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(destination) : customName$iv;
                RumMonitor rumMonitor3 = rumMonitor2;
                if (rumMonitor3 != null) {
                    rumMonitor3.startView(destination, viewName, attributes);
                }
            }
            catch (Exception e$iv) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger$iv, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)ComponentPredicateExtKt.runIfValid.1.INSTANCE, (Throwable)e$iv, (boolean)false, null, (int)48, null);
            }
        }
    }

    public final void startTracking() {
        Activity activity = this.startedActivity;
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        this.withSdkCore((Function1)new Function1<FeatureSdkCore, Unit>(activity2, this){
            final /* synthetic */ Activity $activity;
            final /* synthetic */ NavigationViewTrackingStrategy this$0;
            {
                this.$activity = $activity;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FeatureSdkCore sdkCore) {
                Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
                FeatureScope featureScope = sdkCore.getFeature("rum");
                RumFeature rumFeature2 = featureScope != null ? (RumFeature)featureScope.unwrap() : null;
                Activity activity = this.$activity;
                FragmentActivity fragmentActivity = activity instanceof FragmentActivity ? (FragmentActivity)activity : null;
                NavController navController = NavigationViewTrackingStrategy.access$findNavControllerOrNull(this.this$0, this.$activity, NavigationViewTrackingStrategy.access$getNavigationViewId$p(this.this$0));
                if (fragmentActivity != null && navController != null && rumFeature2 != null) {
                    NavControllerFragmentLifecycleCallbacks navControllerFragmentCallbacks2 = new NavControllerFragmentLifecycleCallbacks(navController, (Function1<? super Fragment, ? extends Map<String, ? extends Object>>)((Function1)startTracking.navControllerFragmentCallbacks.1.INSTANCE), NavigationViewTrackingStrategy.access$getPredicate$p(this.this$0), rumFeature2);
                    Activity activity2 = NavigationViewTrackingStrategy.access$getStartedActivity$p(this.this$0);
                    Intrinsics.checkNotNull((Object)activity2, (String)"null cannot be cast to non-null type androidx.fragment.app.FragmentActivity");
                    navControllerFragmentCallbacks2.register((FragmentActivity)activity2, (SdkCore)sdkCore);
                    ((Map)NavigationViewTrackingStrategy.access$getLifecycleCallbackRefs$p(this.this$0)).put(NavigationViewTrackingStrategy.access$getStartedActivity$p(this.this$0), navControllerFragmentCallbacks2);
                    navController.addOnDestinationChangedListener((NavController.OnDestinationChangedListener)this.this$0);
                }
            }
        });
    }

    public final void stopTracking() {
        block3: {
            Activity activity = this.startedActivity;
            if (activity == null) {
                return;
            }
            Activity activity2 = activity;
            NavController navController = this.findNavControllerOrNull(activity2, this.navigationViewId);
            if (navController == null) break block3;
            NavController it = navController;
            boolean bl = false;
            it.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            boolean isFragmentActivity = FragmentActivity.class.isAssignableFrom(activity2.getClass());
            if (isFragmentActivity) {
                NavControllerFragmentLifecycleCallbacks navControllerFragmentLifecycleCallbacks = this.lifecycleCallbackRefs.remove(activity2);
                if (navControllerFragmentLifecycleCallbacks != null) {
                    navControllerFragmentLifecycleCallbacks.unregister((FragmentActivity)activity2);
                }
            }
        }
    }

    private final NavController findNavControllerOrNull(Activity $this$findNavControllerOrNull, @IdRes int viewId) {
        NavController navController;
        try {
            NavController navController2 = $this$findNavControllerOrNull instanceof FragmentActivity ? this.findNavControllerFromNavHostFragmentOrNull((FragmentActivity)$this$findNavControllerOrNull, viewId) : null;
            NavController navController3 = navController2;
            if (navController3 == null) {
                NavController navController4 = Navigation.findNavController((Activity)$this$findNavControllerOrNull, (int)viewId);
                navController3 = navController4;
                Intrinsics.checkNotNullExpressionValue((Object)navController4, (String)"findNavController(this, viewId)");
            }
            navController = navController3;
        }
        catch (IllegalArgumentException e) {
            navController = null;
        }
        catch (IllegalStateException e) {
            navController = null;
        }
        return navController;
    }

    private final NavController findNavControllerFromNavHostFragmentOrNull(FragmentActivity $this$findNavControllerFromNavHostFragmentOrNull, @IdRes int viewId) {
        NavHostFragment navHostFragment;
        Fragment fragment = $this$findNavControllerFromNavHostFragmentOrNull.getSupportFragmentManager().findFragmentById(viewId);
        NavHostFragment navHostFragment2 = navHostFragment = fragment instanceof NavHostFragment ? (NavHostFragment)fragment : null;
        return navHostFragment2 != null ? navHostFragment2.getNavController() : null;
    }

    public static final /* synthetic */ NavController access$findNavControllerOrNull(NavigationViewTrackingStrategy $this, Activity $receiver, int viewId) {
        return $this.findNavControllerOrNull($receiver, viewId);
    }

    public static final /* synthetic */ int access$getNavigationViewId$p(NavigationViewTrackingStrategy $this) {
        return $this.navigationViewId;
    }

    public static final /* synthetic */ ComponentPredicate access$getPredicate$p(NavigationViewTrackingStrategy $this) {
        return $this.predicate;
    }

    public static final /* synthetic */ Activity access$getStartedActivity$p(NavigationViewTrackingStrategy $this) {
        return $this.startedActivity;
    }

    public static final /* synthetic */ WeakHashMap access$getLifecycleCallbackRefs$p(NavigationViewTrackingStrategy $this) {
        return $this.lifecycleCallbackRefs;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks;", "navController", "Landroidx/navigation/NavController;", "argumentsProvider", "Lkotlin/Function1;", "Landroidx/fragment/app/Fragment;", "", "", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "rumFeature", "Lcom/datadog/android/rum/internal/RumFeature;", "(Landroidx/navigation/NavController;Lkotlin/jvm/functions/Function1;Lcom/datadog/android/rum/tracking/ComponentPredicate;Lcom/datadog/android/rum/internal/RumFeature;)V", "resolveKey", "fragment", "Companion", "dd-sdk-android-rum_release"})
    public static final class NavControllerFragmentLifecycleCallbacks
    extends AndroidXFragmentLifecycleCallbacks {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final NavController navController;
        @NotNull
        private static final Object NO_DESTINATION_FOUND = new Object();

        public NavControllerFragmentLifecycleCallbacks(@NotNull NavController navController, @NotNull Function1<? super Fragment, ? extends Map<String, ? extends Object>> argumentsProvider, @NotNull ComponentPredicate<Fragment> componentPredicate, @NotNull RumFeature rumFeature2) {
            Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
            Intrinsics.checkNotNullParameter(argumentsProvider, (String)"argumentsProvider");
            Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
            Intrinsics.checkNotNullParameter((Object)rumFeature2, (String)"rumFeature");
            NoOpRumMonitor noOpRumMonitor = new NoOpRumMonitor();
            super(argumentsProvider, componentPredicate, rumFeature2, noOpRumMonitor);
            this.navController = navController;
        }

        @Override
        @NotNull
        public Object resolveKey(@NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Object object = this.navController.getCurrentDestination();
            if (object == null) {
                object = NO_DESTINATION_FOUND;
            }
            return object;
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/rum/tracking/NavigationViewTrackingStrategy$NavControllerFragmentLifecycleCallbacks$Companion;", "", "()V", "NO_DESTINATION_FOUND", "getNO_DESTINATION_FOUND", "()Ljava/lang/Object;", "dd-sdk-android-rum_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Object getNO_DESTINATION_FOUND() {
                return NO_DESTINATION_FOUND;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

