/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.net;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.zip.Deflater;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/sessionreplay/net/BytesCompressor;", "", "()V", "compress", "", "deflater", "Ljava/util/zip/Deflater;", "data", "", "output", "Ljava/io/ByteArrayOutputStream;", "flag", "", "compressBytes", "uncompressedData", "getBufferByDataAndFlag", "Companion", "dd-sdk-android-session-replay_release"})
public final class BytesCompressor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int HEADER_SIZE_IN_BYTES = 2;
    private static final int SYNC_FLAG_SIZE_IN_BYTES = 4;
    public static final int CHECKSUM_FLAG_SIZE_IN_BYTES = 6;
    private static final int COMPRESSION_LEVEL = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] compressBytes(@NotNull byte[] uncompressedData) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)uncompressedData, (String)"uncompressedData");
        Deflater deflater = new Deflater(6);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(uncompressedData.length * 2);
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            this.compress(deflater, uncompressedData, it, 2);
            this.compress(deflater, new byte[0], it, 3);
            deflater.end();
            byArray = it.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] compressedData = byArray;
        Intrinsics.checkNotNullExpressionValue((Object)compressedData, (String)"compressedData");
        return compressedData;
    }

    private final void compress(Deflater deflater, byte[] data, ByteArrayOutputStream output, int flag) {
        byte[] buffer = this.getBufferByDataAndFlag(data, flag);
        int retriesCounter = 1;
        int bytesRead = 0;
        do {
            buffer = new byte[buffer.length * retriesCounter];
            if (flag == 2) {
                deflater.reset();
            }
            deflater.setInput(data);
            if (flag == 3) {
                deflater.finish();
            }
            bytesRead = deflater.deflate(buffer, 0, buffer.length, flag);
            ++retriesCounter;
        } while (bytesRead >= buffer.length);
        output.write(buffer, 0, bytesRead);
    }

    private final byte[] getBufferByDataAndFlag(byte[] data, int flag) {
        byte[] byArray;
        switch (flag) {
            case 3: {
                byArray = new byte[2 + data.length + 6];
                break;
            }
            case 2: {
                byArray = new byte[2 + data.length + 4];
                break;
            }
            default: {
                byArray = new byte[2 + data.length];
            }
        }
        return byArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/sessionreplay/net/BytesCompressor$Companion;", "", "()V", "CHECKSUM_FLAG_SIZE_IN_BYTES", "", "COMPRESSION_LEVEL", "HEADER_SIZE_IN_BYTES", "SYNC_FLAG_SIZE_IN_BYTES", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

