/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.processor;

import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import com.datadog.android.sessionreplay.RecordWriter;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.processor.EnrichedRecord;
import com.datadog.android.sessionreplay.processor.MutationResolver;
import com.datadog.android.sessionreplay.processor.NodeFlattener;
import com.datadog.android.sessionreplay.processor.Processor;
import com.datadog.android.sessionreplay.processor.RecordedDataProcessor;
import com.datadog.android.sessionreplay.recorder.Node;
import com.datadog.android.sessionreplay.recorder.OrientationChanged;
import com.datadog.android.sessionreplay.utils.RumContextProvider;
import com.datadog.android.sessionreplay.utils.SessionReplayRumContext;
import com.datadog.android.sessionreplay.utils.TimeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 @2\u00020\u0001:\u0002?@B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJW\u0010\u001a\u001a\u0004\u0018\u00010\u001b2K\u0010\u001c\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002J\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0018H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001bH\u0002J8\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00182\b\u0010.\u001a\u0004\u0018\u00010/H\u0003J\u001e\u00100\u001a\u00020(2\u0006\u0010$\u001a\u00020\u00122\f\u00101\u001a\b\u0012\u0004\u0012\u00020&0\u0018H\u0003J\u0018\u00102\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0018\u00103\u001a\u0002042\u0006\u0010!\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u0012H\u0002J\b\u00106\u001a\u000204H\u0002J \u00107\u001a\u00020(2\f\u00108\u001a\b\u0012\u0004\u0012\u00020-0\u00182\b\u0010.\u001a\u0004\u0018\u00010/H\u0017J\u0016\u00109\u001a\u00020(2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020&0\u0018H\u0017J\f\u0010;\u001a\u00020<*\u00020\u0019H\u0002J\f\u0010;\u001a\u00020<*\u00020=H\u0002J\f\u0010;\u001a\u00020<*\u00020>H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/datadog/android/sessionreplay/processor/RecordedDataProcessor;", "Lcom/datadog/android/sessionreplay/processor/Processor;", "rumContextProvider", "Lcom/datadog/android/sessionreplay/utils/RumContextProvider;", "timeProvider", "Lcom/datadog/android/sessionreplay/utils/TimeProvider;", "executorService", "Ljava/util/concurrent/ExecutorService;", "writer", "Lcom/datadog/android/sessionreplay/RecordWriter;", "mutationResolver", "Lcom/datadog/android/sessionreplay/processor/MutationResolver;", "nodeFlattener", "Lcom/datadog/android/sessionreplay/processor/NodeFlattener;", "(Lcom/datadog/android/sessionreplay/utils/RumContextProvider;Lcom/datadog/android/sessionreplay/utils/TimeProvider;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/sessionreplay/RecordWriter;Lcom/datadog/android/sessionreplay/processor/MutationResolver;Lcom/datadog/android/sessionreplay/processor/NodeFlattener;)V", "lastSnapshotTimestamp", "", "prevRumContext", "Lcom/datadog/android/sessionreplay/utils/SessionReplayRumContext;", "getPrevRumContext$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/utils/SessionReplayRumContext;", "setPrevRumContext$dd_sdk_android_session_replay_release", "(Lcom/datadog/android/sessionreplay/utils/SessionReplayRumContext;)V", "prevSnapshot", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "buildRunnable", "Ljava/lang/Runnable;", "runnableFactory", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "timestamp", "newContext", "bundleRecordInEnrichedRecord", "Lcom/datadog/android/sessionreplay/processor/EnrichedRecord;", "rumContext", "records", "Lcom/datadog/android/sessionreplay/model/MobileSegment$MobileRecord;", "executeRunnable", "", "runnable", "handleSnapshots", "newRumContext", "snapshots", "Lcom/datadog/android/sessionreplay/recorder/Node;", "orientationChanged", "Lcom/datadog/android/sessionreplay/recorder/OrientationChanged;", "handleTouchRecords", "touchData", "handleViewEndRecord", "isNewView", "", "currentContext", "isTimeForFullSnapshot", "processScreenSnapshots", "nodes", "processTouchEventsRecords", "touchEventsRecords", "bounds", "Lcom/datadog/android/sessionreplay/processor/RecordedDataProcessor$Bounds;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$ShapeWireframe;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$TextWireframe;", "Bounds", "Companion", "dd-sdk-android-session-replay_release"})
public final class RecordedDataProcessor
implements Processor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumContextProvider rumContextProvider;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final RecordWriter writer;
    @NotNull
    private final MutationResolver mutationResolver;
    @NotNull
    private final NodeFlattener nodeFlattener;
    @NotNull
    private SessionReplayRumContext prevRumContext;
    @NotNull
    private List<? extends MobileSegment.Wireframe> prevSnapshot;
    private long lastSnapshotTimestamp;
    private static final long FULL_SNAPSHOT_INTERVAL_IN_NS = TimeUnit.MILLISECONDS.toNanos(3000L);

    public RecordedDataProcessor(@NotNull RumContextProvider rumContextProvider, @NotNull TimeProvider timeProvider, @NotNull ExecutorService executorService, @NotNull RecordWriter writer, @NotNull MutationResolver mutationResolver, @NotNull NodeFlattener nodeFlattener) {
        Intrinsics.checkNotNullParameter((Object)rumContextProvider, (String)"rumContextProvider");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)mutationResolver, (String)"mutationResolver");
        Intrinsics.checkNotNullParameter((Object)nodeFlattener, (String)"nodeFlattener");
        this.rumContextProvider = rumContextProvider;
        this.timeProvider = timeProvider;
        this.executorService = executorService;
        this.writer = writer;
        this.mutationResolver = mutationResolver;
        this.nodeFlattener = nodeFlattener;
        this.prevRumContext = new SessionReplayRumContext(null, null, null, 7, null);
        this.prevSnapshot = CollectionsKt.emptyList();
    }

    public /* synthetic */ RecordedDataProcessor(RumContextProvider rumContextProvider, TimeProvider timeProvider, ExecutorService executorService, RecordWriter recordWriter, MutationResolver mutationResolver, NodeFlattener nodeFlattener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            mutationResolver = new MutationResolver();
        }
        if ((n & 0x20) != 0) {
            nodeFlattener = new NodeFlattener(null, 1, null);
        }
        this(rumContextProvider, timeProvider, executorService, recordWriter, mutationResolver, nodeFlattener);
    }

    @NotNull
    public final SessionReplayRumContext getPrevRumContext$dd_sdk_android_session_replay_release() {
        return this.prevRumContext;
    }

    public final void setPrevRumContext$dd_sdk_android_session_replay_release(@NotNull SessionReplayRumContext sessionReplayRumContext) {
        Intrinsics.checkNotNullParameter((Object)sessionReplayRumContext, (String)"<set-?>");
        this.prevRumContext = sessionReplayRumContext;
    }

    @Override
    @MainThread
    public void processScreenSnapshots(@NotNull List<Node> nodes, @Nullable OrientationChanged orientationChanged) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Runnable runnable = this.buildRunnable((Function3<? super Long, ? super SessionReplayRumContext, ? super SessionReplayRumContext, ? extends Runnable>)((Function3)new Function3<Long, SessionReplayRumContext, SessionReplayRumContext, Runnable>(this, nodes, orientationChanged){
            final /* synthetic */ RecordedDataProcessor this$0;
            final /* synthetic */ List<Node> $nodes;
            final /* synthetic */ OrientationChanged $orientationChanged;
            {
                this.this$0 = $receiver;
                this.$nodes = $nodes;
                this.$orientationChanged = $orientationChanged;
                super(3);
            }

            @NotNull
            public final Runnable invoke(long timestamp, @NotNull SessionReplayRumContext newContext, @NotNull SessionReplayRumContext currentContext) {
                Intrinsics.checkNotNullParameter((Object)newContext, (String)"newContext");
                Intrinsics.checkNotNullParameter((Object)currentContext, (String)"currentContext");
                return () -> processScreenSnapshots.1.invoke$lambda-0(this.this$0, newContext, currentContext, timestamp, this.$nodes, this.$orientationChanged);
            }

            private static final void invoke$lambda-0(RecordedDataProcessor this$0, SessionReplayRumContext $newContext, SessionReplayRumContext $currentContext, long $timestamp, List $nodes, OrientationChanged $orientationChanged) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$newContext, (String)"$newContext");
                Intrinsics.checkNotNullParameter((Object)$currentContext, (String)"$currentContext");
                Intrinsics.checkNotNullParameter((Object)$nodes, (String)"$nodes");
                RecordedDataProcessor.access$handleSnapshots(this$0, $newContext, $currentContext, $timestamp, $nodes, $orientationChanged);
            }
        }));
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            this.executeRunnable(it);
        }
    }

    @Override
    @MainThread
    public void processTouchEventsRecords(@NotNull List<? extends MobileSegment.MobileRecord> touchEventsRecords) {
        Intrinsics.checkNotNullParameter(touchEventsRecords, (String)"touchEventsRecords");
        Runnable runnable = this.buildRunnable((Function3<? super Long, ? super SessionReplayRumContext, ? super SessionReplayRumContext, ? extends Runnable>)((Function3)new Function3<Long, SessionReplayRumContext, SessionReplayRumContext, Runnable>(this, touchEventsRecords){
            final /* synthetic */ RecordedDataProcessor this$0;
            final /* synthetic */ List<MobileSegment.MobileRecord> $touchEventsRecords;
            {
                this.this$0 = $receiver;
                this.$touchEventsRecords = $touchEventsRecords;
                super(3);
            }

            @NotNull
            public final Runnable invoke(long $noName_0, @NotNull SessionReplayRumContext newContext, @NotNull SessionReplayRumContext $noName_2) {
                Intrinsics.checkNotNullParameter((Object)newContext, (String)"newContext");
                Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"$noName_2");
                return () -> processTouchEventsRecords.1.invoke$lambda-0(this.this$0, newContext, this.$touchEventsRecords);
            }

            private static final void invoke$lambda-0(RecordedDataProcessor this$0, SessionReplayRumContext $newContext, List $touchEventsRecords) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$newContext, (String)"$newContext");
                Intrinsics.checkNotNullParameter((Object)$touchEventsRecords, (String)"$touchEventsRecords");
                RecordedDataProcessor.access$handleTouchRecords(this$0, $newContext, $touchEventsRecords);
            }
        }));
        if (runnable != null) {
            Runnable it = runnable;
            boolean bl = false;
            this.executeRunnable(it);
        }
    }

    @WorkerThread
    private final void handleTouchRecords(SessionReplayRumContext rumContext, List<? extends MobileSegment.MobileRecord> touchData) {
        EnrichedRecord enrichedRecord = this.bundleRecordInEnrichedRecord(rumContext, touchData);
        this.writer.write(enrichedRecord);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void handleSnapshots(SessionReplayRumContext newRumContext, SessionReplayRumContext prevRumContext, long timestamp, List<Node> snapshots, OrientationChanged orientationChanged) {
        boolean fullSnapshotRequired;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = snapshots;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Node it = (Node)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.nodeFlattener.flattenNode$dd_sdk_android_session_replay_release(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List wireframes = (List)destination$iv$iv;
        if (wireframes.isEmpty()) {
            return;
        }
        List records = new LinkedList();
        boolean isNewView = this.isNewView(prevRumContext, newRumContext);
        boolean isTimeForFullSnapshot = this.isTimeForFullSnapshot();
        boolean bl = fullSnapshotRequired = isNewView || isTimeForFullSnapshot || orientationChanged != null;
        if (isNewView) {
            this.handleViewEndRecord(prevRumContext, timestamp);
            Bounds rootWireframeBounds = this.bounds((MobileSegment.Wireframe)wireframes.get(0));
            MobileSegment.MobileRecord.MetaRecord metaRecord = new MobileSegment.MobileRecord.MetaRecord(timestamp, new MobileSegment.Data1(rootWireframeBounds.getWidth(), rootWireframeBounds.getHeight(), null, 4, null));
            MobileSegment.MobileRecord.FocusRecord focusRecord = new MobileSegment.MobileRecord.FocusRecord(timestamp, new MobileSegment.Data2(true));
            records.add(metaRecord);
            records.add(focusRecord);
        }
        if (orientationChanged != null) {
            MobileSegment.MobileIncrementalData.ViewportResizeData viewPortResizeData = new MobileSegment.MobileIncrementalData.ViewportResizeData(orientationChanged.getWidth(), orientationChanged.getHeight());
            MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord viewportRecord = new MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord(timestamp, viewPortResizeData);
            records.add(viewportRecord);
        }
        if (fullSnapshotRequired) {
            records.add(new MobileSegment.MobileRecord.MobileFullSnapshotRecord(timestamp, new MobileSegment.Data(wireframes)));
        } else {
            MobileSegment.MobileIncrementalData.MobileMutationData mobileMutationData = this.mutationResolver.resolveMutations$dd_sdk_android_session_replay_release(this.prevSnapshot, wireframes);
            if (mobileMutationData != null) {
                MobileSegment.MobileIncrementalData.MobileMutationData it = mobileMutationData;
                boolean bl2 = false;
                records.add(new MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord(timestamp, it));
            }
        }
        this.prevSnapshot = wireframes;
        if (!((Collection)records).isEmpty()) {
            this.writer.write(this.bundleRecordInEnrichedRecord(newRumContext, records));
        }
    }

    private final boolean isTimeForFullSnapshot() {
        boolean bl;
        if (System.nanoTime() - this.lastSnapshotTimestamp >= FULL_SNAPSHOT_INTERVAL_IN_NS) {
            this.lastSnapshotTimestamp = System.nanoTime();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void handleViewEndRecord(SessionReplayRumContext prevRumContext, long timestamp) {
        if (prevRumContext.isValid$dd_sdk_android_session_replay_release()) {
            MobileSegment.MobileRecord.ViewEndRecord viewEndRecord = new MobileSegment.MobileRecord.ViewEndRecord(timestamp);
            this.writer.write(this.bundleRecordInEnrichedRecord(prevRumContext, CollectionsKt.listOf((Object)viewEndRecord)));
        }
    }

    private final void executeRunnable(Runnable runnable) {
        try {
            this.executorService.submit(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final Runnable buildRunnable(Function3<? super Long, ? super SessionReplayRumContext, ? super SessionReplayRumContext, ? extends Runnable> runnableFactory) {
        long timestamp = this.timeProvider.getDeviceTimestamp();
        SessionReplayRumContext newRumContext = this.rumContextProvider.getRumContext();
        if (newRumContext.isNotValid$dd_sdk_android_session_replay_release()) {
            return null;
        }
        Runnable runnable = (Runnable)runnableFactory.invoke((Object)timestamp, (Object)SessionReplayRumContext.copy$default(newRumContext, null, null, null, 7, null), (Object)SessionReplayRumContext.copy$default(this.prevRumContext, null, null, null, 7, null));
        this.prevRumContext = newRumContext;
        return runnable;
    }

    private final EnrichedRecord bundleRecordInEnrichedRecord(SessionReplayRumContext rumContext, List<? extends MobileSegment.MobileRecord> records) {
        return new EnrichedRecord(rumContext.getApplicationId(), rumContext.getSessionId(), rumContext.getViewId(), records);
    }

    private final boolean isNewView(SessionReplayRumContext newContext, SessionReplayRumContext currentContext) {
        return !Intrinsics.areEqual((Object)newContext.getApplicationId(), (Object)currentContext.getApplicationId()) || !Intrinsics.areEqual((Object)newContext.getSessionId(), (Object)currentContext.getSessionId()) || !Intrinsics.areEqual((Object)newContext.getViewId(), (Object)currentContext.getViewId());
    }

    private final Bounds bounds(MobileSegment.Wireframe $this$bounds) {
        Bounds bounds;
        MobileSegment.Wireframe wireframe = $this$bounds;
        if (wireframe instanceof MobileSegment.Wireframe.ShapeWireframe) {
            bounds = this.bounds((MobileSegment.Wireframe.ShapeWireframe)$this$bounds);
        } else if (wireframe instanceof MobileSegment.Wireframe.TextWireframe) {
            bounds = this.bounds((MobileSegment.Wireframe.TextWireframe)$this$bounds);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bounds;
    }

    private final Bounds bounds(MobileSegment.Wireframe.ShapeWireframe $this$bounds) {
        return new Bounds($this$bounds.getX(), $this$bounds.getY(), $this$bounds.getWidth(), $this$bounds.getHeight());
    }

    private final Bounds bounds(MobileSegment.Wireframe.TextWireframe $this$bounds) {
        return new Bounds($this$bounds.getX(), $this$bounds.getY(), $this$bounds.getWidth(), $this$bounds.getHeight());
    }

    public static final /* synthetic */ void access$handleSnapshots(RecordedDataProcessor $this, SessionReplayRumContext newRumContext, SessionReplayRumContext prevRumContext, long timestamp, List snapshots, OrientationChanged orientationChanged) {
        $this.handleSnapshots(newRumContext, prevRumContext, timestamp, snapshots, orientationChanged);
    }

    public static final /* synthetic */ void access$handleTouchRecords(RecordedDataProcessor $this, SessionReplayRumContext rumContext, List touchData) {
        $this.handleTouchRecords(rumContext, touchData);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/sessionreplay/processor/RecordedDataProcessor$Bounds;", "", "x", "", "y", "width", "height", "(JJJJ)V", "getHeight", "()J", "getWidth", "getX", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dd-sdk-android-session-replay_release"})
    private static final class Bounds {
        private final long x;
        private final long y;
        private final long width;
        private final long height;

        public Bounds(long x, long y, long width, long height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public final long getX() {
            return this.x;
        }

        public final long getY() {
            return this.y;
        }

        public final long getWidth() {
            return this.width;
        }

        public final long getHeight() {
            return this.height;
        }

        public final long component1() {
            return this.x;
        }

        public final long component2() {
            return this.y;
        }

        public final long component3() {
            return this.width;
        }

        public final long component4() {
            return this.height;
        }

        @NotNull
        public final Bounds copy(long x, long y, long width, long height) {
            return new Bounds(x, y, width, height);
        }

        public static /* synthetic */ Bounds copy$default(Bounds bounds, long l, long l2, long l3, long l4, int n, Object object) {
            if ((n & 1) != 0) {
                l = bounds.x;
            }
            if ((n & 2) != 0) {
                l2 = bounds.y;
            }
            if ((n & 4) != 0) {
                l3 = bounds.width;
            }
            if ((n & 8) != 0) {
                l4 = bounds.height;
            }
            return bounds.copy(l, l2, l3, l4);
        }

        @NotNull
        public String toString() {
            return "Bounds(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.x);
            result = result * 31 + Long.hashCode(this.y);
            result = result * 31 + Long.hashCode(this.width);
            result = result * 31 + Long.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bounds)) {
                return false;
            }
            Bounds bounds = (Bounds)other;
            if (this.x != bounds.x) {
                return false;
            }
            if (this.y != bounds.y) {
                return false;
            }
            if (this.width != bounds.width) {
                return false;
            }
            return this.height == bounds.height;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/processor/RecordedDataProcessor$Companion;", "", "()V", "FULL_SNAPSHOT_INTERVAL_IN_NS", "", "getFULL_SNAPSHOT_INTERVAL_IN_NS$dd_sdk_android_session_replay_release", "()J", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getFULL_SNAPSHOT_INTERVAL_IN_NS$dd_sdk_android_session_replay_release() {
            return FULL_SNAPSHOT_INTERVAL_IN_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

