/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.processor;

import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.utils.WireframeExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0000\u00a2\u0006\u0002\b\tJ%\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0000\u00a2\u0006\u0002\b\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0006H\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/datadog/android/sessionreplay/processor/WireframeUtils;", "", "()V", "checkIsValidWireframe", "", "wireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "topWireframes", "", "checkIsValidWireframe$dd_sdk_android_session_replay_release", "resolveWireframeClip", "Lcom/datadog/android/sessionreplay/model/MobileSegment$WireframeClip;", "parents", "resolveWireframeClip$dd_sdk_android_session_replay_release", "bounds", "Lcom/datadog/android/sessionreplay/processor/WireframeUtils$Bounds;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$ShapeWireframe;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$TextWireframe;", "isCovering", "other", "Bounds", "dd-sdk-android-session-replay_release"})
public final class WireframeUtils {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MobileSegment.WireframeClip resolveWireframeClip$dd_sdk_android_session_replay_release(@NotNull MobileSegment.Wireframe wireframe, @NotNull List<? extends MobileSegment.Wireframe> parents) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wireframe, (String)"wireframe");
        Intrinsics.checkNotNullParameter(parents, (String)"parents");
        long clipTop = 0L;
        long clipLeft = 0L;
        long clipRight = 0L;
        long clipBottom = 0L;
        Bounds wireframeBounds = this.bounds(wireframe);
        Iterable $this$map$iv = parents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobileSegment.Wireframe wireframe2 = (MobileSegment.Wireframe)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.bounds((MobileSegment.Wireframe)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bounds it = (Bounds)element$iv;
            boolean bl = false;
            clipTop = Math.max(it.getTop() - wireframeBounds.getTop(), clipTop);
            clipBottom = Math.max(wireframeBounds.getBottom() - it.getBottom(), clipBottom);
            clipLeft = Math.max(it.getLeft() - wireframeBounds.getLeft(), clipLeft);
            clipRight = Math.max(wireframeBounds.getRight() - it.getRight(), clipRight);
        }
        return clipTop > 0L || clipBottom > 0L || clipLeft > 0L || clipRight > 0L ? new MobileSegment.WireframeClip(clipTop, clipBottom, clipLeft, clipRight) : (MobileSegment.WireframeClip)null;
    }

    public final boolean checkIsValidWireframe$dd_sdk_android_session_replay_release(@NotNull MobileSegment.Wireframe wireframe, @NotNull List<? extends MobileSegment.Wireframe> topWireframes) {
        Intrinsics.checkNotNullParameter((Object)wireframe, (String)"wireframe");
        Intrinsics.checkNotNullParameter(topWireframes, (String)"topWireframes");
        Bounds wireframeBounds = this.bounds(wireframe);
        if (wireframeBounds.getWidth() <= 0L || wireframeBounds.getHeight() <= 0L) {
            return false;
        }
        Iterable $this$forEach$iv = topWireframes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MobileSegment.Wireframe it = (MobileSegment.Wireframe)element$iv;
            boolean bl = false;
            if (!this.isCovering(this.bounds(it), wireframeBounds) || !WireframeExtKt.hasOpaqueBackground(it)) continue;
            return false;
        }
        return true;
    }

    private final boolean isCovering(Bounds $this$isCovering, Bounds other) {
        return $this$isCovering.getLeft() <= other.getLeft() && $this$isCovering.getRight() >= other.getRight() && $this$isCovering.getTop() <= other.getTop() && $this$isCovering.getBottom() >= other.getBottom();
    }

    private final Bounds bounds(MobileSegment.Wireframe $this$bounds) {
        Bounds bounds;
        MobileSegment.Wireframe wireframe = $this$bounds;
        if (wireframe instanceof MobileSegment.Wireframe.ShapeWireframe) {
            bounds = this.bounds((MobileSegment.Wireframe.ShapeWireframe)$this$bounds);
        } else if (wireframe instanceof MobileSegment.Wireframe.TextWireframe) {
            bounds = this.bounds((MobileSegment.Wireframe.TextWireframe)$this$bounds);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bounds;
    }

    private final Bounds bounds(MobileSegment.Wireframe.ShapeWireframe $this$bounds) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5 = $this$bounds.getX();
        MobileSegment.WireframeClip wireframeClip = $this$bounds.getClip();
        if (wireframeClip == null) {
            l4 = 0L;
        } else {
            Long l6 = wireframeClip.getLeft();
            l4 = l6 == null ? 0L : l6;
        }
        long l7 = l5 + l4;
        long l8 = $this$bounds.getX() + $this$bounds.getWidth();
        MobileSegment.WireframeClip wireframeClip2 = $this$bounds.getClip();
        if (wireframeClip2 == null) {
            l3 = 0L;
        } else {
            Long l9 = wireframeClip2.getRight();
            l3 = l9 == null ? 0L : l9;
        }
        long l10 = l8 - l3;
        long l11 = $this$bounds.getY();
        MobileSegment.WireframeClip wireframeClip3 = $this$bounds.getClip();
        if (wireframeClip3 == null) {
            l2 = 0L;
        } else {
            Long l12 = wireframeClip3.getTop();
            l2 = l12 == null ? 0L : l12;
        }
        long l13 = l11 + l2;
        long l14 = $this$bounds.getY() + $this$bounds.getHeight();
        MobileSegment.WireframeClip wireframeClip4 = $this$bounds.getClip();
        if (wireframeClip4 == null) {
            l = 0L;
        } else {
            Long l15 = wireframeClip4.getBottom();
            l = l15 == null ? 0L : l15;
        }
        return new Bounds(l7, l10, l13, l14 - l, $this$bounds.getWidth(), $this$bounds.getHeight());
    }

    private final Bounds bounds(MobileSegment.Wireframe.TextWireframe $this$bounds) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5 = $this$bounds.getX();
        MobileSegment.WireframeClip wireframeClip = $this$bounds.getClip();
        if (wireframeClip == null) {
            l4 = 0L;
        } else {
            Long l6 = wireframeClip.getLeft();
            l4 = l6 == null ? 0L : l6;
        }
        long l7 = l5 + l4;
        long l8 = $this$bounds.getX() + $this$bounds.getWidth();
        MobileSegment.WireframeClip wireframeClip2 = $this$bounds.getClip();
        if (wireframeClip2 == null) {
            l3 = 0L;
        } else {
            Long l9 = wireframeClip2.getRight();
            l3 = l9 == null ? 0L : l9;
        }
        long l10 = l8 - l3;
        long l11 = $this$bounds.getY();
        MobileSegment.WireframeClip wireframeClip3 = $this$bounds.getClip();
        if (wireframeClip3 == null) {
            l2 = 0L;
        } else {
            Long l12 = wireframeClip3.getTop();
            l2 = l12 == null ? 0L : l12;
        }
        long l13 = l11 + l2;
        long l14 = $this$bounds.getY() + $this$bounds.getHeight();
        MobileSegment.WireframeClip wireframeClip4 = $this$bounds.getClip();
        if (wireframeClip4 == null) {
            l = 0L;
        } else {
            Long l15 = wireframeClip4.getBottom();
            l = l15 == null ? 0L : l15;
        }
        return new Bounds(l7, l10, l13, l14 - l, $this$bounds.getWidth(), $this$bounds.getHeight());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/sessionreplay/processor/WireframeUtils$Bounds;", "", "left", "", "right", "top", "bottom", "width", "height", "(JJJJJJ)V", "getBottom", "()J", "getHeight", "getLeft", "getRight", "getTop", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dd-sdk-android-session-replay_release"})
    public static final class Bounds {
        private final long left;
        private final long right;
        private final long top;
        private final long bottom;
        private final long width;
        private final long height;

        public Bounds(long left, long right, long top, long bottom, long width, long height) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            this.width = width;
            this.height = height;
        }

        public final long getLeft() {
            return this.left;
        }

        public final long getRight() {
            return this.right;
        }

        public final long getTop() {
            return this.top;
        }

        public final long getBottom() {
            return this.bottom;
        }

        public final long getWidth() {
            return this.width;
        }

        public final long getHeight() {
            return this.height;
        }

        public final long component1() {
            return this.left;
        }

        public final long component2() {
            return this.right;
        }

        public final long component3() {
            return this.top;
        }

        public final long component4() {
            return this.bottom;
        }

        public final long component5() {
            return this.width;
        }

        public final long component6() {
            return this.height;
        }

        @NotNull
        public final Bounds copy(long left, long right, long top, long bottom, long width, long height) {
            return new Bounds(left, right, top, bottom, width, height);
        }

        public static /* synthetic */ Bounds copy$default(Bounds bounds, long l, long l2, long l3, long l4, long l5, long l6, int n, Object object) {
            if ((n & 1) != 0) {
                l = bounds.left;
            }
            if ((n & 2) != 0) {
                l2 = bounds.right;
            }
            if ((n & 4) != 0) {
                l3 = bounds.top;
            }
            if ((n & 8) != 0) {
                l4 = bounds.bottom;
            }
            if ((n & 0x10) != 0) {
                l5 = bounds.width;
            }
            if ((n & 0x20) != 0) {
                l6 = bounds.height;
            }
            return bounds.copy(l, l2, l3, l4, l5, l6);
        }

        @NotNull
        public String toString() {
            return "Bounds(left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.left);
            result = result * 31 + Long.hashCode(this.right);
            result = result * 31 + Long.hashCode(this.top);
            result = result * 31 + Long.hashCode(this.bottom);
            result = result * 31 + Long.hashCode(this.width);
            result = result * 31 + Long.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bounds)) {
                return false;
            }
            Bounds bounds = (Bounds)other;
            if (this.left != bounds.left) {
                return false;
            }
            if (this.right != bounds.right) {
                return false;
            }
            if (this.top != bounds.top) {
                return false;
            }
            if (this.bottom != bounds.bottom) {
                return false;
            }
            if (this.width != bounds.width) {
                return false;
            }
            return this.height == bounds.height;
        }
    }
}

