/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/sessionreplay/recorder/Debouncer;", "", "handler", "Landroid/os/Handler;", "maxRecordDelayInNs", "", "(Landroid/os/Handler;J)V", "firstRequest", "", "lastTimeRecordWasPerformed", "debounce", "", "runnable", "Ljava/lang/Runnable;", "debounce$dd_sdk_android_session_replay_release", "executeRunnable", "Companion", "dd-sdk-android-session-replay_release"})
public final class Debouncer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Handler handler;
    private final long maxRecordDelayInNs;
    private long lastTimeRecordWasPerformed;
    private boolean firstRequest;
    private static final long MAX_DELAY_THRESHOLD_NS = TimeUnit.MILLISECONDS.toNanos(16L);
    private static final long DEBOUNCE_TIME_IN_NS = TimeUnit.MILLISECONDS.toNanos(16L);

    public Debouncer(@NotNull Handler handler, long maxRecordDelayInNs) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        this.maxRecordDelayInNs = maxRecordDelayInNs;
        this.firstRequest = true;
    }

    public /* synthetic */ Debouncer(Handler handler, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            handler = new Handler(Looper.getMainLooper());
        }
        if ((n & 2) != 0) {
            l = MAX_DELAY_THRESHOLD_NS;
        }
        this(handler, l);
    }

    public final void debounce$dd_sdk_android_session_replay_release(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (this.firstRequest) {
            this.lastTimeRecordWasPerformed = System.nanoTime();
            this.firstRequest = false;
        }
        this.handler.removeCallbacksAndMessages(null);
        long timePassedSinceLastExecution = System.nanoTime() - this.lastTimeRecordWasPerformed;
        if (timePassedSinceLastExecution >= this.maxRecordDelayInNs) {
            this.executeRunnable(runnable);
        } else {
            this.handler.postDelayed(() -> Debouncer.debounce$lambda-0(this, runnable), DEBOUNCE_TIME_IN_NS);
        }
    }

    private final void executeRunnable(Runnable runnable) {
        runnable.run();
        this.lastTimeRecordWasPerformed = System.nanoTime();
    }

    private static final void debounce$lambda-0(Debouncer this$0, Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        this$0.executeRunnable($runnable);
    }

    public Debouncer() {
        this(null, 0L, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/sessionreplay/recorder/Debouncer$Companion;", "", "()V", "DEBOUNCE_TIME_IN_NS", "", "getDEBOUNCE_TIME_IN_NS$dd_sdk_android_session_replay_release", "()J", "MAX_DELAY_THRESHOLD_NS", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getDEBOUNCE_TIME_IN_NS$dd_sdk_android_session_replay_release() {
            return DEBOUNCE_TIME_IN_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

