/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder;

import android.app.Activity;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.datadog.android.sessionreplay.NoOpRecordCallback;
import com.datadog.android.sessionreplay.RecordCallback;
import com.datadog.android.sessionreplay.processor.Processor;
import com.datadog.android.sessionreplay.recorder.Recorder;
import com.datadog.android.sessionreplay.recorder.SnapshotProducer;
import com.datadog.android.sessionreplay.recorder.callback.NoOpWindowCallback;
import com.datadog.android.sessionreplay.recorder.callback.RecorderWindowCallback;
import com.datadog.android.sessionreplay.recorder.listener.WindowsOnDrawListener;
import com.datadog.android.sessionreplay.utils.TimeProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010\u0017\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0016J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/sessionreplay/recorder/ScreenRecorder;", "Lcom/datadog/android/sessionreplay/recorder/Recorder;", "processor", "Lcom/datadog/android/sessionreplay/processor/Processor;", "snapshotProducer", "Lcom/datadog/android/sessionreplay/recorder/SnapshotProducer;", "timeProvider", "Lcom/datadog/android/sessionreplay/utils/TimeProvider;", "recordCallback", "Lcom/datadog/android/sessionreplay/RecordCallback;", "(Lcom/datadog/android/sessionreplay/processor/Processor;Lcom/datadog/android/sessionreplay/recorder/SnapshotProducer;Lcom/datadog/android/sessionreplay/utils/TimeProvider;Lcom/datadog/android/sessionreplay/RecordCallback;)V", "windowsListeners", "Ljava/util/WeakHashMap;", "Landroid/view/Window;", "Landroid/view/ViewTreeObserver$OnDrawListener;", "getWindowsListeners$dd_sdk_android_session_replay_release", "()Ljava/util/WeakHashMap;", "startRecording", "", "windows", "", "ownerActivity", "Landroid/app/Activity;", "stopRecording", "stopRecordingAndRemove", "unwrapWindowCallback", "window", "wrapWindowCallback", "screenDensity", "", "dd-sdk-android-session-replay_release"})
public final class ScreenRecorder
implements Recorder {
    @NotNull
    private final Processor processor;
    @NotNull
    private final SnapshotProducer snapshotProducer;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final RecordCallback recordCallback;
    @NotNull
    private final WeakHashMap<Window, ViewTreeObserver.OnDrawListener> windowsListeners;

    public ScreenRecorder(@NotNull Processor processor, @NotNull SnapshotProducer snapshotProducer, @NotNull TimeProvider timeProvider, @NotNull RecordCallback recordCallback) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)snapshotProducer, (String)"snapshotProducer");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)recordCallback, (String)"recordCallback");
        this.processor = processor;
        this.snapshotProducer = snapshotProducer;
        this.timeProvider = timeProvider;
        this.recordCallback = recordCallback;
        this.windowsListeners = new WeakHashMap();
    }

    public /* synthetic */ ScreenRecorder(Processor processor, SnapshotProducer snapshotProducer, TimeProvider timeProvider, RecordCallback recordCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            recordCallback = new NoOpRecordCallback();
        }
        this(processor, snapshotProducer, timeProvider, recordCallback);
    }

    @NotNull
    public final WeakHashMap<Window, ViewTreeObserver.OnDrawListener> getWindowsListeners$dd_sdk_android_session_replay_release() {
        return this.windowsListeners;
    }

    @Override
    public void startRecording(@NotNull List<? extends Window> windows, @NotNull Activity ownerActivity) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        Intrinsics.checkNotNullParameter((Object)ownerActivity, (String)"ownerActivity");
        this.stopRecordingAndRemove(windows);
        float screenDensity = ownerActivity.getResources().getDisplayMetrics().density;
        WindowsOnDrawListener onDrawListener = new WindowsOnDrawListener(ownerActivity, windows, screenDensity, this.processor, this.snapshotProducer, null, 32, null);
        Iterable $this$forEach$iv = windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window window = (Window)element$iv;
            boolean bl = false;
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            View decorView = view;
            ((Map)this.getWindowsListeners$dd_sdk_android_session_replay_release()).put(window, onDrawListener);
            ViewTreeObserver viewTreeObserver = decorView.getViewTreeObserver();
            if (viewTreeObserver != null) {
                viewTreeObserver.addOnDrawListener((ViewTreeObserver.OnDrawListener)onDrawListener);
            }
            this.wrapWindowCallback(window, screenDensity);
        }
        this.recordCallback.onStartRecording();
    }

    @Override
    public void stopRecording(@NotNull List<? extends Window> windows) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        this.stopRecordingAndRemove(windows);
        this.recordCallback.onStopRecording();
    }

    @Override
    public void stopRecording() {
        Set<Map.Entry<Window, ViewTreeObserver.OnDrawListener>> set = this.windowsListeners.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"windowsListeners.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((Window)it.getKey()).getDecorView().getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)it.getValue());
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            this.unwrapWindowCallback((Window)k);
        }
        this.windowsListeners.clear();
        this.recordCallback.onStopRecording();
    }

    private final void stopRecordingAndRemove(List<? extends Window> windows) {
        Iterable $this$forEach$iv = windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window window = (Window)element$iv;
            boolean bl = false;
            if (this.getWindowsListeners$dd_sdk_android_session_replay_release().remove(window) != null) {
                ViewTreeObserver.OnDrawListener it;
                boolean bl2 = false;
                window.getDecorView().getViewTreeObserver().removeOnDrawListener(it);
            }
            this.unwrapWindowCallback(window);
        }
    }

    private final void wrapWindowCallback(Window window, float screenDensity) {
        Window.Callback callback = window.getCallback();
        if (callback == null) {
            callback = new NoOpWindowCallback();
        }
        Window.Callback toWrap = callback;
        window.setCallback((Window.Callback)new RecorderWindowCallback(this.processor, screenDensity, toWrap, this.timeProvider, null, null, 0L, 0L, 240, null));
    }

    private final void unwrapWindowCallback(Window window) {
        Window.Callback callback = window.getCallback();
        if (callback instanceof RecorderWindowCallback) {
            Window.Callback wrappedCallback = ((RecorderWindowCallback)callback).getWrappedCallback$dd_sdk_android_session_replay_release();
            if (!(wrappedCallback instanceof NoOpWindowCallback)) {
                window.setCallback(wrappedCallback);
            } else {
                window.setCallback(null);
            }
        }
    }
}

