/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.Node;
import com.datadog.android.sessionreplay.recorder.ViewUtils;
import com.datadog.android.sessionreplay.recorder.mapper.GenericWireframeMapper;
import com.datadog.android.sessionreplay.utils.StringUtils;
import com.datadog.android.sessionreplay.utils.ThemeUtils;
import com.datadog.android.sessionreplay.utils.WireframeExtKt;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J$\u0010\u0014\u001a\u0004\u0018\u00010\f2\n\u0010\u0015\u001a\u00060\u0016R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0019\u001a\u00020\f2\n\u0010\u0015\u001a\u00060\u0016R\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/sessionreplay/recorder/SnapshotProducer;", "", "wireframeMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/GenericWireframeMapper;", "viewUtils", "Lcom/datadog/android/sessionreplay/recorder/ViewUtils;", "stringUtils", "Lcom/datadog/android/sessionreplay/utils/StringUtils;", "themeUtils", "Lcom/datadog/android/sessionreplay/utils/ThemeUtils;", "(Lcom/datadog/android/sessionreplay/recorder/mapper/GenericWireframeMapper;Lcom/datadog/android/sessionreplay/recorder/ViewUtils;Lcom/datadog/android/sessionreplay/utils/StringUtils;Lcom/datadog/android/sessionreplay/utils/ThemeUtils;)V", "convertViewToNode", "Lcom/datadog/android/sessionreplay/recorder/Node;", "view", "Landroid/view/View;", "pixelsDensity", "", "parents", "Ljava/util/LinkedList;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "produce", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "rootView", "resolveRootBackgroundFromTheme", "snapshot", "dd-sdk-android-session-replay_release"})
public final class SnapshotProducer {
    @NotNull
    private final GenericWireframeMapper wireframeMapper;
    @NotNull
    private final ViewUtils viewUtils;
    @NotNull
    private final StringUtils stringUtils;
    @NotNull
    private final ThemeUtils themeUtils;

    public SnapshotProducer(@NotNull GenericWireframeMapper wireframeMapper, @NotNull ViewUtils viewUtils, @NotNull StringUtils stringUtils, @NotNull ThemeUtils themeUtils) {
        Intrinsics.checkNotNullParameter((Object)wireframeMapper, (String)"wireframeMapper");
        Intrinsics.checkNotNullParameter((Object)viewUtils, (String)"viewUtils");
        Intrinsics.checkNotNullParameter((Object)stringUtils, (String)"stringUtils");
        Intrinsics.checkNotNullParameter((Object)themeUtils, (String)"themeUtils");
        this.wireframeMapper = wireframeMapper;
        this.viewUtils = viewUtils;
        this.stringUtils = stringUtils;
        this.themeUtils = themeUtils;
    }

    public /* synthetic */ SnapshotProducer(GenericWireframeMapper genericWireframeMapper, ViewUtils viewUtils, StringUtils stringUtils, ThemeUtils themeUtils, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            viewUtils = new ViewUtils();
        }
        if ((n & 4) != 0) {
            stringUtils = StringUtils.INSTANCE;
        }
        if ((n & 8) != 0) {
            themeUtils = ThemeUtils.INSTANCE;
        }
        this(genericWireframeMapper, viewUtils, stringUtils, themeUtils);
    }

    @Nullable
    public final Node produce(@NotNull Resources.Theme theme, @NotNull View rootView, float pixelsDensity) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Node node = this.convertViewToNode(rootView, pixelsDensity, new LinkedList<MobileSegment.Wireframe>());
        if (node == null) {
            return null;
        }
        Node snapshot = node;
        return this.resolveRootBackgroundFromTheme(theme, rootView, snapshot);
    }

    private final Node convertViewToNode(View view, float pixelsDensity, LinkedList<MobileSegment.Wireframe> parents) {
        if (this.viewUtils.checkIfNotVisible$dd_sdk_android_session_replay_release(view)) {
            return null;
        }
        if (this.viewUtils.checkIfSystemNoise$dd_sdk_android_session_replay_release(view)) {
            return null;
        }
        if (this.viewUtils.checkIsToolbar$dd_sdk_android_session_replay_release(view)) {
            return new Node(this.wireframeMapper.getImageMapper$dd_sdk_android_session_replay_release().map(view, pixelsDensity), null, null, 6, null);
        }
        LinkedList<Node> childNodes = new LinkedList<Node>();
        MobileSegment.Wireframe wireframe = this.wireframeMapper.map(view, pixelsDensity);
        if (view instanceof ViewGroup && ((ViewGroup)view).getChildCount() > 0) {
            LinkedList<MobileSegment.Wireframe> linkedList;
            LinkedList<MobileSegment.Wireframe> $this$convertViewToNode_u24lambda_u2d0 = linkedList = new LinkedList<MobileSegment.Wireframe>((Collection)parents);
            boolean bl = false;
            $this$convertViewToNode_u24lambda_u2d0.add(wireframe);
            LinkedList<MobileSegment.Wireframe> parentsCopy = linkedList;
            int n = 0;
            int n2 = ((ViewGroup)view).getChildCount();
            while (n < n2) {
                Node it;
                View viewChild;
                int i;
                if (((ViewGroup)view).getChildAt(i = n++) == null || this.convertViewToNode(viewChild, pixelsDensity, parentsCopy) == null) continue;
                boolean bl2 = false;
                childNodes.add(it);
            }
        }
        return new Node(wireframe, (List<Node>)childNodes, (List<? extends MobileSegment.Wireframe>)parents);
    }

    private final Node resolveRootBackgroundFromTheme(Resources.Theme theme, View rootView, Node snapshot) {
        MobileSegment.ShapeStyle rootShapeStyle = WireframeExtKt.shapeStyle(snapshot.getWireframe());
        if (rootShapeStyle == null) {
            Integer n = this.themeUtils.resolveThemeColor(theme);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                String colorAndAlphaAsHexa = this.stringUtils.formatColorAndAlphaAsHexa$dd_sdk_android_session_replay_release(it, 255);
                MobileSegment.ShapeStyle shapeStyle = new MobileSegment.ShapeStyle(colorAndAlphaAsHexa, Float.valueOf(rootView.getAlpha()), null, 4, null);
                return Node.copy$default(snapshot, WireframeExtKt.copy(snapshot.getWireframe(), shapeStyle), null, null, 6, null);
            }
        }
        return snapshot;
    }
}

