/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder;

import android.os.Build;
import android.view.View;
import android.view.ViewStub;
import android.widget.Toolbar;
import androidx.appcompat.R;
import androidx.appcompat.widget.ActionBarContextView;
import com.datadog.android.sessionreplay.recorder.ViewUtils;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0012R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/sessionreplay/recorder/ViewUtils;", "", "()V", "systemViewIds", "", "", "getSystemViewIds", "()Ljava/util/Set;", "systemViewIds$delegate", "Lkotlin/Lazy;", "checkIfNotVisible", "", "view", "Landroid/view/View;", "checkIfNotVisible$dd_sdk_android_session_replay_release", "checkIfSystemNoise", "checkIfSystemNoise$dd_sdk_android_session_replay_release", "checkIsToolbar", "checkIsToolbar$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
public final class ViewUtils {
    @NotNull
    private final Lazy systemViewIds$delegate = LazyKt.lazy((Function0)systemViewIds.2.INSTANCE);

    private final Set<Integer> getSystemViewIds() {
        Lazy lazy = this.systemViewIds$delegate;
        return (Set)lazy.getValue();
    }

    public final boolean checkIfNotVisible$dd_sdk_android_session_replay_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return !view.isShown() || view.getWidth() <= 0 || view.getHeight() <= 0;
    }

    public final boolean checkIfSystemNoise$dd_sdk_android_session_replay_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return this.getSystemViewIds().contains(view.getId()) || view instanceof ViewStub || view instanceof ActionBarContextView;
    }

    public final boolean checkIsToolbar$dd_sdk_android_session_replay_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return androidx.appcompat.widget.Toolbar.class.isAssignableFrom(view.getClass()) && view.getId() == R.id.action_bar || Build.VERSION.SDK_INT >= 21 && Toolbar.class.isAssignableFrom(view.getClass());
    }
}

