/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay;

import androidx.annotation.VisibleForTesting;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.MapperTypeWrapper;
import com.datadog.android.sessionreplay.SessionReplay;
import com.datadog.android.sessionreplay.SessionReplayConfiguration;
import com.datadog.android.sessionreplay.SessionReplayPrivacy;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.TouchPrivacy;
import com.datadog.android.sessionreplay.internal.SessionReplayFeature;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.recorder.OptionSelectorDetector;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0007H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R,\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/sessionreplay/SessionReplay;", "", "()V", "IS_ALREADY_REGISTERED_WARNING", "", "currentRegisteredCore", "Ljava/lang/ref/WeakReference;", "Lcom/datadog/android/api/SdkCore;", "getCurrentRegisteredCore$dd_sdk_android_session_replay_release$annotations", "getCurrentRegisteredCore$dd_sdk_android_session_replay_release", "()Ljava/lang/ref/WeakReference;", "setCurrentRegisteredCore$dd_sdk_android_session_replay_release", "(Ljava/lang/ref/WeakReference;)V", "enable", "", "sessionReplayConfiguration", "Lcom/datadog/android/sessionreplay/SessionReplayConfiguration;", "sdkCore", "isAlreadyRegistered", "", "logAlreadyRegisteredWarning", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "startRecording", "stopRecording", "dd-sdk-android-session-replay_release"})
public final class SessionReplay {
    @NotNull
    public static final SessionReplay INSTANCE = new SessionReplay();
    @Nullable
    private static WeakReference<SdkCore> currentRegisteredCore;
    @NotNull
    public static final String IS_ALREADY_REGISTERED_WARNING = "Session Replay is already enabled and does not support multiple instances. The existing instance will continue to be used.";

    private SessionReplay() {
    }

    @Nullable
    public final WeakReference<SdkCore> getCurrentRegisteredCore$dd_sdk_android_session_replay_release() {
        return currentRegisteredCore;
    }

    public final void setCurrentRegisteredCore$dd_sdk_android_session_replay_release(@Nullable WeakReference<SdkCore> weakReference) {
        currentRegisteredCore = weakReference;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCurrentRegisteredCore$dd_sdk_android_session_replay_release$annotations() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void enable(@NotNull SessionReplayConfiguration sessionReplayConfiguration, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)sessionReplayConfiguration, (String)"sessionReplayConfiguration");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        FeatureSdkCore featureSdkCore = (FeatureSdkCore)sdkCore;
        sessionReplayConfiguration.getSystemRequirementsConfiguration$dd_sdk_android_session_replay_release().runIfRequirementsMet$dd_sdk_android_session_replay_release(featureSdkCore.getInternalLogger(), (Function0<Unit>)((Function0)new Function0<Unit>(sessionReplayConfiguration, featureSdkCore, sdkCore){
            final /* synthetic */ SessionReplayConfiguration $sessionReplayConfiguration;
            final /* synthetic */ FeatureSdkCore $featureSdkCore;
            final /* synthetic */ SdkCore $sdkCore;
            {
                this.$sessionReplayConfiguration = $sessionReplayConfiguration;
                this.$featureSdkCore = $featureSdkCore;
                this.$sdkCore = $sdkCore;
                super(0);
            }

            public final void invoke() {
                TouchPrivacyManager touchPrivacyManager = new TouchPrivacyManager(this.$sessionReplayConfiguration.getTouchPrivacy$dd_sdk_android_session_replay_release());
                String string = this.$sessionReplayConfiguration.getCustomEndpointUrl$dd_sdk_android_session_replay_release();
                SessionReplayPrivacy sessionReplayPrivacy = this.$sessionReplayConfiguration.getPrivacy$dd_sdk_android_session_replay_release();
                ImagePrivacy imagePrivacy = this.$sessionReplayConfiguration.getImagePrivacy$dd_sdk_android_session_replay_release();
                TouchPrivacy touchPrivacy = this.$sessionReplayConfiguration.getTouchPrivacy$dd_sdk_android_session_replay_release();
                TextAndInputPrivacy textAndInputPrivacy = this.$sessionReplayConfiguration.getTextAndInputPrivacy$dd_sdk_android_session_replay_release();
                List<MapperTypeWrapper<?>> list = this.$sessionReplayConfiguration.getCustomMappers$dd_sdk_android_session_replay_release();
                List<OptionSelectorDetector> list2 = this.$sessionReplayConfiguration.getCustomOptionSelectorDetectors$dd_sdk_android_session_replay_release();
                List<DrawableToColorMapper> list3 = this.$sessionReplayConfiguration.getCustomDrawableMappers$dd_sdk_android_session_replay_release();
                float f = this.$sessionReplayConfiguration.getSampleRate$dd_sdk_android_session_replay_release();
                boolean bl = this.$sessionReplayConfiguration.getStartRecordingImmediately$dd_sdk_android_session_replay_release();
                boolean bl2 = this.$sessionReplayConfiguration.getDynamicOptimizationEnabled$dd_sdk_android_session_replay_release();
                SessionReplayFeature sessionReplayFeature = new SessionReplayFeature(this.$featureSdkCore, string, sessionReplayPrivacy, textAndInputPrivacy, touchPrivacy, touchPrivacyManager, imagePrivacy, list, list2, list3, f, bl, bl2);
                if (SessionReplay.access$isAlreadyRegistered(SessionReplay.INSTANCE)) {
                    SessionReplay.access$logAlreadyRegisteredWarning(SessionReplay.INSTANCE, ((FeatureSdkCore)this.$sdkCore).getInternalLogger());
                } else {
                    SessionReplay.INSTANCE.setCurrentRegisteredCore$dd_sdk_android_session_replay_release(new WeakReference<SdkCore>(this.$sdkCore));
                    ((FeatureSdkCore)this.$sdkCore).registerFeature((Feature)sessionReplayFeature);
                }
            }
        }));
    }

    public static /* synthetic */ void enable$default(SessionReplayConfiguration sessionReplayConfiguration, SdkCore sdkCore, int n, Object object) {
        if ((n & 2) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        SessionReplay.enable(sessionReplayConfiguration, sdkCore);
    }

    public final void startRecording(@NotNull SdkCore sdkCore) {
        block2: {
            SessionReplayFeature sessionReplayFeature;
            SessionReplayFeature sessionReplayFeature2;
            FeatureScope featureScope;
            FeatureSdkCore featureSdkCore;
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            FeatureSdkCore featureSdkCore2 = featureSdkCore = sdkCore instanceof FeatureSdkCore ? (FeatureSdkCore)sdkCore : null;
            if (featureSdkCore != null && (featureScope = featureSdkCore.getFeature("session-replay")) != null) {
                FeatureScope it = featureScope;
                boolean bl = false;
                Feature feature = it.unwrap();
                sessionReplayFeature2 = feature instanceof SessionReplayFeature ? (SessionReplayFeature)feature : null;
            } else {
                sessionReplayFeature2 = null;
            }
            SessionReplayFeature sessionReplayFeature3 = sessionReplayFeature = sessionReplayFeature2;
            if (sessionReplayFeature3 == null) break block2;
            sessionReplayFeature3.manuallyStartRecording$dd_sdk_android_session_replay_release();
        }
    }

    public static /* synthetic */ void startRecording$default(SessionReplay sessionReplay, SdkCore sdkCore, int n, Object object) {
        if ((n & 1) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        sessionReplay.startRecording(sdkCore);
    }

    public final void stopRecording(@NotNull SdkCore sdkCore) {
        block2: {
            SessionReplayFeature sessionReplayFeature;
            SessionReplayFeature sessionReplayFeature2;
            FeatureScope featureScope;
            FeatureSdkCore featureSdkCore;
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            FeatureSdkCore featureSdkCore2 = featureSdkCore = sdkCore instanceof FeatureSdkCore ? (FeatureSdkCore)sdkCore : null;
            if (featureSdkCore != null && (featureScope = featureSdkCore.getFeature("session-replay")) != null) {
                FeatureScope it = featureScope;
                boolean bl = false;
                Feature feature = it.unwrap();
                sessionReplayFeature2 = feature instanceof SessionReplayFeature ? (SessionReplayFeature)feature : null;
            } else {
                sessionReplayFeature2 = null;
            }
            SessionReplayFeature sessionReplayFeature3 = sessionReplayFeature = sessionReplayFeature2;
            if (sessionReplayFeature3 == null) break block2;
            sessionReplayFeature3.manuallyStopRecording$dd_sdk_android_session_replay_release();
        }
    }

    public static /* synthetic */ void stopRecording$default(SessionReplay sessionReplay, SdkCore sdkCore, int n, Object object) {
        if ((n & 1) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        sessionReplay.stopRecording(sdkCore);
    }

    private final boolean isAlreadyRegistered() {
        SdkCore sdkCore = currentRegisteredCore;
        return sdkCore != null && (sdkCore = (SdkCore)sdkCore.get()) != null ? sdkCore.isCoreActive() : false;
    }

    private final void logAlreadyRegisteredWarning(InternalLogger internalLogger) {
        InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object)InternalLogger.Target.MAINTAINER), (Function0)logAlreadyRegisteredWarning.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (List)CollectionsKt.listOf((Object)InternalLogger.Target.TELEMETRY), (Function0)logAlreadyRegisteredWarning.2.INSTANCE, null, (boolean)false, null, (int)56, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void enable(@NotNull SessionReplayConfiguration sessionReplayConfiguration) {
        Intrinsics.checkNotNullParameter((Object)sessionReplayConfiguration, (String)"sessionReplayConfiguration");
        SessionReplay.enable$default(sessionReplayConfiguration, null, 2, null);
    }

    public static final /* synthetic */ boolean access$isAlreadyRegistered(SessionReplay $this) {
        return $this.isAlreadyRegistered();
    }

    public static final /* synthetic */ void access$logAlreadyRegisteredWarning(SessionReplay $this, InternalLogger internalLogger) {
        $this.logAlreadyRegisteredWarning(internalLogger);
    }
}

