/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.SystemRequirementsConfiguration;
import com.datadog.android.sessionreplay.internal.prerequisite.CPURequirementChecker;
import com.datadog.android.sessionreplay.internal.prerequisite.MemoryRequirementChecker;
import com.datadog.android.sessionreplay.internal.prerequisite.SystemRequirementChecker;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0000\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/sessionreplay/SystemRequirementsConfiguration;", "", "minCPUCores", "", "minRAMSizeMb", "(II)V", "getMinCPUCores$dd_sdk_android_session_replay_release", "()I", "getMinRAMSizeMb$dd_sdk_android_session_replay_release", "getCheckerReport", "", "", "checkers", "", "Lcom/datadog/android/sessionreplay/internal/prerequisite/SystemRequirementChecker;", "runIfRequirementsMet", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "runnable", "Lkotlin/Function0;", "runIfRequirementsMet$dd_sdk_android_session_replay_release", "Builder", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nSystemRequirementsConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemRequirementsConfiguration.kt\ncom/datadog/android/sessionreplay/SystemRequirementsConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1726#2,3:128\n1179#2,2:131\n1253#2,4:133\n*S KotlinDebug\n*F\n+ 1 SystemRequirementsConfiguration.kt\ncom/datadog/android/sessionreplay/SystemRequirementsConfiguration\n*L\n30#1:128,3\n52#1:131,2\n52#1:133,4\n*E\n"})
public final class SystemRequirementsConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int minCPUCores;
    private final int minRAMSizeMb;
    @NotNull
    private static final String ATTRIBUTE_DEVICE_STATS_KEY = "device_stats";
    @NotNull
    private static final SystemRequirementsConfiguration BASIC = new SystemRequirementsConfiguration(2, 1024);
    @NotNull
    private static final SystemRequirementsConfiguration NONE = new SystemRequirementsConfiguration(0, 0);

    public SystemRequirementsConfiguration(int minCPUCores, int minRAMSizeMb) {
        this.minCPUCores = minCPUCores;
        this.minRAMSizeMb = minRAMSizeMb;
    }

    public final int getMinCPUCores$dd_sdk_android_session_replay_release() {
        return this.minCPUCores;
    }

    public final int getMinRAMSizeMb$dd_sdk_android_session_replay_release() {
        return this.minRAMSizeMb;
    }

    public final void runIfRequirementsMet$dd_sdk_android_session_replay_release(@NotNull InternalLogger internalLogger, @NotNull Function0<Unit> runnable) {
        boolean checkResult;
        List checkers;
        block5: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
            Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
            Object[] objectArray = new SystemRequirementChecker[]{new CPURequirementChecker(this.minCPUCores, null, internalLogger, 2, null), new MemoryRequirementChecker(this.minRAMSizeMb, null, internalLogger, 2, null)};
            checkers = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$all$iv = checkers;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SystemRequirementChecker it = (SystemRequirementChecker)element$iv;
                    boolean bl2 = false;
                    if (it.checkMinimumRequirement()) continue;
                    bl = false;
                    break block5;
                }
                bl = checkResult = true;
            }
        }
        if (checkResult) {
            runnable.invoke();
        } else {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.TELEMETRY, InternalLogger.Target.USER};
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.INFO, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)runIfRequirementsMet.1.INSTANCE, null, (boolean)true, this.getCheckerReport(checkers), (int)8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> getCheckerReport(List<? extends SystemRequirementChecker> checkers) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable iterable = checkers;
        String string = ATTRIBUTE_DEVICE_STATS_KEY;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            SystemRequirementChecker it = (SystemRequirementChecker)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.name(), (Object)it.checkedValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)destination$iv$iv));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/sessionreplay/SystemRequirementsConfiguration$Builder;", "", "()V", "minCPUCoreNumber", "", "minRAMSizeMb", "build", "Lcom/datadog/android/sessionreplay/SystemRequirementsConfiguration;", "setMinCPUCoreNumber", "cpuCoreNumber", "setMinRAMSizeMb", "dd-sdk-android-session-replay_release"})
    public static final class Builder {
        private int minCPUCoreNumber;
        private int minRAMSizeMb;

        @NotNull
        public final Builder setMinCPUCoreNumber(int cpuCoreNumber) {
            this.minCPUCoreNumber = cpuCoreNumber;
            return this;
        }

        @NotNull
        public final Builder setMinRAMSizeMb(int minRAMSizeMb) {
            this.minRAMSizeMb = minRAMSizeMb;
            return this;
        }

        @NotNull
        public final SystemRequirementsConfiguration build() {
            return new SystemRequirementsConfiguration(this.minCPUCoreNumber, this.minRAMSizeMb);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/sessionreplay/SystemRequirementsConfiguration$Companion;", "", "()V", "ATTRIBUTE_DEVICE_STATS_KEY", "", "BASIC", "Lcom/datadog/android/sessionreplay/SystemRequirementsConfiguration;", "getBASIC", "()Lcom/datadog/android/sessionreplay/SystemRequirementsConfiguration;", "NONE", "getNONE", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SystemRequirementsConfiguration getBASIC() {
            return BASIC;
        }

        @NotNull
        public final SystemRequirementsConfiguration getNONE() {
            return NONE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

