/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal;

import android.app.Application;
import android.os.Build;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.NumberPicker;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.appcompat.widget.ActionBarContainer;
import androidx.appcompat.widget.SwitchCompat;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.internal.utils.ImageViewUtils;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.MapperTypeWrapper;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.RecorderProvider;
import com.datadog.android.sessionreplay.internal.SessionReplayRumContextProvider;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.internal.recorder.Recorder;
import com.datadog.android.sessionreplay.internal.recorder.SessionReplayRecorder;
import com.datadog.android.sessionreplay.internal.recorder.mapper.ActionBarContainerMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.ButtonMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.CheckBoxMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.CheckedTextViewMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.NumberPickerMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.ProgressBarWireframeMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.RadioButtonMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.SeekBarWireframeMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.SwitchCompatMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.WebViewWireframeMapper;
import com.datadog.android.sessionreplay.internal.resources.ResourceDataStoreManager;
import com.datadog.android.sessionreplay.internal.storage.RecordWriter;
import com.datadog.android.sessionreplay.internal.storage.ResourcesWriter;
import com.datadog.android.sessionreplay.internal.time.SessionReplayTimeProvider;
import com.datadog.android.sessionreplay.recorder.OptionSelectorDetector;
import com.datadog.android.sessionreplay.recorder.mapper.EditTextMapper;
import com.datadog.android.sessionreplay.recorder.mapper.ImageViewMapper;
import com.datadog.android.sessionreplay.recorder.mapper.TextViewMapper;
import com.datadog.android.sessionreplay.recorder.mapper.WireframeMapper;
import com.datadog.android.sessionreplay.recorder.resources.DefaultDrawableCopier;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DefaultColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DefaultViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.DefaultViewIdentifierResolver;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0002J0\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/datadog/android/sessionreplay/internal/DefaultRecorderProvider;", "Lcom/datadog/android/sessionreplay/internal/RecorderProvider;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "touchPrivacyManager", "Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "customMappers", "", "Lcom/datadog/android/sessionreplay/MapperTypeWrapper;", "customOptionSelectorDetectors", "Lcom/datadog/android/sessionreplay/recorder/OptionSelectorDetector;", "customDrawableMappers", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "dynamicOptimizationEnabled", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Lcom/datadog/android/sessionreplay/ImagePrivacy;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;Ljava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "builtInMappers", "getNumberPickerMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/WireframeMapper;", "Landroid/widget/NumberPicker;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "provideSessionReplayRecorder", "Lcom/datadog/android/sessionreplay/internal/recorder/Recorder;", "resourceDataStoreManager", "Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager;", "resourceWriter", "Lcom/datadog/android/sessionreplay/internal/storage/ResourcesWriter;", "recordWriter", "Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;", "application", "Landroid/app/Application;", "dd-sdk-android-session-replay_release"})
public final class DefaultRecorderProvider
implements RecorderProvider {
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final TextAndInputPrivacy textAndInputPrivacy;
    @NotNull
    private final ImagePrivacy imagePrivacy;
    @NotNull
    private final TouchPrivacyManager touchPrivacyManager;
    @NotNull
    private final List<MapperTypeWrapper<?>> customMappers;
    @NotNull
    private final List<OptionSelectorDetector> customOptionSelectorDetectors;
    @NotNull
    private final List<DrawableToColorMapper> customDrawableMappers;
    private final boolean dynamicOptimizationEnabled;

    public DefaultRecorderProvider(@NotNull FeatureSdkCore sdkCore, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull ImagePrivacy imagePrivacy, @NotNull TouchPrivacyManager touchPrivacyManager, @NotNull List<? extends MapperTypeWrapper<?>> customMappers2, @NotNull List<? extends OptionSelectorDetector> customOptionSelectorDetectors, @NotNull List<? extends DrawableToColorMapper> customDrawableMappers, boolean dynamicOptimizationEnabled) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        Intrinsics.checkNotNullParameter(customMappers2, (String)"customMappers");
        Intrinsics.checkNotNullParameter(customOptionSelectorDetectors, (String)"customOptionSelectorDetectors");
        Intrinsics.checkNotNullParameter(customDrawableMappers, (String)"customDrawableMappers");
        this.sdkCore = sdkCore;
        this.textAndInputPrivacy = textAndInputPrivacy;
        this.imagePrivacy = imagePrivacy;
        this.touchPrivacyManager = touchPrivacyManager;
        this.customMappers = customMappers2;
        this.customOptionSelectorDetectors = customOptionSelectorDetectors;
        this.customDrawableMappers = customDrawableMappers;
        this.dynamicOptimizationEnabled = dynamicOptimizationEnabled;
    }

    @Override
    @NotNull
    public Recorder provideSessionReplayRecorder(@NotNull ResourceDataStoreManager resourceDataStoreManager, @NotNull ResourcesWriter resourceWriter, @NotNull RecordWriter recordWriter, @NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)resourceDataStoreManager, (String)"resourceDataStoreManager");
        Intrinsics.checkNotNullParameter((Object)resourceWriter, (String)"resourceWriter");
        Intrinsics.checkNotNullParameter((Object)recordWriter, (String)"recordWriter");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        SessionReplayRumContextProvider sessionReplayRumContextProvider = new SessionReplayRumContextProvider(this.sdkCore);
        ImagePrivacy imagePrivacy = this.imagePrivacy;
        TouchPrivacyManager touchPrivacyManager = this.touchPrivacyManager;
        TextAndInputPrivacy textAndInputPrivacy = this.textAndInputPrivacy;
        SessionReplayTimeProvider sessionReplayTimeProvider = new SessionReplayTimeProvider(this.sdkCore, null, 2, null);
        List list = CollectionsKt.plus((Collection)this.customMappers, (Iterable)this.builtInMappers());
        List<OptionSelectorDetector> list2 = this.customOptionSelectorDetectors;
        List<DrawableToColorMapper> list3 = this.customDrawableMappers;
        FeatureSdkCore featureSdkCore = this.sdkCore;
        boolean bl = this.dynamicOptimizationEnabled;
        return new SessionReplayRecorder(application, resourceWriter, sessionReplayRumContextProvider, textAndInputPrivacy, imagePrivacy, touchPrivacyManager, recordWriter, sessionReplayTimeProvider, list, list2, list3, null, featureSdkCore, resourceDataStoreManager, bl, 2048, null);
    }

    private final List<MapperTypeWrapper<?>> builtInMappers() {
        List mappersList;
        block0: {
            ViewIdentifierResolver viewIdentifierResolver = DefaultViewIdentifierResolver.INSTANCE;
            ColorStringFormatter colorStringFormatter = DefaultColorStringFormatter.INSTANCE;
            ViewBoundsResolver viewBoundsResolver = DefaultViewBoundsResolver.INSTANCE;
            DrawableToColorMapper drawableToColorMapper = DrawableToColorMapper.Companion.getDefault$default(DrawableToColorMapper.Companion, null, 1, null);
            ImageViewMapper imageViewMapper = new ImageViewMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper, ImageViewUtils.INSTANCE, new DefaultDrawableCopier());
            TextViewMapper textViewMapper = new TextViewMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
            Object object = new MapperTypeWrapper[]{new MapperTypeWrapper<SwitchCompat>(SwitchCompat.class, new SwitchCompatMapper(textViewMapper, viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper)), new MapperTypeWrapper<RadioButton>(RadioButton.class, new RadioButtonMapper(textViewMapper, viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper, this.sdkCore.getInternalLogger())), new MapperTypeWrapper<CheckBox>(CheckBox.class, new CheckBoxMapper(textViewMapper, viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper, this.sdkCore.getInternalLogger())), new MapperTypeWrapper<CheckedTextView>(CheckedTextView.class, new CheckedTextViewMapper(textViewMapper, viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper)), new MapperTypeWrapper<EditText>(EditText.class, new EditTextMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper)), new MapperTypeWrapper<Button>(Button.class, new ButtonMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper)), new MapperTypeWrapper<TextView>(TextView.class, textViewMapper), new MapperTypeWrapper<ImageView>(ImageView.class, imageViewMapper), new MapperTypeWrapper<ActionBarContainer>(ActionBarContainer.class, new ActionBarContainerMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper)), new MapperTypeWrapper<WebView>(WebView.class, new WebViewWireframeMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper)), new MapperTypeWrapper<SeekBar>(SeekBar.class, new SeekBarWireframeMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper)), new MapperTypeWrapper<ProgressBar>(ProgressBar.class, new ProgressBarWireframeMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper, true))};
            mappersList = CollectionsKt.mutableListOf((Object[])object);
            object = this.getNumberPickerMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
            if (object == null) break block0;
            Object it = object;
            boolean bl = false;
            mappersList.add(0, new MapperTypeWrapper<NumberPicker>(NumberPicker.class, (WireframeMapper<NumberPicker>)it));
        }
        return mappersList;
    }

    private final WireframeMapper<NumberPicker> getNumberPickerMapper(ViewIdentifierResolver viewIdentifierResolver, ColorStringFormatter colorStringFormatter, ViewBoundsResolver viewBoundsResolver, DrawableToColorMapper drawableToColorMapper) {
        return Build.VERSION.SDK_INT >= 29 ? (WireframeMapper)new NumberPickerMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper) : null;
    }
}

