/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal;

import android.app.Application;
import android.content.Context;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureEventReceiver;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.feature.StorageBackedFeature;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.FeatureStorageConfiguration;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.MapperTypeWrapper;
import com.datadog.android.sessionreplay.SessionReplayPrivacy;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.TouchPrivacy;
import com.datadog.android.sessionreplay.internal.DefaultRecorderProvider;
import com.datadog.android.sessionreplay.internal.RecorderProvider;
import com.datadog.android.sessionreplay.internal.ResourcesFeature;
import com.datadog.android.sessionreplay.internal.SessionReplayFeature;
import com.datadog.android.sessionreplay.internal.SessionReplayRecordCallback;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.internal.net.BatchesToSegmentsMapper;
import com.datadog.android.sessionreplay.internal.net.SegmentRequestFactory;
import com.datadog.android.sessionreplay.internal.recorder.NoOpRecorder;
import com.datadog.android.sessionreplay.internal.recorder.Recorder;
import com.datadog.android.sessionreplay.internal.resources.ResourceDataStoreManager;
import com.datadog.android.sessionreplay.internal.resources.ResourceHashesEntryDeserializer;
import com.datadog.android.sessionreplay.internal.resources.ResourceHashesEntrySerializer;
import com.datadog.android.sessionreplay.internal.storage.NoOpRecordWriter;
import com.datadog.android.sessionreplay.internal.storage.RecordWriter;
import com.datadog.android.sessionreplay.internal.storage.SessionReplayRecordWriter;
import com.datadog.android.sessionreplay.model.ResourceHashesEntry;
import com.datadog.android.sessionreplay.recorder.OptionSelectorDetector;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 p2\u00020\u00012\u00020\u0002:\u0002pqB\u0087\u0001\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001dBU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010#J\u0010\u0010O\u001a\u00020 2\u0006\u0010P\u001a\u00020\u001bH\u0002J\b\u0010Q\u001a\u00020\u001bH\u0002J\b\u0010R\u001a\u00020)H\u0002J\u0010\u0010S\u001a\u00020 2\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010V\u001a\u00020 2\u000e\u0010W\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030XH\u0002J\b\u0010Y\u001a\u00020 H\u0002J\b\u0010Z\u001a\u00020 H\u0002J\b\u0010[\u001a\u00020 H\u0002J\b\u0010\\\u001a\u00020 H\u0002J\r\u0010]\u001a\u00020 H\u0000\u00a2\u0006\u0002\b^J\r\u0010_\u001a\u00020 H\u0000\u00a2\u0006\u0002\b`J\u0010\u0010a\u001a\u00020 2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010b\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010c\u001a\u00020 2\u0006\u0010d\u001a\u00020eH\u0016J\b\u0010f\u001a\u00020 H\u0016J\u001a\u0010g\u001a\u0004\u0018\u00010U2\u000e\u0010W\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030XH\u0002J\u0010\u0010h\u001a\u00020i2\u0006\u0010\u0003\u001a\u00020jH\u0002J\u0010\u0010k\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020\u001bH\u0002J\r\u0010l\u001a\u00020 H\u0000\u00a2\u0006\u0002\bmJ\r\u0010n\u001a\u00020 H\u0000\u00a2\u0006\u0002\boR\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u000201X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\u00020=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u00020AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u000e\u0010F\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010G\u001a\u00020HX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010N\u00a8\u0006r"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayFeature;", "Lcom/datadog/android/api/feature/StorageBackedFeature;", "Lcom/datadog/android/api/feature/FeatureEventReceiver;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "customEndpointUrl", "", "privacy", "Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "touchPrivacy", "Lcom/datadog/android/sessionreplay/TouchPrivacy;", "touchPrivacyManager", "Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "customMappers", "", "Lcom/datadog/android/sessionreplay/MapperTypeWrapper;", "customOptionSelectorDetectors", "Lcom/datadog/android/sessionreplay/recorder/OptionSelectorDetector;", "customDrawableMappers", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "sampleRate", "", "startRecordingImmediately", "", "dynamicOptimizationEnabled", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Ljava/lang/String;Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Lcom/datadog/android/sessionreplay/TouchPrivacy;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;Lcom/datadog/android/sessionreplay/ImagePrivacy;Ljava/util/List;Ljava/util/List;Ljava/util/List;FZZ)V", "rateBasedSampler", "Lcom/datadog/android/core/sampling/Sampler;", "", "recorderProvider", "Lcom/datadog/android/sessionreplay/internal/RecorderProvider;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Ljava/lang/String;Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Lcom/datadog/android/sessionreplay/TouchPrivacy;Lcom/datadog/android/sessionreplay/ImagePrivacy;Lcom/datadog/android/core/sampling/Sampler;ZLcom/datadog/android/sessionreplay/internal/RecorderProvider;)V", "appContext", "Landroid/content/Context;", "currentRumSessionId", "Ljava/util/concurrent/atomic/AtomicReference;", "dataWriter", "Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;", "getDataWriter$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;", "setDataWriter$dd_sdk_android_session_replay_release", "(Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;)V", "getImagePrivacy$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/ImagePrivacy;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_session_replay_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isRecording", "isSessionSampledIn", "name", "getName", "()Ljava/lang/String;", "getPrivacy$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;", "recordingStateChanged", "requestFactory", "Lcom/datadog/android/api/net/RequestFactory;", "getRequestFactory", "()Lcom/datadog/android/api/net/RequestFactory;", "sessionReplayRecorder", "Lcom/datadog/android/sessionreplay/internal/recorder/Recorder;", "getSessionReplayRecorder$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/internal/recorder/Recorder;", "setSessionReplayRecorder$dd_sdk_android_session_replay_release", "(Lcom/datadog/android/sessionreplay/internal/recorder/Recorder;)V", "shouldRecord", "storageConfiguration", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "getStorageConfiguration", "()Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "getTextAndInputPrivacy$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "getTouchPrivacy$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/TouchPrivacy;", "applySampling", "alreadySeenSession", "checkIfInitialized", "createDataWriter", "handleRecording", "sessionData", "Lcom/datadog/android/sessionreplay/internal/SessionReplayFeature$SessionData;", "handleRumSession", "sessionMetadata", "", "logEventMissingMandatoryFieldsError", "logMissingApplicationContextError", "logNotInitializedError", "logSampledOutMessage", "manuallyStartRecording", "manuallyStartRecording$dd_sdk_android_session_replay_release", "manuallyStopRecording", "manuallyStopRecording$dd_sdk_android_session_replay_release", "modifyShouldRecordState", "onInitialize", "onReceive", "event", "", "onStop", "parseSessionMetadata", "registerResourceFeature", "Lcom/datadog/android/sessionreplay/internal/ResourcesFeature;", "Lcom/datadog/android/api/SdkCore;", "shouldHandleSession", "startRecording", "startRecording$dd_sdk_android_session_replay_release", "stopRecording", "stopRecording$dd_sdk_android_session_replay_release", "Companion", "SessionData", "dd-sdk-android-session-replay_release"})
public final class SessionReplayFeature
implements StorageBackedFeature,
FeatureEventReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @Nullable
    private final String customEndpointUrl;
    @NotNull
    private final SessionReplayPrivacy privacy;
    @NotNull
    private final TextAndInputPrivacy textAndInputPrivacy;
    @NotNull
    private final TouchPrivacy touchPrivacy;
    @NotNull
    private final ImagePrivacy imagePrivacy;
    @NotNull
    private final Sampler<Unit> rateBasedSampler;
    private final boolean startRecordingImmediately;
    @NotNull
    private final RecorderProvider recorderProvider;
    @NotNull
    private final AtomicReference<String> currentRumSessionId;
    private Context appContext;
    @NotNull
    private AtomicBoolean shouldRecord;
    @NotNull
    private AtomicBoolean recordingStateChanged;
    @NotNull
    private AtomicBoolean isRecording;
    @NotNull
    private AtomicBoolean isSessionSampledIn;
    @NotNull
    private Recorder sessionReplayRecorder;
    @NotNull
    private RecordWriter dataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final String name;
    @NotNull
    private final RequestFactory requestFactory;
    @NotNull
    private final FeatureStorageConfiguration storageConfiguration;
    @NotNull
    private static final FeatureStorageConfiguration STORAGE_CONFIGURATION = FeatureStorageConfiguration.copy$default((FeatureStorageConfiguration)FeatureStorageConfiguration.Companion.getDEFAULT(), (long)0xA00000L, (int)0, (long)0xA00000L, (long)0L, (int)10, null);
    @NotNull
    public static final String REQUIRES_APPLICATION_CONTEXT_WARN_MESSAGE = "Session Replay could not be initialized without the Application context.";
    @NotNull
    public static final String SESSION_SAMPLED_OUT_MESSAGE = "This session was sampled out from recording. No replay will be provided for it.";
    @NotNull
    public static final String UNSUPPORTED_EVENT_TYPE = "Session Replay feature receive an event of unsupported type=%s.";
    @NotNull
    public static final String UNKNOWN_EVENT_TYPE_PROPERTY_VALUE = "Session Replay feature received an event with unknown value of \"type\" property=%s.";
    @NotNull
    public static final String EVENT_MISSING_MANDATORY_FIELDS = "Session Replay feature received an event where one or more mandatory (keepSession) fields are either missing or have wrong type.";
    @NotNull
    public static final String CANNOT_START_RECORDING_NOT_INITIALIZED = "Cannot start session recording, because Session Replay feature is not initialized.";
    @NotNull
    public static final String SESSION_REPLAY_FEATURE_NAME = "session-replay";
    @NotNull
    public static final String SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY = "type";
    @NotNull
    public static final String RUM_SESSION_RENEWED_BUS_MESSAGE = "rum_session_renewed";
    @NotNull
    public static final String RUM_KEEP_SESSION_BUS_MESSAGE_KEY = "keepSession";
    @NotNull
    public static final String RUM_SESSION_ID_BUS_MESSAGE_KEY = "sessionId";
    @NotNull
    public static final String SESSION_REPLAY_SAMPLE_RATE_KEY = "session_replay_sample_rate";
    @NotNull
    public static final String SESSION_REPLAY_TEXT_AND_INPUT_PRIVACY_KEY = "session_replay_text_and_input_privacy";
    @NotNull
    public static final String SESSION_REPLAY_IMAGE_PRIVACY_KEY = "session_replay_image_privacy";
    @NotNull
    public static final String SESSION_REPLAY_TOUCH_PRIVACY_KEY = "session_replay_touch_privacy";
    @NotNull
    public static final String SESSION_REPLAY_START_IMMEDIATE_RECORDING_KEY = "session_replay_start_immediate_recording";
    @NotNull
    public static final String SESSION_REPLAY_ENABLED_KEY = "session_replay_is_enabled";

    public SessionReplayFeature(@NotNull FeatureSdkCore sdkCore, @Nullable String customEndpointUrl, @NotNull SessionReplayPrivacy privacy, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull TouchPrivacy touchPrivacy, @NotNull ImagePrivacy imagePrivacy, @NotNull Sampler<Unit> rateBasedSampler, boolean startRecordingImmediately, @NotNull RecorderProvider recorderProvider) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)((Object)privacy), (String)"privacy");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacy, (String)"touchPrivacy");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter(rateBasedSampler, (String)"rateBasedSampler");
        Intrinsics.checkNotNullParameter((Object)recorderProvider, (String)"recorderProvider");
        this.sdkCore = sdkCore;
        this.customEndpointUrl = customEndpointUrl;
        this.privacy = privacy;
        this.textAndInputPrivacy = textAndInputPrivacy;
        this.touchPrivacy = touchPrivacy;
        this.imagePrivacy = imagePrivacy;
        this.rateBasedSampler = rateBasedSampler;
        this.startRecordingImmediately = startRecordingImmediately;
        this.recorderProvider = recorderProvider;
        this.currentRumSessionId = new AtomicReference();
        this.shouldRecord = new AtomicBoolean(this.startRecordingImmediately);
        this.recordingStateChanged = new AtomicBoolean(false);
        this.isRecording = new AtomicBoolean(false);
        this.isSessionSampledIn = new AtomicBoolean(false);
        this.sessionReplayRecorder = new NoOpRecorder();
        this.dataWriter = new NoOpRecordWriter();
        this.initialized = new AtomicBoolean(false);
        this.name = SESSION_REPLAY_FEATURE_NAME;
        this.requestFactory = new SegmentRequestFactory(this.customEndpointUrl, new BatchesToSegmentsMapper(this.sdkCore.getInternalLogger()), null, 4, null);
        this.storageConfiguration = STORAGE_CONFIGURATION;
    }

    @NotNull
    public final SessionReplayPrivacy getPrivacy$dd_sdk_android_session_replay_release() {
        return this.privacy;
    }

    @NotNull
    public final TextAndInputPrivacy getTextAndInputPrivacy$dd_sdk_android_session_replay_release() {
        return this.textAndInputPrivacy;
    }

    @NotNull
    public final TouchPrivacy getTouchPrivacy$dd_sdk_android_session_replay_release() {
        return this.touchPrivacy;
    }

    @NotNull
    public final ImagePrivacy getImagePrivacy$dd_sdk_android_session_replay_release() {
        return this.imagePrivacy;
    }

    public SessionReplayFeature(@NotNull FeatureSdkCore sdkCore, @Nullable String customEndpointUrl, @NotNull SessionReplayPrivacy privacy, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull TouchPrivacy touchPrivacy, @NotNull TouchPrivacyManager touchPrivacyManager, @NotNull ImagePrivacy imagePrivacy, @NotNull List<? extends MapperTypeWrapper<?>> customMappers2, @NotNull List<? extends OptionSelectorDetector> customOptionSelectorDetectors, @NotNull List<? extends DrawableToColorMapper> customDrawableMappers, float sampleRate, boolean startRecordingImmediately, boolean dynamicOptimizationEnabled) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)((Object)privacy), (String)"privacy");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacy, (String)"touchPrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter(customMappers2, (String)"customMappers");
        Intrinsics.checkNotNullParameter(customOptionSelectorDetectors, (String)"customOptionSelectorDetectors");
        Intrinsics.checkNotNullParameter(customDrawableMappers, (String)"customDrawableMappers");
        this(sdkCore, customEndpointUrl, privacy, textAndInputPrivacy, touchPrivacy, imagePrivacy, (Sampler<Unit>)((Sampler)new RateBasedSampler(sampleRate)), startRecordingImmediately, new DefaultRecorderProvider(sdkCore, textAndInputPrivacy, imagePrivacy, touchPrivacyManager, customMappers2, customOptionSelectorDetectors, customDrawableMappers, dynamicOptimizationEnabled));
    }

    @NotNull
    public final Recorder getSessionReplayRecorder$dd_sdk_android_session_replay_release() {
        return this.sessionReplayRecorder;
    }

    public final void setSessionReplayRecorder$dd_sdk_android_session_replay_release(@NotNull Recorder recorder) {
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"<set-?>");
        this.sessionReplayRecorder = recorder;
    }

    @NotNull
    public final RecordWriter getDataWriter$dd_sdk_android_session_replay_release() {
        return this.dataWriter;
    }

    public final void setDataWriter$dd_sdk_android_session_replay_release(@NotNull RecordWriter recordWriter) {
        Intrinsics.checkNotNullParameter((Object)recordWriter, (String)"<set-?>");
        this.dataWriter = recordWriter;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_session_replay_release() {
        return this.initialized;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void onInitialize(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        if (!(appContext instanceof Application)) {
            this.logMissingApplicationContextError();
            return;
        }
        this.appContext = appContext;
        this.sdkCore.setEventReceiver(SESSION_REPLAY_FEATURE_NAME, (FeatureEventReceiver)this);
        ResourcesFeature resourcesFeature = this.registerResourceFeature((SdkCore)this.sdkCore);
        ResourceDataStoreManager resourceDataStoreManager = new ResourceDataStoreManager(this.sdkCore, (Serializer<ResourceHashesEntry>)((Serializer)new ResourceHashesEntrySerializer()), (Deserializer<String, ResourceHashesEntry>)((Deserializer)new ResourceHashesEntryDeserializer(this.sdkCore.getInternalLogger())));
        this.dataWriter = this.createDataWriter();
        this.sessionReplayRecorder = this.recorderProvider.provideSessionReplayRecorder(resourceDataStoreManager, resourcesFeature.getDataWriter$dd_sdk_android_session_replay_release(), this.dataWriter, (Application)appContext);
        this.sessionReplayRecorder.registerCallbacks();
        this.initialized.set(true);
        this.sdkCore.updateFeatureContext(SESSION_REPLAY_FEATURE_NAME, (Function1)new Function1<Map<String, Object>, Unit>(this){
            final /* synthetic */ SessionReplayFeature this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Map<String, Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Map<String, Object> map = it;
                String string = "session_replay_sample_rate";
                Float f = SessionReplayFeature.access$getRateBasedSampler$p(this.this$0).getSampleRate();
                Object object = f != null ? Long.valueOf((long)f.floatValue()) : null;
                map.put(string, object);
                it.put("session_replay_start_immediate_recording", SessionReplayFeature.access$getStartRecordingImmediately$p(this.this$0));
                map = it;
                string = "session_replay_touch_privacy";
                object = this.this$0.getTouchPrivacy$dd_sdk_android_session_replay_release().toString();
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string2 = ((String)object).toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                object = string2;
                map.put(string, object);
                map = it;
                string = "session_replay_image_privacy";
                object = this.this$0.getImagePrivacy$dd_sdk_android_session_replay_release().toString();
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                String string3 = ((String)object).toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                object = string3;
                map.put(string, object);
                map = it;
                string = "session_replay_text_and_input_privacy";
                object = this.this$0.getTextAndInputPrivacy$dd_sdk_android_session_replay_release().toString();
                Locale locale3 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"US");
                String string4 = ((String)object).toLowerCase(locale3);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                object = string4;
                map.put(string, object);
            }
        });
    }

    @NotNull
    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @NotNull
    public FeatureStorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void onStop() {
        this.stopRecording$dd_sdk_android_session_replay_release();
        this.sessionReplayRecorder.unregisterCallbacks();
        this.sessionReplayRecorder.stopProcessingRecords();
        this.dataWriter = new NoOpRecordWriter();
        this.sessionReplayRecorder = new NoOpRecorder();
        this.initialized.set(false);
    }

    public void onReceive(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof Map)) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(event){
                final /* synthetic */ Object $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Session Replay feature receive an event of unsupported type=%s.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$event.getClass().getCanonicalName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            return;
        }
        if (!this.checkIfInitialized()) {
            return;
        }
        this.handleRumSession((Map)event);
    }

    public final void manuallyStopRecording$dd_sdk_android_session_replay_release() {
        if (this.shouldRecord.compareAndSet(true, false)) {
            this.recordingStateChanged.set(true);
        }
    }

    public final void manuallyStartRecording$dd_sdk_android_session_replay_release() {
        if (this.shouldRecord.compareAndSet(false, true)) {
            this.recordingStateChanged.set(true);
        }
    }

    private final void handleRumSession(Map<?, ?> sessionMetadata) {
        if (Intrinsics.areEqual(sessionMetadata.get(SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY), (Object)RUM_SESSION_RENEWED_BUS_MESSAGE)) {
            SessionData sessionData = this.parseSessionMetadata(sessionMetadata);
            if (sessionData != null) {
                SessionData sessionData2 = sessionData;
                boolean bl = false;
                boolean alreadySeenSession = Intrinsics.areEqual((Object)this.currentRumSessionId.get(), (Object)sessionData2.getSessionId());
                if (this.shouldHandleSession(alreadySeenSession)) {
                    this.applySampling(alreadySeenSession);
                    this.modifyShouldRecordState(sessionData2);
                    this.handleRecording(sessionData2);
                }
            }
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(sessionMetadata){
                final /* synthetic */ Map<?, ?> $sessionMetadata;
                {
                    this.$sessionMetadata = $sessionMetadata;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Session Replay feature received an event with unknown value of \"type\" property=%s.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$sessionMetadata.get("type")};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
        }
    }

    private final SessionData parseSessionMetadata(Map<?, ?> sessionMetadata) {
        String sessionId;
        Object obj = sessionMetadata.get(RUM_KEEP_SESSION_BUS_MESSAGE_KEY);
        Boolean keepSession = obj instanceof Boolean ? (Boolean)obj : null;
        Object obj2 = sessionMetadata.get(RUM_SESSION_ID_BUS_MESSAGE_KEY);
        String string = sessionId = obj2 instanceof String ? (String)obj2 : null;
        if (keepSession == null || sessionId == null) {
            this.logEventMissingMandatoryFieldsError();
            return null;
        }
        return new SessionData(keepSession, sessionId);
    }

    private final boolean shouldHandleSession(boolean alreadySeenSession) {
        return !alreadySeenSession || this.recordingStateChanged.get();
    }

    private final void applySampling(boolean alreadySeenSession) {
        if (!alreadySeenSession) {
            this.isSessionSampledIn.set(this.rateBasedSampler.sample((Object)Unit.INSTANCE));
        }
    }

    private final void modifyShouldRecordState(SessionData sessionData) {
        boolean isSampledIn;
        boolean bl = isSampledIn = sessionData.getKeepSession() && this.isSessionSampledIn.get();
        if (!isSampledIn && this.shouldRecord.compareAndSet(true, false)) {
            this.logSampledOutMessage();
        }
    }

    private final void logMissingApplicationContextError() {
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)logMissingApplicationContextError.1.INSTANCE, null, (boolean)false, null, (int)56, null);
    }

    private final void logEventMissingMandatoryFieldsError() {
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)logEventMissingMandatoryFieldsError.1.INSTANCE, null, (boolean)false, null, (int)56, null);
    }

    private final void logSampledOutMessage() {
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)logSampledOutMessage.1.INSTANCE, null, (boolean)false, null, (int)56, null);
    }

    private final void logNotInitializedError() {
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)logNotInitializedError.1.INSTANCE, null, (boolean)false, null, (int)56, null);
    }

    private final void handleRecording(SessionData sessionData) {
        if (this.shouldRecord.get()) {
            this.startRecording$dd_sdk_android_session_replay_release();
        } else {
            this.stopRecording$dd_sdk_android_session_replay_release();
        }
        this.recordingStateChanged.set(false);
        this.currentRumSessionId.set(sessionData.getSessionId());
    }

    private final boolean checkIfInitialized() {
        if (!this.initialized.get()) {
            this.logNotInitializedError();
            return false;
        }
        return true;
    }

    public final void startRecording$dd_sdk_android_session_replay_release() {
        if (this.checkIfInitialized() && !this.isRecording.getAndSet(true)) {
            this.sdkCore.updateFeatureContext(SESSION_REPLAY_FEATURE_NAME, (Function1)startRecording.1.INSTANCE);
            this.sessionReplayRecorder.resumeRecorders();
        }
    }

    private final RecordWriter createDataWriter() {
        SessionReplayRecordCallback recordCallback = new SessionReplayRecordCallback(this.sdkCore);
        return new SessionReplayRecordWriter(this.sdkCore, recordCallback);
    }

    public final void stopRecording$dd_sdk_android_session_replay_release() {
        if (this.isRecording.getAndSet(false)) {
            this.sdkCore.updateFeatureContext(SESSION_REPLAY_FEATURE_NAME, (Function1)stopRecording.1.INSTANCE);
            this.sessionReplayRecorder.stopRecorders();
        }
    }

    private final ResourcesFeature registerResourceFeature(SdkCore sdkCore) {
        Intrinsics.checkNotNull((Object)sdkCore, (String)"null cannot be cast to non-null type com.datadog.android.api.feature.FeatureSdkCore");
        ResourcesFeature resourcesFeature = new ResourcesFeature((FeatureSdkCore)sdkCore, this.customEndpointUrl);
        ((FeatureSdkCore)sdkCore).registerFeature((Feature)resourcesFeature);
        return resourcesFeature;
    }

    public static final /* synthetic */ Sampler access$getRateBasedSampler$p(SessionReplayFeature $this) {
        return $this.rateBasedSampler;
    }

    public static final /* synthetic */ boolean access$getStartRecordingImmediately$p(SessionReplayFeature $this) {
        return $this.startRecordingImmediately;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayFeature$Companion;", "", "()V", "CANNOT_START_RECORDING_NOT_INITIALIZED", "", "EVENT_MISSING_MANDATORY_FIELDS", "REQUIRES_APPLICATION_CONTEXT_WARN_MESSAGE", "RUM_KEEP_SESSION_BUS_MESSAGE_KEY", "RUM_SESSION_ID_BUS_MESSAGE_KEY", "RUM_SESSION_RENEWED_BUS_MESSAGE", "SESSION_REPLAY_BUS_MESSAGE_TYPE_KEY", "SESSION_REPLAY_ENABLED_KEY", "SESSION_REPLAY_FEATURE_NAME", "SESSION_REPLAY_IMAGE_PRIVACY_KEY", "SESSION_REPLAY_SAMPLE_RATE_KEY", "SESSION_REPLAY_START_IMMEDIATE_RECORDING_KEY", "SESSION_REPLAY_TEXT_AND_INPUT_PRIVACY_KEY", "SESSION_REPLAY_TOUCH_PRIVACY_KEY", "SESSION_SAMPLED_OUT_MESSAGE", "STORAGE_CONFIGURATION", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "getSTORAGE_CONFIGURATION$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "UNKNOWN_EVENT_TYPE_PROPERTY_VALUE", "UNSUPPORTED_EVENT_TYPE", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FeatureStorageConfiguration getSTORAGE_CONFIGURATION$dd_sdk_android_session_replay_release() {
            return STORAGE_CONFIGURATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayFeature$SessionData;", "", "keepSession", "", "sessionId", "", "(ZLjava/lang/String;)V", "getKeepSession", "()Z", "getSessionId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "dd-sdk-android-session-replay_release"})
    private static final class SessionData {
        private final boolean keepSession;
        @NotNull
        private final String sessionId;

        public SessionData(boolean keepSession, @NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)SessionReplayFeature.RUM_SESSION_ID_BUS_MESSAGE_KEY);
            this.keepSession = keepSession;
            this.sessionId = sessionId;
        }

        public final boolean getKeepSession() {
            return this.keepSession;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        public final boolean component1() {
            return this.keepSession;
        }

        @NotNull
        public final String component2() {
            return this.sessionId;
        }

        @NotNull
        public final SessionData copy(boolean keepSession, @NotNull String sessionId) {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)SessionReplayFeature.RUM_SESSION_ID_BUS_MESSAGE_KEY);
            return new SessionData(keepSession, sessionId);
        }

        public static /* synthetic */ SessionData copy$default(SessionData sessionData, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                bl = sessionData.keepSession;
            }
            if ((n & 2) != 0) {
                string = sessionData.sessionId;
            }
            return sessionData.copy(bl, string);
        }

        @NotNull
        public String toString() {
            return "SessionData(keepSession=" + this.keepSession + ", sessionId=" + this.sessionId + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.keepSession);
            result2 = result2 * 31 + this.sessionId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionData)) {
                return false;
            }
            SessionData sessionData = (SessionData)other;
            if (this.keepSession != sessionData.keepSession) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sessionId, (Object)sessionData.sessionId);
        }
    }
}

