/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal;

import android.app.Activity;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.MainThread;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.datadog.android.sessionreplay.internal.LifecycleCallback;
import com.datadog.android.sessionreplay.internal.recorder.callback.OnWindowRefreshedCallback;
import com.datadog.android.sessionreplay.internal.recorder.callback.RecorderFragmentLifecycleCallback;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0010H\u0017J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0016\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016J\u0016\u0010\u001a\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayLifecycleCallback;", "Lcom/datadog/android/sessionreplay/internal/LifecycleCallback;", "Lcom/datadog/android/sessionreplay/internal/recorder/callback/OnWindowRefreshedCallback;", "onWindowRefreshedCallback", "(Lcom/datadog/android/sessionreplay/internal/recorder/callback/OnWindowRefreshedCallback;)V", "currentActiveWindows", "Ljava/util/WeakHashMap;", "Landroid/view/Window;", "", "getCurrentWindows", "", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "onWindowsAdded", "windows", "onWindowsRemoved", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nSessionReplayLifecycleCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionReplayLifecycleCallback.kt\ncom/datadog/android/sessionreplay/internal/SessionReplayLifecycleCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1855#2,2:92\n1855#2,2:94\n*S KotlinDebug\n*F\n+ 1 SessionReplayLifecycleCallback.kt\ncom/datadog/android/sessionreplay/internal/SessionReplayLifecycleCallback\n*L\n25#1:92,2\n32#1:94,2\n*E\n"})
public final class SessionReplayLifecycleCallback
implements LifecycleCallback,
OnWindowRefreshedCallback {
    @NotNull
    private final OnWindowRefreshedCallback onWindowRefreshedCallback;
    @NotNull
    private final WeakHashMap<Window, Object> currentActiveWindows;

    public SessionReplayLifecycleCallback(@NotNull OnWindowRefreshedCallback onWindowRefreshedCallback) {
        Intrinsics.checkNotNullParameter((Object)onWindowRefreshedCallback, (String)"onWindowRefreshedCallback");
        this.onWindowRefreshedCallback = onWindowRefreshedCallback;
        this.currentActiveWindows = new WeakHashMap();
    }

    @Override
    public void onWindowsAdded(@NotNull List<? extends Window> windows) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        Iterable $this$forEach$iv = windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window it = (Window)element$iv;
            boolean bl = false;
            ((Map)this.currentActiveWindows).put(it, null);
        }
        this.onWindowRefreshedCallback.onWindowsAdded(windows);
    }

    @Override
    public void onWindowsRemoved(@NotNull List<? extends Window> windows) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        Iterable $this$forEach$iv = windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window it = (Window)element$iv;
            boolean bl = false;
            this.currentActiveWindows.remove(it);
        }
        this.onWindowRefreshedCallback.onWindowsRemoved(windows);
    }

    @Override
    @NotNull
    public List<Window> getCurrentWindows() {
        Set<Window> set = this.currentActiveWindows.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"currentActiveWindows.keys");
        return CollectionsKt.toList((Iterable)set);
    }

    @MainThread
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (activity instanceof FragmentActivity) {
            RecorderFragmentLifecycleCallback lifecycleCallback = new RecorderFragmentLifecycleCallback(this);
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)lifecycleCallback, true);
        }
    }

    @MainThread
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityResumed(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Window window = activity.getWindow();
            if (window == null) break block0;
            Window it = window;
            boolean bl = false;
            ((Map)this.currentActiveWindows).put(it, null);
            this.onWindowRefreshedCallback.onWindowsAdded(CollectionsKt.listOf((Object)it));
        }
    }

    @MainThread
    public void onActivityPaused(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Window window = activity.getWindow();
            if (window == null) break block0;
            Window it = window;
            boolean bl = false;
            this.currentActiveWindows.remove(it);
            this.onWindowRefreshedCallback.onWindowsRemoved(CollectionsKt.listOf((Object)it));
        }
    }

    @MainThread
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    @MainThread
    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }
}

