/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal;

import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.sessionreplay.internal.RecordCallback;
import com.datadog.android.sessionreplay.internal.processor.EnrichedRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\u00062\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayRecordCallback;", "Lcom/datadog/android/sessionreplay/internal/RecordCallback;", "featureSdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;)V", "onRecordForViewSent", "", "record", "Lcom/datadog/android/sessionreplay/internal/processor/EnrichedRecord;", "updateRecordsCount", "viewMetadata", "", "", "", "recordsCount", "", "Companion", "dd-sdk-android-session-replay_release"})
public final class SessionReplayRecordCallback
implements RecordCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore featureSdkCore;
    @NotNull
    public static final String HAS_REPLAY_KEY = "has_replay";
    @NotNull
    public static final String VIEW_RECORDS_COUNT_KEY = "records_count";

    public SessionReplayRecordCallback(@NotNull FeatureSdkCore featureSdkCore) {
        Intrinsics.checkNotNullParameter((Object)featureSdkCore, (String)"featureSdkCore");
        this.featureSdkCore = featureSdkCore;
    }

    @Override
    public void onRecordForViewSent(@NotNull EnrichedRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        int recordsSize = record.getRecords().size();
        if (recordsSize > 0) {
            this.featureSdkCore.updateFeatureContext("session-replay", (Function1)new Function1<Map<String, Object>, Unit>(record, this, recordsSize){
                final /* synthetic */ EnrichedRecord $record;
                final /* synthetic */ SessionReplayRecordCallback this$0;
                final /* synthetic */ int $recordsSize;
                {
                    this.$record = $record;
                    this.this$0 = $receiver;
                    this.$recordsSize = $recordsSize;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    String viewId = this.$record.getViewId();
                    Object object = it.get(viewId);
                    Map map = TypeIntrinsics.isMutableMap((Object)object) ? (Map)object : null;
                    if (map == null) {
                        map = new LinkedHashMap<K, V>();
                    }
                    Map viewMetadata = map;
                    viewMetadata.put("has_replay", true);
                    SessionReplayRecordCallback.access$updateRecordsCount(this.this$0, viewMetadata, this.$recordsSize);
                    it.put(viewId, viewMetadata);
                }
            });
        }
    }

    private final void updateRecordsCount(Map<String, Object> viewMetadata, int recordsCount) {
        Object object = viewMetadata.get(VIEW_RECORDS_COUNT_KEY);
        Long l = object instanceof Long ? (Long)object : null;
        long currentRecords = l != null ? l : 0L;
        long newRecords = currentRecords + (long)recordsCount;
        Long l2 = newRecords;
        viewMetadata.put(VIEW_RECORDS_COUNT_KEY, l2);
    }

    public static final /* synthetic */ void access$updateRecordsCount(SessionReplayRecordCallback $this, Map viewMetadata, int recordsCount) {
        $this.updateRecordsCount(viewMetadata, recordsCount);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/sessionreplay/internal/SessionReplayRecordCallback$Companion;", "", "()V", "HAS_REPLAY_KEY", "", "VIEW_RECORDS_COUNT_KEY", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

