/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal;

import android.graphics.Point;
import android.graphics.Rect;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.datadog.android.lint.InternalApi;
import com.datadog.android.sessionreplay.TouchPrivacy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0003H\u0007J\u0019\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u000fH\u0001\u00a2\u0006\u0002\b\u0010J\u0019\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u000fH\u0001\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u0019R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "", "globalTouchPrivacy", "Lcom/datadog/android/sessionreplay/TouchPrivacy;", "(Lcom/datadog/android/sessionreplay/TouchPrivacy;)V", "currentOverrideAreas", "Ljava/util/HashMap;", "Landroid/graphics/Rect;", "Lkotlin/collections/HashMap;", "nextOverrideAreas", "addTouchOverrideArea", "", "bounds", "touchPrivacy", "getCurrentOverrideAreas", "", "getCurrentOverrideAreas$dd_sdk_android_session_replay_release", "getNextOverrideAreas", "getNextOverrideAreas$dd_sdk_android_session_replay_release", "shouldRecordTouch", "", "touchLocation", "Landroid/graphics/Point;", "shouldRecordTouch$dd_sdk_android_session_replay_release", "updateCurrentTouchOverrideAreas", "updateCurrentTouchOverrideAreas$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
@InternalApi
@SourceDebugExtension(value={"SMAP\nTouchPrivacyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TouchPrivacyManager.kt\ncom/datadog/android/sessionreplay/internal/TouchPrivacyManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,81:1\n215#2,2:82\n*S KotlinDebug\n*F\n+ 1 TouchPrivacyManager.kt\ncom/datadog/android/sessionreplay/internal/TouchPrivacyManager\n*L\n56#1:82,2\n*E\n"})
public final class TouchPrivacyManager {
    @NotNull
    private final TouchPrivacy globalTouchPrivacy;
    @NotNull
    private final HashMap<Rect, TouchPrivacy> currentOverrideAreas;
    @NotNull
    private final HashMap<Rect, TouchPrivacy> nextOverrideAreas;

    public TouchPrivacyManager(@NotNull TouchPrivacy globalTouchPrivacy) {
        Intrinsics.checkNotNullParameter((Object)globalTouchPrivacy, (String)"globalTouchPrivacy");
        this.globalTouchPrivacy = globalTouchPrivacy;
        this.currentOverrideAreas = new HashMap();
        this.nextOverrideAreas = new HashMap();
    }

    @UiThread
    public final void addTouchOverrideArea(@NotNull Rect bounds, @NotNull TouchPrivacy touchPrivacy) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)touchPrivacy, (String)"touchPrivacy");
        ((Map)this.nextOverrideAreas).put(bounds, touchPrivacy);
    }

    @UiThread
    public final void updateCurrentTouchOverrideAreas$dd_sdk_android_session_replay_release() {
        this.currentOverrideAreas.clear();
        this.currentOverrideAreas.putAll((Map<Rect, TouchPrivacy>)this.nextOverrideAreas);
        this.nextOverrideAreas.clear();
    }

    @UiThread
    public final boolean shouldRecordTouch$dd_sdk_android_session_replay_release(@NotNull Point touchLocation) {
        Intrinsics.checkNotNullParameter((Object)touchLocation, (String)"touchLocation");
        boolean isOverriddenToShowTouch = false;
        Map $this$forEach$iv = this.currentOverrideAreas;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Rect area = (Rect)entry.getKey();
            TouchPrivacy overrideValue = (TouchPrivacy)entry.getValue();
            if (!area.contains(touchLocation.x, touchLocation.y)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[overrideValue.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    isOverriddenToShowTouch = true;
                }
            }
        }
        return isOverriddenToShowTouch ? true : this.globalTouchPrivacy == TouchPrivacy.SHOW;
    }

    @VisibleForTesting
    @NotNull
    public final Map<Rect, TouchPrivacy> getCurrentOverrideAreas$dd_sdk_android_session_replay_release() {
        return this.currentOverrideAreas;
    }

    @VisibleForTesting
    @NotNull
    public final Map<Rect, TouchPrivacy> getNextOverrideAreas$dd_sdk_android_session_replay_release() {
        return this.nextOverrideAreas;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TouchPrivacy.values().length];
            try {
                nArray[TouchPrivacy.HIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TouchPrivacy.SHOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

