/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.async;

import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.sessionreplay.internal.async.DataQueueHandler;
import com.datadog.android.sessionreplay.internal.async.RecordedDataQueueHandler;
import com.datadog.android.sessionreplay.internal.async.RecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.async.ResourceRecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.async.SnapshotRecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.async.TouchEventRecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.processor.RecordedDataProcessor;
import com.datadog.android.sessionreplay.internal.processor.RecordedQueuedItemContext;
import com.datadog.android.sessionreplay.internal.processor.RumContextDataHandler;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.SystemInformation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0017J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\fH\u0002J\u0014\u0010$\u001a\u00020!2\n\u0010%\u001a\u00060&j\u0002`'H\u0002J\u0012\u0010(\u001a\u00020!2\b\u0010)\u001a\u0004\u0018\u00010\fH\u0003J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\u0011H\u0003J\u0010\u0010,\u001a\u00020!2\u0006\u0010+\u001a\u00020\u0018H\u0003J\u0010\u0010-\u001a\u00020!2\u0006\u0010+\u001a\u00020\u001cH\u0003J\b\u0010.\u001a\u00020!H\u0003J\b\u0010/\u001a\u00020!H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler;", "Lcom/datadog/android/sessionreplay/internal/async/DataQueueHandler;", "processor", "Lcom/datadog/android/sessionreplay/internal/processor/RecordedDataProcessor;", "rumContextDataHandler", "Lcom/datadog/android/sessionreplay/internal/processor/RumContextDataHandler;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "executorService", "Ljava/util/concurrent/ExecutorService;", "recordedDataQueue", "Ljava/util/Queue;", "Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueItem;", "(Lcom/datadog/android/sessionreplay/internal/processor/RecordedDataProcessor;Lcom/datadog/android/sessionreplay/internal/processor/RumContextDataHandler;Lcom/datadog/android/api/InternalLogger;Ljava/util/concurrent/ExecutorService;Ljava/util/Queue;)V", "getRecordedDataQueue$dd_sdk_android_session_replay_release", "()Ljava/util/Queue;", "addResourceItem", "Lcom/datadog/android/sessionreplay/internal/async/ResourceRecordedDataQueueItem;", "identifier", "", "applicationId", "resourceData", "", "addSnapshotItem", "Lcom/datadog/android/sessionreplay/internal/async/SnapshotRecordedDataQueueItem;", "systemInformation", "Lcom/datadog/android/sessionreplay/recorder/SystemInformation;", "addTouchEventItem", "Lcom/datadog/android/sessionreplay/internal/async/TouchEventRecordedDataQueueItem;", "pointerInteractions", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$MobileRecord;", "clearAndStopProcessingQueue", "", "insertIntoRecordedDataQueue", "recordedDataQueueItem", "logAddToQueueException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processItem", "nextItem", "processResourceEvent", "item", "processSnapshotEvent", "processTouchEvent", "triggerProcessingLoop", "tryToConsumeItems", "Companion", "dd-sdk-android-session-replay_release"})
public final class RecordedDataQueueHandler
implements DataQueueHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private RecordedDataProcessor processor;
    @NotNull
    private RumContextDataHandler rumContextDataHandler;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final Queue<RecordedDataQueueItem> recordedDataQueue;
    public static final long MAX_DELAY_NS = 1000000000L;
    @NotNull
    public static final String FAILED_TO_ADD_RECORDS_TO_QUEUE_ERROR_MESSAGE = "SR RecordedDataQueueHandler: failed to add records into the queue";
    @NotNull
    public static final String ITEM_DROPPED_INVALID_MESSAGE = "SR RecordedDataQueueHandler: dropped item from the queue. isValid=false, type=%s";
    @NotNull
    public static final String ITEM_DROPPED_EXPIRED_MESSAGE = "SR RecordedDataQueueHandler: dropped item from the queue. age=%d ns";

    public RecordedDataQueueHandler(@NotNull RecordedDataProcessor processor, @NotNull RumContextDataHandler rumContextDataHandler, @NotNull InternalLogger internalLogger, @NotNull ExecutorService executorService, @NotNull Queue<RecordedDataQueueItem> recordedDataQueue) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)rumContextDataHandler, (String)"rumContextDataHandler");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter(recordedDataQueue, (String)"recordedDataQueue");
        this.processor = processor;
        this.rumContextDataHandler = rumContextDataHandler;
        this.internalLogger = internalLogger;
        this.executorService = executorService;
        this.recordedDataQueue = recordedDataQueue;
    }

    @NotNull
    public final Queue<RecordedDataQueueItem> getRecordedDataQueue$dd_sdk_android_session_replay_release() {
        return this.recordedDataQueue;
    }

    @Override
    public synchronized void clearAndStopProcessingQueue() {
        this.recordedDataQueue.clear();
        this.executorService.shutdown();
    }

    @Override
    @MainThread
    @Nullable
    public ResourceRecordedDataQueueItem addResourceItem(@NotNull String identifier, @NotNull String applicationId, @NotNull byte[] resourceData) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)resourceData, (String)"resourceData");
        RecordedQueuedItemContext recordedQueuedItemContext = this.rumContextDataHandler.createRumContextData$dd_sdk_android_session_replay_release();
        if (recordedQueuedItemContext == null) {
            return null;
        }
        RecordedQueuedItemContext rumContextData = recordedQueuedItemContext;
        ResourceRecordedDataQueueItem item = new ResourceRecordedDataQueueItem(rumContextData, identifier, applicationId, resourceData);
        this.insertIntoRecordedDataQueue(item);
        return item;
    }

    @Override
    @MainThread
    @Nullable
    public TouchEventRecordedDataQueueItem addTouchEventItem(@NotNull List<? extends MobileSegment.MobileRecord> pointerInteractions) {
        Intrinsics.checkNotNullParameter(pointerInteractions, (String)"pointerInteractions");
        RecordedQueuedItemContext recordedQueuedItemContext = this.rumContextDataHandler.createRumContextData$dd_sdk_android_session_replay_release();
        if (recordedQueuedItemContext == null) {
            return null;
        }
        RecordedQueuedItemContext rumContextData = recordedQueuedItemContext;
        TouchEventRecordedDataQueueItem item = new TouchEventRecordedDataQueueItem(rumContextData, pointerInteractions);
        this.insertIntoRecordedDataQueue(item);
        return item;
    }

    @Override
    @MainThread
    @Nullable
    public SnapshotRecordedDataQueueItem addSnapshotItem(@NotNull SystemInformation systemInformation) {
        Intrinsics.checkNotNullParameter((Object)systemInformation, (String)"systemInformation");
        RecordedQueuedItemContext recordedQueuedItemContext = this.rumContextDataHandler.createRumContextData$dd_sdk_android_session_replay_release();
        if (recordedQueuedItemContext == null) {
            return null;
        }
        RecordedQueuedItemContext rumContextData = recordedQueuedItemContext;
        SnapshotRecordedDataQueueItem item = new SnapshotRecordedDataQueueItem(rumContextData, systemInformation);
        this.insertIntoRecordedDataQueue(item);
        return item;
    }

    @Override
    @MainThread
    public void tryToConsumeItems() {
        if (this.recordedDataQueue.isEmpty()) {
            return;
        }
        ConcurrencyExtKt.executeSafe((Executor)this.executorService, (String)"Recorded Data queue processing", (InternalLogger)this.internalLogger, () -> RecordedDataQueueHandler.tryToConsumeItems$lambda$0(this));
    }

    @WorkerThread
    private final synchronized void triggerProcessingLoop() {
        while (!((Collection)this.recordedDataQueue).isEmpty()) {
            Object[] objectArray;
            RecordedDataQueueItem nextItem = this.recordedDataQueue.peek();
            if (nextItem == null) continue;
            long nextItemAgeInNs = System.nanoTime() - nextItem.getCreationTimeStampInNs$dd_sdk_android_session_replay_release();
            if (!nextItem.isValid$dd_sdk_android_session_replay_release()) {
                objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(nextItem){
                    final /* synthetic */ RecordedDataQueueItem $nextItem;
                    {
                        this.$nextItem = $nextItem;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "SR RecordedDataQueueHandler: dropped item from the queue. isValid=false, type=%s";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[1];
                        RecordedDataQueueItem recordedDataQueueItem = this.$nextItem;
                        Intrinsics.checkNotNullExpressionValue((Object)recordedDataQueueItem, (String)"nextItem");
                        objectArray[0] = recordedDataQueueItem.getClass().getSimpleName();
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }), null, (boolean)false, null, (int)56, null);
                this.recordedDataQueue.poll();
                continue;
            }
            if (nextItemAgeInNs > 1000000000L) {
                objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(nextItemAgeInNs){
                    final /* synthetic */ long $nextItemAgeInNs;
                    {
                        this.$nextItemAgeInNs = $nextItemAgeInNs;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "SR RecordedDataQueueHandler: dropped item from the queue. age=%d ns";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$nextItemAgeInNs};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }), null, (boolean)false, null, (int)56, null);
                this.recordedDataQueue.poll();
                continue;
            }
            if (!nextItem.isReady$dd_sdk_android_session_replay_release()) break;
            this.processItem(this.recordedDataQueue.poll());
        }
    }

    @WorkerThread
    private final void processItem(RecordedDataQueueItem nextItem) {
        RecordedDataQueueItem recordedDataQueueItem = nextItem;
        if (recordedDataQueueItem instanceof SnapshotRecordedDataQueueItem) {
            this.processSnapshotEvent((SnapshotRecordedDataQueueItem)nextItem);
        } else if (recordedDataQueueItem instanceof TouchEventRecordedDataQueueItem) {
            this.processTouchEvent((TouchEventRecordedDataQueueItem)nextItem);
        } else if (recordedDataQueueItem instanceof ResourceRecordedDataQueueItem) {
            this.processResourceEvent((ResourceRecordedDataQueueItem)nextItem);
        }
    }

    @WorkerThread
    private final void processSnapshotEvent(SnapshotRecordedDataQueueItem item) {
        this.processor.processScreenSnapshots(item);
    }

    @WorkerThread
    private final void processResourceEvent(ResourceRecordedDataQueueItem item) {
        this.processor.processResources(item);
    }

    @WorkerThread
    private final void processTouchEvent(TouchEventRecordedDataQueueItem item) {
        this.processor.processTouchEventsRecords(item);
    }

    private final void insertIntoRecordedDataQueue(RecordedDataQueueItem recordedDataQueueItem) {
        try {
            this.recordedDataQueue.offer(recordedDataQueueItem);
        }
        catch (IllegalArgumentException e) {
            this.logAddToQueueException(e);
        }
        catch (ClassCastException e) {
            this.logAddToQueueException(e);
        }
        catch (NullPointerException e) {
            this.logAddToQueueException(e);
        }
    }

    private final void logAddToQueueException(Exception e) {
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)logAddToQueueException.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
    }

    private static final void tryToConsumeItems$lambda$0(RecordedDataQueueHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.triggerProcessingLoop();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u0016\u0010\u0007\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0016\u0010\t\u001a\u00020\n8\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u00a8\u0006\f"}, d2={"Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler$Companion;", "", "()V", "FAILED_TO_ADD_RECORDS_TO_QUEUE_ERROR_MESSAGE", "", "ITEM_DROPPED_EXPIRED_MESSAGE", "getITEM_DROPPED_EXPIRED_MESSAGE$dd_sdk_android_session_replay_release$annotations", "ITEM_DROPPED_INVALID_MESSAGE", "getITEM_DROPPED_INVALID_MESSAGE$dd_sdk_android_session_replay_release$annotations", "MAX_DELAY_NS", "", "getMAX_DELAY_NS$dd_sdk_android_session_replay_release$annotations", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_DELAY_NS$dd_sdk_android_session_replay_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getITEM_DROPPED_INVALID_MESSAGE$dd_sdk_android_session_replay_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getITEM_DROPPED_EXPIRED_MESSAGE$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

