/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.net;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.sessionreplay.internal.gson.GsonExtKt;
import com.datadog.android.sessionreplay.internal.net.BatchesToSegmentsMapper;
import com.datadog.android.sessionreplay.internal.processor.MobileSegmentExtKt;
import com.datadog.android.sessionreplay.internal.utils.SessionReplayRumContext;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J.\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J.\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\tH\u0002J\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/BatchesToSegmentsMapper;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "groupBatchDataIntoSegments", "", "Lkotlin/Pair;", "Lcom/datadog/android/sessionreplay/model/MobileSegment;", "Lcom/google/gson/JsonObject;", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "batchData", "", "hasFullSnapshotRecord", "", "records", "Lcom/google/gson/JsonArray;", "map", "mapToSegment", "rumContext", "Lcom/datadog/android/sessionreplay/internal/utils/SessionReplayRumContext;", "timestamp", "", "(Lcom/google/gson/JsonObject;)Ljava/lang/Long;", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nBatchesToSegmentsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatchesToSegmentsMapper.kt\ncom/datadog/android/sessionreplay/internal/net/BatchesToSegmentsMapper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n988#2:202\n1017#2,3:203\n1020#2,3:213\n603#2:244\n1284#2,3:245\n372#3,7:206\n453#3:216\n403#3:217\n526#3:224\n511#3,6:225\n1238#4,2:218\n1789#4,3:220\n1241#4:223\n1747#4,3:248\n135#5,9:231\n215#5:240\n216#5:242\n144#5:243\n1#6:241\n*S KotlinDebug\n*F\n+ 1 BatchesToSegmentsMapper.kt\ncom/datadog/android/sessionreplay/internal/net/BatchesToSegmentsMapper\n*L\n72#1:202\n72#1:203,3\n72#1:213,3\n104#1:244\n106#1:245,3\n72#1:206,7\n73#1:216\n73#1:217\n79#1:224\n79#1:225,6\n73#1:218,2\n74#1:220,3\n73#1:223\n151#1:248,3\n80#1:231,9\n80#1:240\n80#1:242\n80#1:243\n80#1:241\n*E\n"})
public final class BatchesToSegmentsMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    private static final long FULL_SNAPSHOT_RECORD_TYPE_MOBILE = 10L;
    private static final long FULL_SNAPSHOT_RECORD_TYPE_BROWSER = 2L;
    @NotNull
    public static final String RECORDS_KEY = "records";
    @NotNull
    private static final String RECORD_TYPE_KEY = "type";
    @NotNull
    public static final String TIMESTAMP_KEY = "timestamp";
    @NotNull
    public static final String UNABLE_TO_DESERIALIZE_ENRICHED_RECORD_ERROR_MESSAGE = "SR BatchesToSegmentMapper: unable to deserialize EnrichedRecord";
    @NotNull
    public static final String ILLEGAL_STATE_ENRICHED_RECORD_ERROR_MESSAGE = "SR BatchesToSegmentMapper: Enriched record was missing the context information";

    public BatchesToSegmentsMapper(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final List<Pair<MobileSegment, JsonObject>> map(@NotNull DatadogContext datadogContext, @NotNull List<byte[]> batchData) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        return this.groupBatchDataIntoSegments(datadogContext, batchData);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<MobileSegment, JsonObject>> groupBatchDataIntoSegments(DatadogContext datadogContext, List<byte[]> batchData) {
        void $this$mapNotNullTo$iv$iv;
        Map $this$filterTo$iv$iv;
        Map $this$mapValuesTo$iv$iv;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        Object it;
        Map $this$groupByTo$iv$iv;
        Sequence $this$groupBy$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)batchData), (Function1)((Function1)new Function1<byte[], JsonObject>(this){
            final /* synthetic */ BatchesToSegmentsMapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final JsonObject invoke(@NotNull byte[] it) {
                JsonObject jsonObject;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    JsonElement jsonElement = JsonParser.parseString((String)new String(it, Charsets.UTF_8));
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseString(String(it))");
                    jsonObject = GsonExtKt.safeGetAsJsonObject(jsonElement, BatchesToSegmentsMapper.access$getInternalLogger$p(this.this$0));
                }
                catch (JsonParseException e) {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)BatchesToSegmentsMapper.access$getInternalLogger$p(this.this$0), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)groupBatchDataIntoSegments.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
                    jsonObject = null;
                }
                catch (IllegalStateException e) {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)BatchesToSegmentsMapper.access$getInternalLogger$p(this.this$0), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)groupBatchDataIntoSegments.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
                    jsonObject = null;
                }
                return jsonObject;
            }
        })), (Function1)((Function1)new Function1<JsonObject, Pair<? extends SessionReplayRumContext, ? extends JsonArray>>(this){
            final /* synthetic */ BatchesToSegmentsMapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<SessionReplayRumContext, JsonArray> invoke(@NotNull JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsonArray records = BatchesToSegmentsMapper.access$records(this.this$0, it);
                SessionReplayRumContext rumContext2 = BatchesToSegmentsMapper.access$rumContext(this.this$0, it);
                return records == null || rumContext2 == null || records.isEmpty() ? null : new Pair((Object)rumContext2, (Object)records);
            }
        }));
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            it = (Pair)e;
            boolean bl = false;
            key$iv$iv = (SessionReplayRumContext)it.getFirst();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(e);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl = false;
        list$iv$iv = $this$associateByTo$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            void $this$fold$iv;
            void it2;
            void it$iv$iv;
            Object element$iv$iv$iv = list$iv$iv.next();
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl2 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            Iterable iterable = (Iterable)it2.getValue();
            JsonArray initial$iv = new JsonArray();
            boolean $i$f$fold = false;
            JsonArray accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void pair;
                Pair pair2 = (Pair)element$iv;
                JsonArray acc = accumulator$iv;
                boolean bl4 = false;
                acc.addAll((JsonArray)pair.getSecond());
                accumulator$iv = acc;
            }
            JsonArray jsonArray = accumulator$iv;
            map.put(k, jsonArray);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            boolean bl3 = false;
            if (!(!((JsonArray)it.getValue()).isEmpty())) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Map $this$mapNotNull$iv = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl4 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair<MobileSegment, JsonObject> it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            Map.Entry it3 = element$iv$iv;
            boolean bl52 = false;
            if (this.mapToSegment(datadogContext, (SessionReplayRumContext)it3.getKey(), (JsonArray)it3.getValue()) == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<MobileSegment, JsonObject> mapToSegment(DatadogContext datadogContext, SessionReplayRumContext rumContext2, JsonArray records) {
        Long stopTimestamp;
        void $this$fold$iv;
        Sequence $this$sortedBy$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)records)), (Function1)((Function1)new Function1<JsonElement, JsonObject>(this){
            final /* synthetic */ BatchesToSegmentsMapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final JsonObject invoke(JsonElement it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return GsonExtKt.safeGetAsJsonObject(it, BatchesToSegmentsMapper.access$getInternalLogger$p(this.this$0));
            }
        })), (Function1)((Function1)new Function1<JsonObject, Pair<? extends JsonObject, ? extends Long>>(this){
            final /* synthetic */ BatchesToSegmentsMapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<JsonObject, Long> invoke(@NotNull JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Long timestamp = BatchesToSegmentsMapper.access$timestamp(this.this$0, it);
                return timestamp == null ? null : new Pair((Object)it, (Object)timestamp);
            }
        }));
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Long)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getSecond()));
            }
        }), (Function1)mapToSegment.orderedRecords.4.INSTANCE);
        JsonArray initial$iv = new JsonArray();
        boolean $i$f$fold22 = false;
        JsonArray accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void jsonObject;
            JsonObject jsonObject2 = (JsonObject)element$iv;
            JsonArray acc = accumulator$iv;
            boolean bl = false;
            acc.add((JsonElement)jsonObject);
            accumulator$iv = acc;
        }
        JsonArray orderedRecords2 = accumulator$iv;
        if (orderedRecords2.isEmpty()) {
            return null;
        }
        initial$iv = (JsonElement)CollectionsKt.firstOrNull((Iterable)((Iterable)orderedRecords2));
        Long startTimestamp = initial$iv != null && ($i$f$fold22 = GsonExtKt.safeGetAsJsonObject((JsonElement)initial$iv, this.internalLogger)) != null ? this.timestamp($i$f$fold22) : null;
        JsonElement $i$f$fold22 = (JsonElement)CollectionsKt.lastOrNull((Iterable)((Iterable)orderedRecords2));
        Long l = stopTimestamp = $i$f$fold22 != null && (accumulator$iv = GsonExtKt.safeGetAsJsonObject($i$f$fold22, this.internalLogger)) != null ? this.timestamp((JsonObject)accumulator$iv) : null;
        if (startTimestamp == null || stopTimestamp == null) {
            return null;
        }
        boolean hasFullSnapshotRecord = this.hasFullSnapshotRecord(orderedRecords2);
        MobileSegment segment = new MobileSegment(new MobileSegment.Application(rumContext2.getApplicationId()), new MobileSegment.Session(rumContext2.getSessionId()), new MobileSegment.View(rumContext2.getViewId()), startTimestamp, stopTimestamp, orderedRecords2.size(), null, hasFullSnapshotRecord, MobileSegmentExtKt.tryFromSource(MobileSegment.Source.Companion, datadogContext.getSource(), this.internalLogger), CollectionsKt.emptyList());
        JsonObject jsonObject = GsonExtKt.safeGetAsJsonObject(segment.toJson(), this.internalLogger);
        if (jsonObject == null) {
            return null;
        }
        JsonObject segmentAsJsonObject = jsonObject;
        segmentAsJsonObject.add(RECORDS_KEY, (JsonElement)orderedRecords2);
        return new Pair((Object)segment, (Object)segmentAsJsonObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasFullSnapshotRecord(JsonArray records) {
        boolean bl;
        Iterable $this$any$iv = (Iterable)records;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Long typeAsLong;
            Long l;
            JsonPrimitive jsonPrimitive;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            JsonElement it = (JsonElement)element$iv;
            boolean bl2 = false;
            JsonPrimitive jsonPrimitive2 = jsonPrimitive = it.getAsJsonObject().getAsJsonPrimitive(RECORD_TYPE_KEY);
            if (jsonPrimitive2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)jsonPrimitive2, (String)"getAsJsonPrimitive(RECORD_TYPE_KEY)");
                l = GsonExtKt.safeGetAsLong(jsonPrimitive, this.internalLogger);
            } else {
                l = null;
            }
            Long l2 = typeAsLong = l;
            long l3 = 10L;
            if (l2 != null) {
                if (l2 == l3) return true;
            }
            Long l4 = typeAsLong;
            l3 = 2L;
            if (l4 != null && l4 == l3) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final JsonArray records(JsonObject $this$records) {
        JsonElement jsonElement = $this$records.get(RECORDS_KEY);
        return jsonElement != null ? GsonExtKt.safeGetAsJsonArray(jsonElement, this.internalLogger) : null;
    }

    private final Long timestamp(JsonObject $this$timestamp) {
        JsonPrimitive jsonPrimitive = $this$timestamp.getAsJsonPrimitive(TIMESTAMP_KEY);
        return jsonPrimitive != null ? GsonExtKt.safeGetAsLong(jsonPrimitive, this.internalLogger) : null;
    }

    private final SessionReplayRumContext rumContext(JsonObject $this$rumContext) {
        String viewId;
        JsonElement jsonElement = $this$rumContext.get("application_id");
        String applicationId = jsonElement != null ? jsonElement.getAsString() : null;
        JsonElement jsonElement2 = $this$rumContext.get("session_id");
        String sessionId = jsonElement2 != null ? jsonElement2.getAsString() : null;
        JsonElement jsonElement3 = $this$rumContext.get("view_id");
        String string = viewId = jsonElement3 != null ? jsonElement3.getAsString() : null;
        if (applicationId == null || sessionId == null || viewId == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)rumContext.1.INSTANCE, null, (boolean)true, null, (int)32, null);
            return null;
        }
        return new SessionReplayRumContext(applicationId, sessionId, viewId);
    }

    public static final /* synthetic */ InternalLogger access$getInternalLogger$p(BatchesToSegmentsMapper $this) {
        return $this.internalLogger;
    }

    public static final /* synthetic */ JsonArray access$records(BatchesToSegmentsMapper $this, JsonObject $receiver) {
        return $this.records($receiver);
    }

    public static final /* synthetic */ SessionReplayRumContext access$rumContext(BatchesToSegmentsMapper $this, JsonObject $receiver) {
        return $this.rumContext($receiver);
    }

    public static final /* synthetic */ Long access$timestamp(BatchesToSegmentsMapper $this, JsonObject $receiver) {
        return $this.timestamp($receiver);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/BatchesToSegmentsMapper$Companion;", "", "()V", "FULL_SNAPSHOT_RECORD_TYPE_BROWSER", "", "FULL_SNAPSHOT_RECORD_TYPE_MOBILE", "ILLEGAL_STATE_ENRICHED_RECORD_ERROR_MESSAGE", "", "RECORDS_KEY", "RECORD_TYPE_KEY", "TIMESTAMP_KEY", "UNABLE_TO_DESERIALIZE_ENRICHED_RECORD_ERROR_MESSAGE", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

