/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.net;

import androidx.annotation.VisibleForTesting;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.sessionreplay.internal.net.ResourceEvent;
import com.datadog.android.sessionreplay.internal.net.ResourceRequestBodyFactory;
import com.datadog.android.sessionreplay.internal.utils.MiscUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0000\u00a2\u0006\u0002\b\u0016J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0001\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/ResourceRequestBodyFactory;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "addApplicationIdSection", "", "builder", "Lokhttp3/MultipartBody$Builder;", "applicationId", "", "addResourceRequestBody", "filename", "resourceData", "", "addResourcesSection", "resources", "", "Lcom/datadog/android/sessionreplay/internal/net/ResourceEvent;", "create", "Lokhttp3/RequestBody;", "Lcom/datadog/android/api/storage/RawBatchEvent;", "create$dd_sdk_android_session_replay_release", "deserializeToResourceEvents", "deserializeToResourceEvents$dd_sdk_android_session_replay_release", "getApplicationId", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nResourceRequestBodyFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceRequestBodyFactory.kt\ncom/datadog/android/sessionreplay/internal/net/ResourceRequestBodyFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1477#2:217\n1502#2,3:218\n1505#2,3:228\n1603#2,9:231\n1855#2:240\n1856#2:242\n1612#2:243\n1855#2,2:244\n372#3,7:221\n1#4:241\n*S KotlinDebug\n*F\n+ 1 ResourceRequestBodyFactory.kt\ncom/datadog/android/sessionreplay/internal/net/ResourceRequestBodyFactory\n*L\n67#1:217\n67#1:218,3\n67#1:228,3\n88#1:231,9\n88#1:240\n88#1:242\n88#1:243\n119#1:244,2\n67#1:221,7\n88#1:241\n*E\n"})
public final class ResourceRequestBodyFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @Nullable
    private static final MediaType CONTENT_TYPE_IMAGE = MediaType.Companion.parse("image/png");
    @Nullable
    private static final MediaType CONTENT_TYPE_APPLICATION = MediaType.Companion.parse("application/json");
    @NotNull
    public static final String TYPE_KEY = "type";
    @NotNull
    public static final String TYPE_RESOURCE = "resource";
    @NotNull
    public static final String NAME_IMAGE = "image";
    @NotNull
    public static final String NAME_EVENT = "event";
    @NotNull
    public static final String FILENAME_BLOB = "blob";
    @NotNull
    public static final String MULTIPLE_APPLICATION_ID_ERROR = "There were multiple applicationIds associated with the resources";
    @NotNull
    public static final String NO_RESOURCES_TO_SEND_ERROR = "No resources to send";
    @NotNull
    private static final String ERROR_CREATING_REQUEST_BODY = "Error creating request body";
    @NotNull
    private static final String EMPTY_REQUEST_BODY_ERROR = "Unable to add any sections to request body";

    public ResourceRequestBodyFactory(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Nullable
    public final RequestBody create$dd_sdk_android_session_replay_release(@NotNull List<RawBatchEvent> resources) {
        MultipartBody multipartBody;
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        List<ResourceEvent> deserializedResources = this.deserializeToResourceEvents$dd_sdk_android_session_replay_release(resources);
        String string = this.getApplicationId(deserializedResources);
        if (string == null) {
            return null;
        }
        String applicationId = string;
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        this.addResourcesSection(builder, deserializedResources);
        this.addApplicationIdSection(builder, applicationId);
        try {
            multipartBody = builder.build();
        }
        catch (IllegalStateException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)create.result.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            multipartBody = null;
        }
        MultipartBody result2 = multipartBody;
        return (RequestBody)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final String getApplicationId(List<ResourceEvent> resources) {
        void $this$groupByTo$iv$iv;
        if (resources.isEmpty()) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)getApplicationId.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return null;
        }
        Iterable $this$groupBy$iv = resources;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ResourceEvent it = (ResourceEvent)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getApplicationId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map uniqueApplicationIds = destination$iv$iv;
        if (uniqueApplicationIds.size() > 1) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)getApplicationId.2.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
        String applicationId = ((ResourceEvent)CollectionsKt.last(resources)).getApplicationId();
        return applicationId;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<ResourceEvent> deserializeToResourceEvents$dd_sdk_android_session_replay_release(@NotNull List<RawBatchEvent> resources) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Iterable $this$mapNotNull$iv = resources;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ResourceEvent resourceEvent;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RawBatchEvent it = (RawBatchEvent)element$iv$iv;
            boolean bl2 = false;
            JsonObject resourceMetadata = MiscUtils.INSTANCE.safeDeserializeToJsonObject$dd_sdk_android_session_replay_release(this.internalLogger, it.getMetadata());
            if (resourceMetadata != null) {
                String applicationId = MiscUtils.INSTANCE.safeGetStringFromJsonObject$dd_sdk_android_session_replay_release(this.internalLogger, resourceMetadata, "applicationId");
                String filename = MiscUtils.INSTANCE.safeGetStringFromJsonObject$dd_sdk_android_session_replay_release(this.internalLogger, resourceMetadata, "filename");
                resourceEvent = applicationId != null && filename != null ? new ResourceEvent(applicationId, filename, it.getData()) : null;
            } else {
                resourceEvent = null;
            }
            if (resourceEvent == null) continue;
            ResourceEvent it$iv$iv = resourceEvent;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void addResourcesSection(MultipartBody.Builder builder, List<ResourceEvent> resources) {
        Iterable $this$forEach$iv = resources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceEvent it = (ResourceEvent)element$iv;
            boolean bl = false;
            String filename = it.getIdentifier();
            byte[] resourceData = it.getResourceData();
            this.addResourceRequestBody(builder, filename, resourceData);
        }
    }

    private final void addApplicationIdSection(MultipartBody.Builder builder, String applicationId) {
        RequestBody requestBody;
        JsonObject applicationIdOuter = new JsonObject();
        JsonObject applicationIdInner = new JsonObject();
        applicationIdInner.addProperty("id", applicationId);
        applicationIdOuter.add("application", (JsonElement)applicationIdInner);
        applicationIdOuter.addProperty(TYPE_KEY, TYPE_RESOURCE);
        try {
            String string = applicationIdOuter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationIdOuter.toString()");
            requestBody = RequestBody.Companion.create(string, CONTENT_TYPE_APPLICATION);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)addApplicationIdSection.body.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            requestBody = null;
        }
        catch (IOException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)addApplicationIdSection.body.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            requestBody = null;
        }
        RequestBody body2 = requestBody;
        if (body2 != null) {
            builder.addFormDataPart(NAME_EVENT, FILENAME_BLOB, body2);
        }
    }

    private final void addResourceRequestBody(MultipartBody.Builder builder, String filename, byte[] resourceData) {
        RequestBody requestBody;
        try {
            requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])resourceData, (MediaType)CONTENT_TYPE_IMAGE, (int)0, (int)0, (int)6, null);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)addResourceRequestBody.body.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            requestBody = null;
        }
        catch (IOException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)addResourceRequestBody.body.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            requestBody = null;
        }
        RequestBody body2 = requestBody;
        if (body2 != null) {
            builder.addFormDataPart(NAME_IMAGE, filename, body2);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/ResourceRequestBodyFactory$Companion;", "", "()V", "CONTENT_TYPE_APPLICATION", "Lokhttp3/MediaType;", "getCONTENT_TYPE_APPLICATION$dd_sdk_android_session_replay_release", "()Lokhttp3/MediaType;", "CONTENT_TYPE_IMAGE", "getCONTENT_TYPE_IMAGE$dd_sdk_android_session_replay_release", "EMPTY_REQUEST_BODY_ERROR", "", "ERROR_CREATING_REQUEST_BODY", "FILENAME_BLOB", "MULTIPLE_APPLICATION_ID_ERROR", "NAME_EVENT", "NAME_IMAGE", "NO_RESOURCES_TO_SEND_ERROR", "TYPE_KEY", "TYPE_RESOURCE", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MediaType getCONTENT_TYPE_IMAGE$dd_sdk_android_session_replay_release() {
            return CONTENT_TYPE_IMAGE;
        }

        @Nullable
        public final MediaType getCONTENT_TYPE_APPLICATION$dd_sdk_android_session_replay_release() {
            return CONTENT_TYPE_APPLICATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

