/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.net;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.net.Request;
import com.datadog.android.api.net.RequestExecutionContext;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.sessionreplay.internal.net.ResourceRequestBodyFactory;
import com.datadog.android.sessionreplay.internal.net.ResourcesRequestFactory;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0016J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/sessionreplay/internal/net/ResourcesRequestFactory;", "Lcom/datadog/android/api/net/RequestFactory;", "customEndpointUrl", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "resourceRequestBodyFactory", "Lcom/datadog/android/sessionreplay/internal/net/ResourceRequestBodyFactory;", "(Ljava/lang/String;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/internal/net/ResourceRequestBodyFactory;)V", "getCustomEndpointUrl$dd_sdk_android_session_replay_release", "()Ljava/lang/String;", "buildUrl", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "convertBodyToByteArray", "", "body", "Lokhttp3/RequestBody;", "create", "Lcom/datadog/android/api/net/Request;", "context", "executionContext", "Lcom/datadog/android/api/net/RequestExecutionContext;", "batchData", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMetadata", "resolveHeaders", "", "requestId", "resolveRequest", "Companion", "dd-sdk-android-session-replay_release"})
public final class ResourcesRequestFactory
implements RequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String customEndpointUrl;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final ResourceRequestBodyFactory resourceRequestBodyFactory;
    @NotNull
    private static final String UPLOAD_URL = "%s/api/v2/%s";
    @NotNull
    public static final String APPLICATION_ID = "application_id";
    @NotNull
    public static final String UPLOAD_DESCRIPTION = "Session Replay Resource Upload Request";
    @NotNull
    public static final String ERROR_CONVERTING_BODY_TO_BYTEARRAY = "Error converting request body to bytearray";

    public ResourcesRequestFactory(@Nullable String customEndpointUrl, @NotNull InternalLogger internalLogger, @NotNull ResourceRequestBodyFactory resourceRequestBodyFactory) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)resourceRequestBodyFactory, (String)"resourceRequestBodyFactory");
        this.customEndpointUrl = customEndpointUrl;
        this.internalLogger = internalLogger;
        this.resourceRequestBodyFactory = resourceRequestBodyFactory;
    }

    public /* synthetic */ ResourcesRequestFactory(String string, InternalLogger internalLogger, ResourceRequestBodyFactory resourceRequestBodyFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            resourceRequestBodyFactory = new ResourceRequestBodyFactory(internalLogger);
        }
        this(string, internalLogger, resourceRequestBodyFactory);
    }

    @Nullable
    public final String getCustomEndpointUrl$dd_sdk_android_session_replay_release() {
        return this.customEndpointUrl;
    }

    @Nullable
    public Request create(@NotNull DatadogContext context, @NotNull RequestExecutionContext executionContext, @NotNull List<RawBatchEvent> batchData, @Nullable byte[] batchMetadata) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        RequestBody requestBody = this.resourceRequestBodyFactory.create$dd_sdk_android_session_replay_release(batchData);
        if (requestBody == null) {
            return null;
        }
        RequestBody requestBody2 = requestBody;
        return this.resolveRequest(context, requestBody2);
    }

    private final Request resolveRequest(DatadogContext context, RequestBody body2) {
        byte[] byArray = this.convertBodyToByteArray(body2);
        if (byArray == null) {
            return null;
        }
        byte[] bodyAsByteArray = byArray;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        String description = UPLOAD_DESCRIPTION;
        Map<String, String> headers = this.resolveHeaders(context, requestId);
        String requestUrl = this.buildUrl(context);
        return new Request(requestId, description, requestUrl, headers, bodyAsByteArray, String.valueOf(body2.contentType()));
    }

    private final byte[] convertBodyToByteArray(RequestBody body2) {
        byte[] result2 = null;
        Buffer buffer = new Buffer();
        try {
            body2.writeTo((BufferedSink)buffer);
        }
        catch (IOException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)convertBodyToByteArray.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        try {
            result2 = buffer.readByteArray();
        }
        catch (EOFException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)convertBodyToByteArray.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        return result2;
    }

    private final Map<String, String> resolveHeaders(DatadogContext datadogContext, String requestId) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DD-API-KEY", (Object)datadogContext.getClientToken()), TuplesKt.to((Object)"DD-EVP-ORIGIN", (Object)datadogContext.getSource()), TuplesKt.to((Object)"DD-EVP-ORIGIN-VERSION", (Object)datadogContext.getSdkVersion()), TuplesKt.to((Object)"DD-REQUEST-ID", (Object)requestId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final String buildUrl(DatadogContext datadogContext) {
        Locale locale = Locale.US;
        String string = UPLOAD_URL;
        Object[] objectArray = new Object[2];
        String string2 = this.customEndpointUrl;
        if (string2 == null) {
            string2 = datadogContext.getSite().getIntakeEndpoint();
        }
        objectArray[0] = string2;
        objectArray[1] = "replay";
        String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/ResourcesRequestFactory$Companion;", "", "()V", "APPLICATION_ID", "", "ERROR_CONVERTING_BODY_TO_BYTEARRAY", "UPLOAD_DESCRIPTION", "UPLOAD_URL", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

