/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.net;

import com.datadog.android.sessionreplay.internal.net.BytesCompressor;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/SegmentRequestBodyFactory;", "", "compressor", "Lcom/datadog/android/sessionreplay/internal/net/BytesCompressor;", "(Lcom/datadog/android/sessionreplay/internal/net/BytesCompressor;)V", "create", "Lokhttp3/RequestBody;", "serializedSegmentsPairs", "", "Lkotlin/Pair;", "Lcom/datadog/android/sessionreplay/model/MobileSegment;", "Lcom/google/gson/JsonObject;", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nSegmentRequestBodyFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentRequestBodyFactory.kt\ncom/datadog/android/sessionreplay/internal/net/SegmentRequestBodyFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1864#2,3:64\n*S KotlinDebug\n*F\n+ 1 SegmentRequestBodyFactory.kt\ncom/datadog/android/sessionreplay/internal/net/SegmentRequestBodyFactory\n*L\n25#1:64,3\n*E\n"})
public final class SegmentRequestBodyFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytesCompressor compressor;
    @NotNull
    public static final String BINARY_FILENAME_PREFIX = "file";
    @NotNull
    public static final String BLOB_FILENAME = "blob";
    @NotNull
    public static final String EVENT_NAME_FORM_KEY = "event";
    @NotNull
    public static final String RAW_SEGMENT_SIZE_FORM_KEY = "raw_segment_size";
    @NotNull
    public static final String COMPRESSED_SEGMENT_SIZE_FORM_KEY = "compressed_segment_size";
    @NotNull
    public static final String SEGMENT_DATA_FORM_KEY = "segment";
    @Nullable
    private static final MediaType CONTENT_TYPE_BINARY_TYPE = MediaType.Companion.parse("application/octet-stream");
    @Nullable
    private static final MediaType CONTENT_TYPE_JSON_TYPE = MediaType.Companion.parse("application/json");

    public SegmentRequestBodyFactory(@NotNull BytesCompressor compressor) {
        Intrinsics.checkNotNullParameter((Object)compressor, (String)"compressor");
        this.compressor = compressor;
    }

    public /* synthetic */ SegmentRequestBodyFactory(BytesCompressor bytesCompressor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bytesCompressor = new BytesCompressor();
        }
        this(bytesCompressor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RequestBody create(@NotNull List<Pair<MobileSegment, JsonObject>> serializedSegmentsPairs) {
        Intrinsics.checkNotNullParameter(serializedSegmentsPairs, (String)"serializedSegmentsPairs");
        MultipartBody.Builder multipartBody = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        JsonArray metadata = new JsonArray();
        Iterable $this$forEachIndexed$iv = serializedSegmentsPairs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            JsonObject jsonObject;
            byte[] segmentAsByteArray;
            void segment;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)(((JsonObject)segment.getSecond()).toString() + "\n").getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            byte[] compressedData = this.compressor.compressBytes(segmentAsByteArray);
            JsonObject $this$create_u24lambda_u241_u24lambda_u240 = jsonObject = ((MobileSegment)segment.getFirst()).toJson().getAsJsonObject();
            boolean bl2 = false;
            $this$create_u24lambda_u241_u24lambda_u240.addProperty(COMPRESSED_SEGMENT_SIZE_FORM_KEY, (Number)compressedData.length);
            $this$create_u24lambda_u241_u24lambda_u240.addProperty(RAW_SEGMENT_SIZE_FORM_KEY, (Number)segmentAsByteArray.length);
            JsonObject segmentAsJson = jsonObject;
            multipartBody.addFormDataPart(SEGMENT_DATA_FORM_KEY, BINARY_FILENAME_PREFIX + index, RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])compressedData, (MediaType)CONTENT_TYPE_BINARY_TYPE, (int)0, (int)0, (int)6, null));
            metadata.add((JsonElement)segmentAsJson);
        }
        String string = metadata.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"metadata.toString()");
        multipartBody.addFormDataPart(EVENT_NAME_FORM_KEY, BLOB_FILENAME, RequestBody.Companion.create(string, CONTENT_TYPE_JSON_TYPE));
        return (RequestBody)multipartBody.build();
    }

    public SegmentRequestBodyFactory() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/SegmentRequestBodyFactory$Companion;", "", "()V", "BINARY_FILENAME_PREFIX", "", "BLOB_FILENAME", "COMPRESSED_SEGMENT_SIZE_FORM_KEY", "CONTENT_TYPE_BINARY_TYPE", "Lokhttp3/MediaType;", "getCONTENT_TYPE_BINARY_TYPE$dd_sdk_android_session_replay_release", "()Lokhttp3/MediaType;", "CONTENT_TYPE_JSON_TYPE", "getCONTENT_TYPE_JSON_TYPE$dd_sdk_android_session_replay_release", "EVENT_NAME_FORM_KEY", "RAW_SEGMENT_SIZE_FORM_KEY", "SEGMENT_DATA_FORM_KEY", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MediaType getCONTENT_TYPE_BINARY_TYPE$dd_sdk_android_session_replay_release() {
            return CONTENT_TYPE_BINARY_TYPE;
        }

        @Nullable
        public final MediaType getCONTENT_TYPE_JSON_TYPE$dd_sdk_android_session_replay_release() {
            return CONTENT_TYPE_JSON_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

