/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.net;

import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.net.Request;
import com.datadog.android.api.net.RequestExecutionContext;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.sessionreplay.internal.exception.InvalidPayloadFormatException;
import com.datadog.android.sessionreplay.internal.net.BatchesToSegmentsMapper;
import com.datadog.android.sessionreplay.internal.net.SegmentRequestBodyFactory;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/sessionreplay/internal/net/SegmentRequestFactory;", "Lcom/datadog/android/api/net/RequestFactory;", "customEndpointUrl", "", "batchToSegmentsMapper", "Lcom/datadog/android/sessionreplay/internal/net/BatchesToSegmentsMapper;", "segmentRequestBodyFactory", "Lcom/datadog/android/sessionreplay/internal/net/SegmentRequestBodyFactory;", "(Ljava/lang/String;Lcom/datadog/android/sessionreplay/internal/net/BatchesToSegmentsMapper;Lcom/datadog/android/sessionreplay/internal/net/SegmentRequestBodyFactory;)V", "getCustomEndpointUrl$dd_sdk_android_session_replay_release", "()Ljava/lang/String;", "buildUrl", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "create", "Lcom/datadog/android/api/net/Request;", "context", "executionContext", "Lcom/datadog/android/api/net/RequestExecutionContext;", "batchData", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMetadata", "", "extractByteArrayFromBody", "body", "Lokhttp3/RequestBody;", "resolveHeaders", "", "requestId", "resolveRequest", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nSegmentRequestFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentRequestFactory.kt\ncom/datadog/android/sessionreplay/internal/net/SegmentRequestFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1549#2:94\n1620#2,3:95\n*S KotlinDebug\n*F\n+ 1 SegmentRequestFactory.kt\ncom/datadog/android/sessionreplay/internal/net/SegmentRequestFactory\n*L\n32#1:94\n32#1:95,3\n*E\n"})
public final class SegmentRequestFactory
implements RequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String customEndpointUrl;
    @NotNull
    private final BatchesToSegmentsMapper batchToSegmentsMapper;
    @NotNull
    private final SegmentRequestBodyFactory segmentRequestBodyFactory;
    @NotNull
    private static final String UPLOAD_URL = "%s/api/v2/%s";

    public SegmentRequestFactory(@Nullable String customEndpointUrl, @NotNull BatchesToSegmentsMapper batchToSegmentsMapper, @NotNull SegmentRequestBodyFactory segmentRequestBodyFactory) {
        Intrinsics.checkNotNullParameter((Object)batchToSegmentsMapper, (String)"batchToSegmentsMapper");
        Intrinsics.checkNotNullParameter((Object)segmentRequestBodyFactory, (String)"segmentRequestBodyFactory");
        this.customEndpointUrl = customEndpointUrl;
        this.batchToSegmentsMapper = batchToSegmentsMapper;
        this.segmentRequestBodyFactory = segmentRequestBodyFactory;
    }

    public /* synthetic */ SegmentRequestFactory(String string, BatchesToSegmentsMapper batchesToSegmentsMapper, SegmentRequestBodyFactory segmentRequestBodyFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            segmentRequestBodyFactory = new SegmentRequestBodyFactory(null, 1, null);
        }
        this(string, batchesToSegmentsMapper, segmentRequestBodyFactory);
    }

    @Nullable
    public final String getCustomEndpointUrl$dd_sdk_android_session_replay_release() {
        return this.customEndpointUrl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Request create(@NotNull DatadogContext context, @NotNull RequestExecutionContext executionContext, @NotNull List<RawBatchEvent> batchData, @Nullable byte[] batchMetadata) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        Iterable iterable = batchData;
        DatadogContext datadogContext = context;
        BatchesToSegmentsMapper batchesToSegmentsMapper = this.batchToSegmentsMapper;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RawBatchEvent rawBatchEvent = (RawBatchEvent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        collection = (List)destination$iv$iv;
        List<Pair<MobileSegment, JsonObject>> serializedSegmentPair = batchesToSegmentsMapper.map(datadogContext, (List<byte[]>)collection);
        if (serializedSegmentPair.isEmpty()) {
            throw new InvalidPayloadFormatException("The payload format was broken and an upload request could not be created");
        }
        RequestBody body2 = this.segmentRequestBodyFactory.create(serializedSegmentPair);
        return this.resolveRequest(context, body2);
    }

    private final String buildUrl(DatadogContext datadogContext) {
        Locale locale = Locale.US;
        String string = UPLOAD_URL;
        Object[] objectArray = new Object[2];
        String string2 = this.customEndpointUrl;
        if (string2 == null) {
            string2 = datadogContext.getSite().getIntakeEndpoint();
        }
        objectArray[0] = string2;
        objectArray[1] = "replay";
        String string3 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    private final Map<String, String> resolveHeaders(DatadogContext datadogContext, String requestId) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DD-API-KEY", (Object)datadogContext.getClientToken()), TuplesKt.to((Object)"DD-EVP-ORIGIN", (Object)datadogContext.getSource()), TuplesKt.to((Object)"DD-EVP-ORIGIN-VERSION", (Object)datadogContext.getSdkVersion()), TuplesKt.to((Object)"DD-REQUEST-ID", (Object)requestId)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Request resolveRequest(DatadogContext context, RequestBody body2) {
        byte[] bodyAsByteArray = this.extractByteArrayFromBody(body2);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        String description = "Session Replay Segment Upload Request";
        Map<String, String> headers = this.resolveHeaders(context, requestId);
        String requestUrl = this.buildUrl(context);
        return new Request(requestId, description, requestUrl, headers, bodyAsByteArray, String.valueOf(body2.contentType()));
    }

    private final byte[] extractByteArrayFromBody(RequestBody body2) {
        Buffer buffer = new Buffer();
        body2.writeTo((BufferedSink)buffer);
        return buffer.readByteArray();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/net/SegmentRequestFactory$Companion;", "", "()V", "UPLOAD_URL", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

