/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.prerequisite;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.StrictModeExtKt;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.sessionreplay.internal.prerequisite.SystemRequirementChecker;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0002R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/sessionreplay/internal/prerequisite/CPURequirementChecker;", "Lcom/datadog/android/sessionreplay/internal/prerequisite/SystemRequirementChecker;", "minCPUCores", "", "cpuDirFile", "Ljava/io/File;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(ILjava/io/File;Lcom/datadog/android/api/InternalLogger;)V", "checkedValue", "Ljava/lang/Integer;", "checkMinimumRequirement", "", "", "fallbackReadCpuCoreNumber", "name", "", "readCPUCoreNumber", "Companion", "dd-sdk-android-session-replay_release"})
public final class CPURequirementChecker
implements SystemRequirementChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int minCPUCores;
    @NotNull
    private final File cpuDirFile;
    @NotNull
    private final InternalLogger internalLogger;
    @Nullable
    private Integer checkedValue;
    @NotNull
    private static final String DIR_PATH = "/sys/devices/system/cpu/";
    @NotNull
    private static final Regex REGEX_CPU_CORE_FILE = new Regex("cpu[0-9]+");
    @NotNull
    private static final String CPU_CHECK_NAME = "cpu";

    public CPURequirementChecker(int minCPUCores, @NotNull File cpuDirFile, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)cpuDirFile, (String)"cpuDirFile");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.minCPUCores = minCPUCores;
        this.cpuDirFile = cpuDirFile;
        this.internalLogger = internalLogger;
    }

    public /* synthetic */ CPURequirementChecker(int n, File file, InternalLogger internalLogger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            file = new File(DIR_PATH);
        }
        this(n, file, internalLogger);
    }

    @Override
    public boolean checkMinimumRequirement() {
        if (this.minCPUCores == 0) {
            return true;
        }
        int actualCPUCoreNumber2 = ((Number)StrictModeExtKt.allowThreadDiskReads((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ CPURequirementChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return CPURequirementChecker.access$readCPUCoreNumber(this.this$0);
            }
        }))).intValue();
        return actualCPUCoreNumber2 >= this.minCPUCores;
    }

    @Override
    @NotNull
    public String name() {
        return CPU_CHECK_NAME;
    }

    @Override
    @Nullable
    public Object checkedValue() {
        return this.checkedValue;
    }

    private final int readCPUCoreNumber() {
        File[] files = FileExtKt.listFilesSafe((File)this.cpuDirFile, (InternalLogger)this.internalLogger, CPURequirementChecker::readCPUCoreNumber$lambda$0);
        int value = files != null ? files.length : this.fallbackReadCpuCoreNumber();
        this.checkedValue = value;
        return value;
    }

    private final int fallbackReadCpuCoreNumber() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final boolean readCPUCoreNumber$lambda$0(File file, String name) {
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        CharSequence charSequence = name;
        return REGEX_CPU_CORE_FILE.matches(charSequence);
    }

    public static final /* synthetic */ int access$readCPUCoreNumber(CPURequirementChecker $this) {
        return $this.readCPUCoreNumber();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/sessionreplay/internal/prerequisite/CPURequirementChecker$Companion;", "", "()V", "CPU_CHECK_NAME", "", "DIR_PATH", "REGEX_CPU_CORE_FILE", "Lkotlin/text/Regex;", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

