/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.prerequisite;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.StrictModeExtKt;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.sessionreplay.internal.prerequisite.SystemRequirementChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/sessionreplay/internal/prerequisite/MemoryRequirementChecker;", "Lcom/datadog/android/sessionreplay/internal/prerequisite/SystemRequirementChecker;", "minRamSizeMb", "", "memInfoFile", "Ljava/io/File;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(ILjava/io/File;Lcom/datadog/android/api/InternalLogger;)V", "checkedValue", "", "Ljava/lang/Long;", "checkMinimumRequirement", "", "", "getMaxRAMSize", "name", "", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nMemoryRequirementChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryRequirementChecker.kt\ncom/datadog/android/sessionreplay/internal/prerequisite/MemoryRequirementChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1603#2,9:78\n1855#2:87\n1856#2:89\n1612#2:90\n1#3:88\n*S KotlinDebug\n*F\n+ 1 MemoryRequirementChecker.kt\ncom/datadog/android/sessionreplay/internal/prerequisite/MemoryRequirementChecker\n*L\n43#1:78,9\n43#1:87\n43#1:89\n43#1:90\n43#1:88\n*E\n"})
public final class MemoryRequirementChecker
implements SystemRequirementChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int minRamSizeMb;
    @NotNull
    private final File memInfoFile;
    @NotNull
    private final InternalLogger internalLogger;
    @Nullable
    private Long checkedValue;
    private static final int KB_IN_MB = 1000;
    @NotNull
    private static final String MEM_INFO_PATH = "/proc/meminfo";
    @NotNull
    private static final String MEM_TOTAL_REGEX = "MemTotal:";
    @NotNull
    private static final String MEMORY_CHECK_NAME = "ram";

    public MemoryRequirementChecker(int minRamSizeMb, @NotNull File memInfoFile, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)memInfoFile, (String)"memInfoFile");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.minRamSizeMb = minRamSizeMb;
        this.memInfoFile = memInfoFile;
        this.internalLogger = internalLogger;
    }

    public /* synthetic */ MemoryRequirementChecker(int n, File file, InternalLogger internalLogger, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            file = new File(MEM_INFO_PATH);
        }
        this(n, file, internalLogger);
    }

    @Override
    public boolean checkMinimumRequirement() {
        if (this.minRamSizeMb == 0) {
            return true;
        }
        long actualMaxRamSizeMb2 = ((Number)StrictModeExtKt.allowThreadDiskReads((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ MemoryRequirementChecker this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return MemoryRequirementChecker.access$getMaxRAMSize(this.this$0);
            }
        }))).longValue();
        return actualMaxRamSizeMb2 >= (long)this.minRamSizeMb;
    }

    @Override
    @NotNull
    public String name() {
        return MEMORY_CHECK_NAME;
    }

    @Override
    @Nullable
    public Object checkedValue() {
        return this.checkedValue;
    }

    /*
     * WARNING - void declaration
     */
    private final long getMaxRAMSize() {
        Long l;
        if (!FileExtKt.existsSafe((File)this.memInfoFile, (InternalLogger)this.internalLogger) || !FileExtKt.canReadSafe((File)this.memInfoFile, (InternalLogger)this.internalLogger)) {
            return 0L;
        }
        List list = FileExtKt.readLinesSafe$default((File)this.memInfoFile, null, (InternalLogger)this.internalLogger, (int)1, null);
        if (list != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long it$iv$iv;
                int n;
                CharSequence charSequence;
                Regex regex;
                List tokens;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String line = (String)element$iv$iv;
                boolean bl2 = false;
                if ((StringsKt.startsWith$default((String)line, (String)MEM_TOTAL_REGEX, (boolean)false, (int)2, null) ? ((tokens = (regex = new Regex("\\s+")).split(charSequence = (CharSequence)line, n = 0)).size() > 1 ? StringsKt.toLongOrNull((String)((String)tokens.get(1))) : null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            l = (Long)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        } else {
            l = null;
        }
        Long memorySizeKb = l;
        long value = memorySizeKb == null ? 0L : memorySizeKb / (long)1000;
        this.checkedValue = value;
        return value;
    }

    public static final /* synthetic */ long access$getMaxRAMSize(MemoryRequirementChecker $this) {
        return $this.getMaxRAMSize();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/sessionreplay/internal/prerequisite/MemoryRequirementChecker$Companion;", "", "()V", "KB_IN_MB", "", "MEMORY_CHECK_NAME", "", "MEM_INFO_PATH", "MEM_TOTAL_REGEX", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

