/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.processor;

import androidx.annotation.WorkerThread;
import com.datadog.android.sessionreplay.internal.async.ResourceRecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.async.SnapshotRecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.async.TouchEventRecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.processor.EnrichedRecord;
import com.datadog.android.sessionreplay.internal.processor.EnrichedResource;
import com.datadog.android.sessionreplay.internal.processor.MutationResolver;
import com.datadog.android.sessionreplay.internal.processor.NodeFlattener;
import com.datadog.android.sessionreplay.internal.processor.Processor;
import com.datadog.android.sessionreplay.internal.recorder.Node;
import com.datadog.android.sessionreplay.internal.resources.ResourceDataStoreManager;
import com.datadog.android.sessionreplay.internal.storage.RecordWriter;
import com.datadog.android.sessionreplay.internal.storage.ResourcesWriter;
import com.datadog.android.sessionreplay.internal.utils.SessionReplayRumContext;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.SystemInformation;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 12\u00020\u0001:\u00011B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H\u0002J.\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00122\u0006\u0010!\u001a\u00020\"H\u0003J\u001e\u0010#\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00102\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H\u0003J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0010H\u0002J\b\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0017J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020.H\u0017J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010+\u001a\u000200H\u0017R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/datadog/android/sessionreplay/internal/processor/RecordedDataProcessor;", "Lcom/datadog/android/sessionreplay/internal/processor/Processor;", "resourceDataStoreManager", "Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager;", "resourcesWriter", "Lcom/datadog/android/sessionreplay/internal/storage/ResourcesWriter;", "writer", "Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;", "mutationResolver", "Lcom/datadog/android/sessionreplay/internal/processor/MutationResolver;", "nodeFlattener", "Lcom/datadog/android/sessionreplay/internal/processor/NodeFlattener;", "(Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager;Lcom/datadog/android/sessionreplay/internal/storage/ResourcesWriter;Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;Lcom/datadog/android/sessionreplay/internal/processor/MutationResolver;Lcom/datadog/android/sessionreplay/internal/processor/NodeFlattener;)V", "lastSnapshotTimestamp", "", "prevRumContext", "Lcom/datadog/android/sessionreplay/internal/utils/SessionReplayRumContext;", "prevSnapshot", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "previousOrientation", "", "bundleRecordInEnrichedRecord", "Lcom/datadog/android/sessionreplay/internal/processor/EnrichedRecord;", "rumContext", "records", "Lcom/datadog/android/sessionreplay/model/MobileSegment$MobileRecord;", "handleSnapshots", "", "newRumContext", "timestamp", "snapshots", "Lcom/datadog/android/sessionreplay/internal/recorder/Node;", "systemInformation", "Lcom/datadog/android/sessionreplay/recorder/SystemInformation;", "handleTouchRecords", "touchData", "handleViewEndRecord", "isNewView", "", "newContext", "isTimeForFullSnapshot", "processResources", "item", "Lcom/datadog/android/sessionreplay/internal/async/ResourceRecordedDataQueueItem;", "processScreenSnapshots", "Lcom/datadog/android/sessionreplay/internal/async/SnapshotRecordedDataQueueItem;", "processTouchEventsRecords", "Lcom/datadog/android/sessionreplay/internal/async/TouchEventRecordedDataQueueItem;", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nRecordedDataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordedDataProcessor.kt\ncom/datadog/android/sessionreplay/internal/processor/RecordedDataProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1360#2:208\n1446#2,5:209\n*S KotlinDebug\n*F\n+ 1 RecordedDataProcessor.kt\ncom/datadog/android/sessionreplay/internal/processor/RecordedDataProcessor\n*L\n100#1:208\n100#1:209,5\n*E\n"})
public final class RecordedDataProcessor
implements Processor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceDataStoreManager resourceDataStoreManager;
    @NotNull
    private final ResourcesWriter resourcesWriter;
    @NotNull
    private final RecordWriter writer;
    @NotNull
    private final MutationResolver mutationResolver;
    @NotNull
    private final NodeFlattener nodeFlattener;
    @NotNull
    private List<? extends MobileSegment.Wireframe> prevSnapshot;
    private long lastSnapshotTimestamp;
    private int previousOrientation;
    @NotNull
    private SessionReplayRumContext prevRumContext;
    private static final long FULL_SNAPSHOT_INTERVAL_IN_NS = TimeUnit.MILLISECONDS.toNanos(3000L);

    public RecordedDataProcessor(@NotNull ResourceDataStoreManager resourceDataStoreManager, @NotNull ResourcesWriter resourcesWriter, @NotNull RecordWriter writer, @NotNull MutationResolver mutationResolver, @NotNull NodeFlattener nodeFlattener) {
        Intrinsics.checkNotNullParameter((Object)resourceDataStoreManager, (String)"resourceDataStoreManager");
        Intrinsics.checkNotNullParameter((Object)resourcesWriter, (String)"resourcesWriter");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)mutationResolver, (String)"mutationResolver");
        Intrinsics.checkNotNullParameter((Object)nodeFlattener, (String)"nodeFlattener");
        this.resourceDataStoreManager = resourceDataStoreManager;
        this.resourcesWriter = resourcesWriter;
        this.writer = writer;
        this.mutationResolver = mutationResolver;
        this.nodeFlattener = nodeFlattener;
        this.prevSnapshot = CollectionsKt.emptyList();
        this.prevRumContext = new SessionReplayRumContext(null, null, null, 7, null);
    }

    public /* synthetic */ RecordedDataProcessor(ResourceDataStoreManager resourceDataStoreManager, ResourcesWriter resourcesWriter, RecordWriter recordWriter, MutationResolver mutationResolver, NodeFlattener nodeFlattener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            nodeFlattener = new NodeFlattener(null, 1, null);
        }
        this(resourceDataStoreManager, resourcesWriter, recordWriter, mutationResolver, nodeFlattener);
    }

    @Override
    @WorkerThread
    public void processResources(@NotNull ResourceRecordedDataQueueItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        String resourceHash = item.getIdentifier();
        boolean isKnownResource = this.resourceDataStoreManager.isPreviouslySentResource$dd_sdk_android_session_replay_release(resourceHash);
        if (!isKnownResource) {
            if (this.resourceDataStoreManager.isReady$dd_sdk_android_session_replay_release()) {
                this.resourceDataStoreManager.cacheResourceHash$dd_sdk_android_session_replay_release(resourceHash);
            }
            EnrichedResource enrichedResource = new EnrichedResource(item.getResourceData(), item.getApplicationId(), resourceHash);
            this.resourcesWriter.write(enrichedResource);
        }
    }

    @Override
    @WorkerThread
    public void processScreenSnapshots(@NotNull SnapshotRecordedDataQueueItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.handleSnapshots(item.getRecordedQueuedItemContext$dd_sdk_android_session_replay_release().getNewRumContext$dd_sdk_android_session_replay_release(), item.getRecordedQueuedItemContext$dd_sdk_android_session_replay_release().getTimestamp$dd_sdk_android_session_replay_release(), item.getNodes$dd_sdk_android_session_replay_release(), item.getSystemInformation$dd_sdk_android_session_replay_release());
        this.prevRumContext = item.getRecordedQueuedItemContext$dd_sdk_android_session_replay_release().getNewRumContext$dd_sdk_android_session_replay_release();
    }

    @Override
    @WorkerThread
    public void processTouchEventsRecords(@NotNull TouchEventRecordedDataQueueItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.handleTouchRecords(item.getRecordedQueuedItemContext$dd_sdk_android_session_replay_release().getNewRumContext$dd_sdk_android_session_replay_release(), item.getTouchData$dd_sdk_android_session_replay_release());
    }

    @WorkerThread
    private final void handleTouchRecords(SessionReplayRumContext rumContext2, List<? extends MobileSegment.MobileRecord> touchData) {
        EnrichedRecord enrichedRecord = this.bundleRecordInEnrichedRecord(rumContext2, touchData);
        this.writer.write(enrichedRecord);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void handleSnapshots(SessionReplayRumContext newRumContext, long timestamp, List<Node> snapshots, SystemInformation systemInformation) {
        GlobalBounds screenBounds;
        boolean fullSnapshotRequired;
        Object it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = snapshots;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Node)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.nodeFlattener.flattenNode$dd_sdk_android_session_replay_release((Node)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List wireframes = (List)destination$iv$iv;
        if (wireframes.isEmpty()) {
            return;
        }
        List records = new LinkedList();
        boolean isNewView = this.isNewView(newRumContext);
        boolean isTimeForFullSnapshot = this.isTimeForFullSnapshot();
        boolean screenOrientationChanged = systemInformation.getScreenOrientation() != this.previousOrientation;
        boolean bl = fullSnapshotRequired = isNewView || isTimeForFullSnapshot || screenOrientationChanged;
        if (isNewView) {
            this.handleViewEndRecord(timestamp);
            screenBounds = systemInformation.getScreenBounds();
            MobileSegment.MobileRecord.MetaRecord metaRecord = new MobileSegment.MobileRecord.MetaRecord(timestamp, null, new MobileSegment.Data1(screenBounds.getWidth(), screenBounds.getHeight(), null, 4, null), 2, null);
            MobileSegment.MobileRecord.FocusRecord focusRecord = new MobileSegment.MobileRecord.FocusRecord(timestamp, null, new MobileSegment.Data2(true), 2, null);
            records.add(metaRecord);
            records.add(focusRecord);
        }
        if (screenOrientationChanged) {
            screenBounds = systemInformation.getScreenBounds();
            MobileSegment.MobileIncrementalData.ViewportResizeData viewPortResizeData = new MobileSegment.MobileIncrementalData.ViewportResizeData(screenBounds.getWidth(), screenBounds.getHeight());
            MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord viewportRecord = new MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord(timestamp, viewPortResizeData);
            records.add(viewportRecord);
        }
        if (fullSnapshotRequired) {
            records.add(new MobileSegment.MobileRecord.MobileFullSnapshotRecord(timestamp, new MobileSegment.Data(wireframes)));
        } else {
            MobileSegment.MobileIncrementalData.MobileMutationData mobileMutationData = this.mutationResolver.resolveMutations$dd_sdk_android_session_replay_release(this.prevSnapshot, wireframes);
            if (mobileMutationData != null) {
                it = mobileMutationData;
                boolean bl2 = false;
                records.add(new MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord(timestamp, (MobileSegment.MobileIncrementalData)it));
            }
        }
        this.prevSnapshot = wireframes;
        this.previousOrientation = systemInformation.getScreenOrientation();
        if (!((Collection)records).isEmpty()) {
            this.writer.write(this.bundleRecordInEnrichedRecord(newRumContext, records));
        }
    }

    private final boolean isTimeForFullSnapshot() {
        boolean bl;
        if (System.nanoTime() - this.lastSnapshotTimestamp >= FULL_SNAPSHOT_INTERVAL_IN_NS) {
            this.lastSnapshotTimestamp = System.nanoTime();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void handleViewEndRecord(long timestamp) {
        if (this.prevRumContext.isValid$dd_sdk_android_session_replay_release()) {
            MobileSegment.MobileRecord.ViewEndRecord viewEndRecord = new MobileSegment.MobileRecord.ViewEndRecord(timestamp, null, 2, null);
            this.writer.write(this.bundleRecordInEnrichedRecord(this.prevRumContext, CollectionsKt.listOf((Object)viewEndRecord)));
        }
    }

    private final EnrichedRecord bundleRecordInEnrichedRecord(SessionReplayRumContext rumContext2, List<? extends MobileSegment.MobileRecord> records) {
        return new EnrichedRecord(rumContext2.getApplicationId(), rumContext2.getSessionId(), rumContext2.getViewId(), records);
    }

    private final boolean isNewView(SessionReplayRumContext newContext) {
        return !Intrinsics.areEqual((Object)newContext.getApplicationId(), (Object)this.prevRumContext.getApplicationId()) || !Intrinsics.areEqual((Object)newContext.getSessionId(), (Object)this.prevRumContext.getSessionId()) || !Intrinsics.areEqual((Object)newContext.getViewId(), (Object)this.prevRumContext.getViewId());
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/internal/processor/RecordedDataProcessor$Companion;", "", "()V", "FULL_SNAPSHOT_INTERVAL_IN_NS", "", "getFULL_SNAPSHOT_INTERVAL_IN_NS$dd_sdk_android_session_replay_release", "()J", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getFULL_SNAPSHOT_INTERVAL_IN_NS$dd_sdk_android_session_replay_release() {
            return FULL_SNAPSHOT_INTERVAL_IN_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

