/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.processor;

import androidx.annotation.MainThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.internal.processor.RecordedQueuedItemContext;
import com.datadog.android.sessionreplay.internal.utils.RumContextProvider;
import com.datadog.android.sessionreplay.internal.utils.SessionReplayRumContext;
import com.datadog.android.sessionreplay.internal.utils.TimeProvider;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\t\u001a\u0004\u0018\u00010\nH\u0001\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/sessionreplay/internal/processor/RumContextDataHandler;", "", "rumContextProvider", "Lcom/datadog/android/sessionreplay/internal/utils/RumContextProvider;", "timeProvider", "Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/sessionreplay/internal/utils/RumContextProvider;Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;Lcom/datadog/android/api/InternalLogger;)V", "createRumContextData", "Lcom/datadog/android/sessionreplay/internal/processor/RecordedQueuedItemContext;", "createRumContextData$dd_sdk_android_session_replay_release", "Companion", "dd-sdk-android-session-replay_release"})
public final class RumContextDataHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumContextProvider rumContextProvider;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String INVALID_RUM_CONTEXT_ERROR_MESSAGE_FORMAT = "SR RumContextDataHandler: Invalid RUM context: [%s] when trying to bundle the RumContextData";

    public RumContextDataHandler(@NotNull RumContextProvider rumContextProvider, @NotNull TimeProvider timeProvider, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)rumContextProvider, (String)"rumContextProvider");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.rumContextProvider = rumContextProvider;
        this.timeProvider = timeProvider;
        this.internalLogger = internalLogger;
    }

    @MainThread
    @Nullable
    public final RecordedQueuedItemContext createRumContextData$dd_sdk_android_session_replay_release() {
        long timestamp = this.timeProvider.getDeviceTimestamp();
        SessionReplayRumContext newRumContext = this.rumContextProvider.getRumContext();
        if (newRumContext.isNotValid$dd_sdk_android_session_replay_release()) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(newRumContext){
                final /* synthetic */ SessionReplayRumContext $newRumContext;
                {
                    this.$newRumContext = $newRumContext;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "SR RumContextDataHandler: Invalid RUM context: [%s] when trying to bundle the RumContextData";
                    Locale locale = Locale.ENGLISH;
                    Object[] objectArray = new Object[]{this.$newRumContext.toString()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            return null;
        }
        return new RecordedQueuedItemContext(timestamp, SessionReplayRumContext.copy$default(newRumContext, null, null, null, 7, null));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/processor/RumContextDataHandler$Companion;", "", "()V", "INVALID_RUM_CONTEXT_ERROR_MESSAGE_FORMAT", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

