/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.processor;

import com.datadog.android.sessionreplay.internal.processor.BoundsUtils;
import com.datadog.android.sessionreplay.internal.processor.WireframeBounds;
import com.datadog.android.sessionreplay.internal.utils.WireframeExtKt;
import com.datadog.android.sessionreplay.model.MobileSegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ%\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/sessionreplay/internal/processor/WireframeUtils;", "", "boundsUtils", "Lcom/datadog/android/sessionreplay/internal/processor/BoundsUtils;", "(Lcom/datadog/android/sessionreplay/internal/processor/BoundsUtils;)V", "checkWireframeIsCovered", "", "wireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "topWireframes", "", "checkWireframeIsCovered$dd_sdk_android_session_replay_release", "checkWireframeIsValid", "checkWireframeIsValid$dd_sdk_android_session_replay_release", "resolveWireframeClip", "Lcom/datadog/android/sessionreplay/model/MobileSegment$WireframeClip;", "parents", "resolveWireframeClip$dd_sdk_android_session_replay_release", "clip", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nWireframeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireframeUtils.kt\ncom/datadog/android/sessionreplay/internal/processor/WireframeUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1549#2:85\n1620#2,3:86\n1855#2,2:89\n1855#2,2:91\n*S KotlinDebug\n*F\n+ 1 WireframeUtils.kt\ncom/datadog/android/sessionreplay/internal/processor/WireframeUtils\n*L\n25#1:85\n25#1:86,3\n25#1:89,2\n50#1:91,2\n*E\n"})
public final class WireframeUtils {
    @NotNull
    private final BoundsUtils boundsUtils;

    public WireframeUtils(@NotNull BoundsUtils boundsUtils) {
        Intrinsics.checkNotNullParameter((Object)boundsUtils, (String)"boundsUtils");
        this.boundsUtils = boundsUtils;
    }

    public /* synthetic */ WireframeUtils(BoundsUtils boundsUtils, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boundsUtils = BoundsUtils.INSTANCE;
        }
        this(boundsUtils);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MobileSegment.WireframeClip resolveWireframeClip$dd_sdk_android_session_replay_release(@NotNull MobileSegment.Wireframe wireframe, @NotNull List<? extends MobileSegment.Wireframe> parents) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wireframe, (String)"wireframe");
        Intrinsics.checkNotNullParameter(parents, (String)"parents");
        MobileSegment.WireframeClip previousClip = this.clip(wireframe);
        long clipTop = 0L;
        Object object = previousClip;
        clipTop = object != null && (object = ((MobileSegment.WireframeClip)object).getTop()) != null ? (Long)object : 0L;
        long clipLeft = 0L;
        Object object2 = previousClip;
        clipLeft = object2 != null && (object2 = ((MobileSegment.WireframeClip)object2).getLeft()) != null ? (Long)object2 : 0L;
        long clipRight = 0L;
        Object object3 = previousClip;
        clipRight = object3 != null && (object3 = ((MobileSegment.WireframeClip)object3).getRight()) != null ? (Long)object3 : 0L;
        long clipBottom = 0L;
        Object object4 = previousClip;
        clipBottom = object4 != null && (object4 = ((MobileSegment.WireframeClip)object4).getBottom()) != null ? (Long)object4 : 0L;
        WireframeBounds wireframeBounds = this.boundsUtils.resolveBounds$dd_sdk_android_session_replay_release(wireframe);
        Iterable $this$map$iv = parents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobileSegment.Wireframe wireframe2 = (MobileSegment.Wireframe)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.boundsUtils.resolveBounds$dd_sdk_android_session_replay_release((MobileSegment.Wireframe)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WireframeBounds it = (WireframeBounds)element$iv;
            boolean bl = false;
            clipTop = Math.max(it.getTop() - wireframeBounds.getTop(), clipTop);
            clipBottom = Math.max(wireframeBounds.getBottom() - it.getBottom(), clipBottom);
            clipLeft = Math.max(it.getLeft() - wireframeBounds.getLeft(), clipLeft);
            clipRight = Math.max(wireframeBounds.getRight() - it.getRight(), clipRight);
        }
        return clipTop > 0L || clipBottom > 0L || clipLeft > 0L || clipRight > 0L ? new MobileSegment.WireframeClip(clipTop, clipBottom, clipLeft, clipRight) : null;
    }

    public final boolean checkWireframeIsCovered$dd_sdk_android_session_replay_release(@NotNull MobileSegment.Wireframe wireframe, @NotNull List<? extends MobileSegment.Wireframe> topWireframes) {
        Intrinsics.checkNotNullParameter((Object)wireframe, (String)"wireframe");
        Intrinsics.checkNotNullParameter(topWireframes, (String)"topWireframes");
        WireframeBounds wireframeBounds = this.boundsUtils.resolveBounds$dd_sdk_android_session_replay_release(wireframe);
        Iterable $this$forEach$iv = topWireframes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MobileSegment.Wireframe it = (MobileSegment.Wireframe)element$iv;
            boolean bl = false;
            WireframeBounds topBounds = this.boundsUtils.resolveBounds$dd_sdk_android_session_replay_release(it);
            if (!this.boundsUtils.isCovering$dd_sdk_android_session_replay_release(topBounds, wireframeBounds) || !WireframeExtKt.hasOpaqueBackground(it)) continue;
            return true;
        }
        return false;
    }

    public final boolean checkWireframeIsValid$dd_sdk_android_session_replay_release(@NotNull MobileSegment.Wireframe wireframe) {
        Intrinsics.checkNotNullParameter((Object)wireframe, (String)"wireframe");
        WireframeBounds wireframeBounds = this.boundsUtils.resolveBounds$dd_sdk_android_session_replay_release(wireframe);
        return wireframeBounds.getWidth() > 0L && wireframeBounds.getHeight() > 0L && (!(wireframe instanceof MobileSegment.Wireframe.ShapeWireframe) || ((MobileSegment.Wireframe.ShapeWireframe)wireframe).getShapeStyle() != null || ((MobileSegment.Wireframe.ShapeWireframe)wireframe).getBorder() != null);
    }

    private final MobileSegment.WireframeClip clip(MobileSegment.Wireframe $this$clip) {
        MobileSegment.WireframeClip wireframeClip;
        MobileSegment.Wireframe wireframe = $this$clip;
        if (wireframe instanceof MobileSegment.Wireframe.ShapeWireframe) {
            wireframeClip = ((MobileSegment.Wireframe.ShapeWireframe)$this$clip).getClip();
        } else if (wireframe instanceof MobileSegment.Wireframe.TextWireframe) {
            wireframeClip = ((MobileSegment.Wireframe.TextWireframe)$this$clip).getClip();
        } else if (wireframe instanceof MobileSegment.Wireframe.ImageWireframe) {
            wireframeClip = ((MobileSegment.Wireframe.ImageWireframe)$this$clip).getClip();
        } else if (wireframe instanceof MobileSegment.Wireframe.PlaceholderWireframe) {
            wireframeClip = ((MobileSegment.Wireframe.PlaceholderWireframe)$this$clip).getClip();
        } else if (wireframe instanceof MobileSegment.Wireframe.WebviewWireframe) {
            wireframeClip = ((MobileSegment.Wireframe.WebviewWireframe)$this$clip).getClip();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return wireframeClip;
    }

    public WireframeUtils() {
        this(null, 1, null);
    }
}

