/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.os.Handler;
import android.os.Looper;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.sessionreplay.internal.recorder.RecordingTimeBank;
import com.datadog.android.sessionreplay.internal.recorder.TimeBank;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0016\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/Debouncer;", "", "handler", "Landroid/os/Handler;", "maxRecordDelayInNs", "", "timeBank", "Lcom/datadog/android/sessionreplay/internal/recorder/TimeBank;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "dynamicOptimizationEnabled", "", "(Landroid/os/Handler;JLcom/datadog/android/sessionreplay/internal/recorder/TimeBank;Lcom/datadog/android/api/feature/FeatureSdkCore;Z)V", "firstRequest", "lastTimeRecordWasPerformed", "debounce", "", "runnable", "Ljava/lang/Runnable;", "debounce$dd_sdk_android_session_replay_release", "executeRunnable", "logSkippedFrame", "runInTimeBalance", "block", "Lkotlin/Function0;", "Companion", "dd-sdk-android-session-replay_release"})
public final class Debouncer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Handler handler;
    private final long maxRecordDelayInNs;
    @NotNull
    private final TimeBank timeBank;
    @NotNull
    private final FeatureSdkCore sdkCore;
    private final boolean dynamicOptimizationEnabled;
    private long lastTimeRecordWasPerformed;
    private boolean firstRequest;
    private static final long MAX_DELAY_THRESHOLD_NS = TimeUnit.MILLISECONDS.toNanos(64L);
    public static final long DEBOUNCE_TIME_IN_MS = 64L;
    @NotNull
    private static final String TYPE_VALUE = "sr_skipped_frame";
    @NotNull
    private static final String TYPE_KEY = "type";

    public Debouncer(@NotNull Handler handler, long maxRecordDelayInNs, @NotNull TimeBank timeBank, @NotNull FeatureSdkCore sdkCore, boolean dynamicOptimizationEnabled) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)timeBank, (String)"timeBank");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.handler = handler;
        this.maxRecordDelayInNs = maxRecordDelayInNs;
        this.timeBank = timeBank;
        this.sdkCore = sdkCore;
        this.dynamicOptimizationEnabled = dynamicOptimizationEnabled;
        this.firstRequest = true;
    }

    public /* synthetic */ Debouncer(Handler handler, long l, TimeBank timeBank, FeatureSdkCore featureSdkCore, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            handler = new Handler(Looper.getMainLooper());
        }
        if ((n & 2) != 0) {
            l = MAX_DELAY_THRESHOLD_NS;
        }
        if ((n & 4) != 0) {
            timeBank = new RecordingTimeBank(0L, 1, null);
        }
        this(handler, l, timeBank, featureSdkCore, bl);
    }

    public final void debounce$dd_sdk_android_session_replay_release(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (this.firstRequest) {
            this.lastTimeRecordWasPerformed = System.nanoTime();
            this.firstRequest = false;
        }
        this.handler.removeCallbacksAndMessages(null);
        long timePassedSinceLastExecution = System.nanoTime() - this.lastTimeRecordWasPerformed;
        if (timePassedSinceLastExecution >= this.maxRecordDelayInNs) {
            this.executeRunnable(runnable);
        } else {
            this.handler.postDelayed(() -> Debouncer.debounce$lambda$0(this, runnable), 64L);
        }
    }

    private final void executeRunnable(Runnable runnable) {
        if (this.dynamicOptimizationEnabled) {
            this.runInTimeBalance((Function0<Unit>)((Function0)new Function0<Unit>(runnable){
                final /* synthetic */ Runnable $runnable;
                {
                    this.$runnable = $runnable;
                    super(0);
                }

                public final void invoke() {
                    this.$runnable.run();
                }
            }));
        } else {
            runnable.run();
        }
        this.lastTimeRecordWasPerformed = System.nanoTime();
    }

    private final void runInTimeBalance(Function0<Unit> block) {
        if (this.timeBank.updateAndCheck(System.nanoTime())) {
            long startTimeInNano = System.nanoTime();
            block.invoke();
            long endTimeInNano = System.nanoTime();
            this.timeBank.consume(endTimeInNano - startTimeInNano);
        } else {
            this.logSkippedFrame();
        }
    }

    private final void logSkippedFrame() {
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        if (featureScope == null) {
            return;
        }
        FeatureScope rumFeature = featureScope;
        Map telemetryEvent = MapsKt.mapOf((Pair)TuplesKt.to((Object)TYPE_KEY, (Object)TYPE_VALUE));
        rumFeature.sendEvent((Object)telemetryEvent);
    }

    private static final void debounce$lambda$0(Debouncer this$0, Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        this$0.executeRunnable($runnable);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/Debouncer$Companion;", "", "()V", "DEBOUNCE_TIME_IN_MS", "", "MAX_DELAY_THRESHOLD_NS", "TYPE_KEY", "", "TYPE_VALUE", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

