/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.view.ViewGroup;
import androidx.appcompat.widget.AppCompatSpinner;
import com.datadog.android.sessionreplay.recorder.OptionSelectorDetector;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/DefaultOptionSelectorDetector;", "Lcom/datadog/android/sessionreplay/recorder/OptionSelectorDetector;", "()V", "isOptionSelector", "", "view", "Landroid/view/ViewGroup;", "Companion", "dd-sdk-android-session-replay_release"})
public final class DefaultOptionSelectorDetector
implements OptionSelectorDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DROP_DOWN_LIST_CLASS_NAME = "android.widget.DropDownListView";
    @NotNull
    private static final String APPCOMPAT_DROP_DOWN_LIST_CLASS_NAME = "androidx.appcompat.widget.DropDownListView";
    @NotNull
    private static final String MATERIAL_TIME_PICKER_CLASS_NAME = "com.google.android.material.timepicker.TimePickerView";
    @NotNull
    private static final String MATERIAL_CALENDAR_GRID_CLASS_NAME = "com.google.android.material.datepicker.MaterialCalendarGridView";
    @NotNull
    private static final Set<String> OPTION_SELECTORS_CLASS_NAMES_SET;

    @Override
    public boolean isOptionSelector(@NotNull ViewGroup view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string = view.getClass().getCanonicalName();
        if (string == null) {
            string = "";
        }
        String viewClassName = string;
        boolean isAppCompatSpinner = AppCompatSpinner.class.isAssignableFrom(view.getClass());
        return OPTION_SELECTORS_CLASS_NAMES_SET.contains(viewClassName) || isAppCompatSpinner;
    }

    static {
        Object[] objectArray = new String[]{DROP_DOWN_LIST_CLASS_NAME, APPCOMPAT_DROP_DOWN_LIST_CLASS_NAME, MATERIAL_TIME_PICKER_CLASS_NAME, MATERIAL_CALENDAR_GRID_CLASS_NAME};
        OPTION_SELECTORS_CLASS_NAMES_SET = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/DefaultOptionSelectorDetector$Companion;", "", "()V", "APPCOMPAT_DROP_DOWN_LIST_CLASS_NAME", "", "DROP_DOWN_LIST_CLASS_NAME", "MATERIAL_CALENDAR_GRID_CLASS_NAME", "MATERIAL_TIME_PICKER_CLASS_NAME", "OPTION_SELECTORS_CLASS_NAMES_SET", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

