/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import com.datadog.android.sessionreplay.internal.recorder.TimeBank;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/RecordingTimeBank;", "Lcom/datadog/android/sessionreplay/internal/recorder/TimeBank;", "maxTimeBalancePerSecondInMs", "", "(J)V", "balanceFactor", "", "lastCheckTime", "recordingTimeBalanceInNano", "consume", "", "executionTime", "increaseTimeBank", "timestamp", "updateAndCheck", "", "Companion", "dd-sdk-android-session-replay_release"})
public final class RecordingTimeBank
implements TimeBank {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long maxTimeBalancePerSecondInMs;
    private final double balanceFactor;
    private volatile long recordingTimeBalanceInNano;
    private volatile long lastCheckTime;
    private static final long DEFAULT_MAX_TIME_BALANCE_PER_SEC_IN_MS = 100L;

    public RecordingTimeBank(long maxTimeBalancePerSecondInMs) {
        this.maxTimeBalancePerSecondInMs = maxTimeBalancePerSecondInMs;
        this.balanceFactor = (double)this.maxTimeBalancePerSecondInMs / (double)TimeUnit.SECONDS.toMillis(1L);
        this.recordingTimeBalanceInNano = TimeUnit.MILLISECONDS.toNanos(this.maxTimeBalancePerSecondInMs);
    }

    public /* synthetic */ RecordingTimeBank(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 100L;
        }
        this(l);
    }

    @Override
    public void consume(long executionTime) {
        this.recordingTimeBalanceInNano -= executionTime;
    }

    @Override
    public boolean updateAndCheck(long timestamp) {
        this.increaseTimeBank(timestamp);
        this.lastCheckTime = timestamp;
        return this.recordingTimeBalanceInNano >= 0L;
    }

    private final void increaseTimeBank(long timestamp) {
        long timePassedSinceLastExecution = timestamp - this.lastCheckTime;
        this.recordingTimeBalanceInNano += (long)((double)timePassedSinceLastExecution * this.balanceFactor);
        this.recordingTimeBalanceInNano = Math.min(TimeUnit.MILLISECONDS.toNanos(this.maxTimeBalancePerSecondInMs), this.recordingTimeBalanceInNano);
    }

    public RecordingTimeBank() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/RecordingTimeBank$Companion;", "", "()V", "DEFAULT_MAX_TIME_BALANCE_PER_SEC_IN_MS", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

