/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.Window;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.MapperTypeWrapper;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.LifecycleCallback;
import com.datadog.android.sessionreplay.internal.SessionReplayLifecycleCallback;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.internal.async.DataQueueHandler;
import com.datadog.android.sessionreplay.internal.async.RecordedDataQueueHandler;
import com.datadog.android.sessionreplay.internal.processor.MutationResolver;
import com.datadog.android.sessionreplay.internal.processor.RecordedDataProcessor;
import com.datadog.android.sessionreplay.internal.processor.RumContextDataHandler;
import com.datadog.android.sessionreplay.internal.recorder.ComposedOptionSelectorDetector;
import com.datadog.android.sessionreplay.internal.recorder.DefaultOnDrawListenerProducer;
import com.datadog.android.sessionreplay.internal.recorder.DefaultOptionSelectorDetector;
import com.datadog.android.sessionreplay.internal.recorder.OnDrawListenerProducer;
import com.datadog.android.sessionreplay.internal.recorder.Recorder;
import com.datadog.android.sessionreplay.internal.recorder.SnapshotProducer;
import com.datadog.android.sessionreplay.internal.recorder.TreeViewTraversal;
import com.datadog.android.sessionreplay.internal.recorder.ViewOnDrawInterceptor;
import com.datadog.android.sessionreplay.internal.recorder.ViewUtilsInternal;
import com.datadog.android.sessionreplay.internal.recorder.WindowCallbackInterceptor;
import com.datadog.android.sessionreplay.internal.recorder.WindowInspector;
import com.datadog.android.sessionreplay.internal.recorder.callback.OnWindowRefreshedCallback;
import com.datadog.android.sessionreplay.internal.recorder.mapper.DecorViewMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.HiddenViewMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.ViewWireframeMapper;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapCachesManager;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapPool;
import com.datadog.android.sessionreplay.internal.recorder.resources.Cache;
import com.datadog.android.sessionreplay.internal.recorder.resources.DefaultImageWireframeHelper;
import com.datadog.android.sessionreplay.internal.recorder.resources.ImageTypeResolver;
import com.datadog.android.sessionreplay.internal.recorder.resources.MD5HashGenerator;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourceResolver;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourcesLRUCache;
import com.datadog.android.sessionreplay.internal.recorder.resources.WebPImageCompression;
import com.datadog.android.sessionreplay.internal.resources.ResourceDataStoreManager;
import com.datadog.android.sessionreplay.internal.storage.RecordWriter;
import com.datadog.android.sessionreplay.internal.storage.ResourcesWriter;
import com.datadog.android.sessionreplay.internal.utils.DrawableUtils;
import com.datadog.android.sessionreplay.internal.utils.PathUtils;
import com.datadog.android.sessionreplay.internal.utils.RumContextProvider;
import com.datadog.android.sessionreplay.internal.utils.TimeProvider;
import com.datadog.android.sessionreplay.recorder.OptionSelectorDetector;
import com.datadog.android.sessionreplay.recorder.mapper.WireframeMapper;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DefaultColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DefaultViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.DefaultViewIdentifierResolver;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u009b\u0001\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0012\b\u0002\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"B\u00a3\u0001\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0012\b\u0002\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010#\u001a\u00020$\u0012\u0006\u0010%\u001a\u00020&\u0012\u0006\u0010'\u001a\u00020(\u0012\u0006\u0010)\u001a\u00020*\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010+\u001a\u00020,\u0012\u0006\u0010-\u001a\u00020.\u00a2\u0006\u0002\u0010/J\u0016\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0014H\u0017J\u0016\u00105\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0014H\u0017J\b\u00106\u001a\u000202H\u0016J\b\u00107\u001a\u000202H\u0016J\b\u00108\u001a\u000202H\u0016J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u000202H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/SessionReplayRecorder;", "Lcom/datadog/android/sessionreplay/internal/recorder/callback/OnWindowRefreshedCallback;", "Lcom/datadog/android/sessionreplay/internal/recorder/Recorder;", "appContext", "Landroid/app/Application;", "resourcesWriter", "Lcom/datadog/android/sessionreplay/internal/storage/ResourcesWriter;", "rumContextProvider", "Lcom/datadog/android/sessionreplay/internal/utils/RumContextProvider;", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "touchPrivacyManager", "Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "recordWriter", "Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;", "timeProvider", "Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;", "mappers", "", "Lcom/datadog/android/sessionreplay/MapperTypeWrapper;", "customOptionSelectorDetectors", "Lcom/datadog/android/sessionreplay/recorder/OptionSelectorDetector;", "customDrawableMappers", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "windowInspector", "Lcom/datadog/android/sessionreplay/internal/recorder/WindowInspector;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "resourceDataStoreManager", "Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager;", "dynamicOptimizationEnabled", "", "(Landroid/app/Application;Lcom/datadog/android/sessionreplay/internal/storage/ResourcesWriter;Lcom/datadog/android/sessionreplay/internal/utils/RumContextProvider;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Lcom/datadog/android/sessionreplay/ImagePrivacy;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/datadog/android/sessionreplay/internal/recorder/WindowInspector;Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager;Z)V", "windowCallbackInterceptor", "Lcom/datadog/android/sessionreplay/internal/recorder/WindowCallbackInterceptor;", "sessionReplayLifecycleCallback", "Lcom/datadog/android/sessionreplay/internal/LifecycleCallback;", "viewOnDrawInterceptor", "Lcom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor;", "recordedDataQueueHandler", "Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler;", "uiHandler", "Landroid/os/Handler;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/app/Application;Lcom/datadog/android/sessionreplay/internal/utils/RumContextProvider;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Lcom/datadog/android/sessionreplay/ImagePrivacy;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;Ljava/util/List;Ljava/util/List;Lcom/datadog/android/sessionreplay/internal/recorder/WindowInspector;Lcom/datadog/android/sessionreplay/internal/recorder/WindowCallbackInterceptor;Lcom/datadog/android/sessionreplay/internal/LifecycleCallback;Lcom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor;Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler;Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager;Landroid/os/Handler;Lcom/datadog/android/api/InternalLogger;)V", "shouldRecord", "onWindowsAdded", "", "windows", "Landroid/view/Window;", "onWindowsRemoved", "registerCallbacks", "resumeRecorders", "stopProcessingRecords", "stopRecorders", "unregisterCallbacks", "dd-sdk-android-session-replay_release"})
public final class SessionReplayRecorder
implements OnWindowRefreshedCallback,
Recorder {
    @NotNull
    private final Application appContext;
    @NotNull
    private final RumContextProvider rumContextProvider;
    @NotNull
    private final TextAndInputPrivacy textAndInputPrivacy;
    @NotNull
    private final ImagePrivacy imagePrivacy;
    @NotNull
    private final TouchPrivacyManager touchPrivacyManager;
    @NotNull
    private final RecordWriter recordWriter;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final List<MapperTypeWrapper<?>> mappers;
    @NotNull
    private final List<OptionSelectorDetector> customOptionSelectorDetectors;
    @NotNull
    private final WindowInspector windowInspector;
    @NotNull
    private final WindowCallbackInterceptor windowCallbackInterceptor;
    @NotNull
    private final LifecycleCallback sessionReplayLifecycleCallback;
    @NotNull
    private final RecordedDataQueueHandler recordedDataQueueHandler;
    @NotNull
    private final ViewOnDrawInterceptor viewOnDrawInterceptor;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final ResourceDataStoreManager resourceDataStoreManager;
    @NotNull
    private final Handler uiHandler;
    private boolean shouldRecord;

    public SessionReplayRecorder(@NotNull Application appContext, @NotNull ResourcesWriter resourcesWriter, @NotNull RumContextProvider rumContextProvider, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull ImagePrivacy imagePrivacy, @NotNull TouchPrivacyManager touchPrivacyManager, @NotNull RecordWriter recordWriter, @NotNull TimeProvider timeProvider, @NotNull List<? extends MapperTypeWrapper<?>> mappers, @NotNull List<? extends OptionSelectorDetector> customOptionSelectorDetectors, @NotNull List<? extends DrawableToColorMapper> customDrawableMappers, @NotNull WindowInspector windowInspector, @NotNull FeatureSdkCore sdkCore, @NotNull ResourceDataStoreManager resourceDataStoreManager, boolean dynamicOptimizationEnabled) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)resourcesWriter, (String)"resourcesWriter");
        Intrinsics.checkNotNullParameter((Object)rumContextProvider, (String)"rumContextProvider");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        Intrinsics.checkNotNullParameter((Object)recordWriter, (String)"recordWriter");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        Intrinsics.checkNotNullParameter(customOptionSelectorDetectors, (String)"customOptionSelectorDetectors");
        Intrinsics.checkNotNullParameter(customDrawableMappers, (String)"customDrawableMappers");
        Intrinsics.checkNotNullParameter((Object)windowInspector, (String)"windowInspector");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)resourceDataStoreManager, (String)"resourceDataStoreManager");
        InternalLogger internalLogger = sdkCore.getInternalLogger();
        RumContextDataHandler rumContextDataHandler = new RumContextDataHandler(rumContextProvider, timeProvider, internalLogger);
        RecordedDataProcessor processor = new RecordedDataProcessor(resourceDataStoreManager, resourcesWriter, recordWriter, new MutationResolver(internalLogger), null, 16, null);
        String applicationId = rumContextProvider.getRumContext().getApplicationId();
        this.appContext = appContext;
        this.rumContextProvider = rumContextProvider;
        this.textAndInputPrivacy = textAndInputPrivacy;
        this.imagePrivacy = imagePrivacy;
        this.touchPrivacyManager = touchPrivacyManager;
        this.recordWriter = recordWriter;
        this.timeProvider = timeProvider;
        this.mappers = mappers;
        this.customOptionSelectorDetectors = customOptionSelectorDetectors;
        this.windowInspector = windowInspector;
        this.recordedDataQueueHandler = new RecordedDataQueueHandler(processor, rumContextDataHandler, internalLogger, sdkCore.createSingleThreadExecutorService("sr-event-processing"), new ConcurrentLinkedQueue());
        this.resourceDataStoreManager = resourceDataStoreManager;
        ViewIdentifierResolver viewIdentifierResolver = DefaultViewIdentifierResolver.INSTANCE;
        ColorStringFormatter colorStringFormatter = DefaultColorStringFormatter.INSTANCE;
        ViewBoundsResolver viewBoundsResolver = DefaultViewBoundsResolver.INSTANCE;
        DrawableToColorMapper drawableToColorMapper = DrawableToColorMapper.Companion.getDefault(customDrawableMappers);
        ViewWireframeMapper defaultVWM = new ViewWireframeMapper(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
        BitmapPool bitmapPool = new BitmapPool(null, null, null, null, null, 31, null);
        Object object = new ResourcesLRUCache(null, null, null, 7, null);
        BitmapCachesManager bitmapCachesManager = new BitmapCachesManager((Cache)object, bitmapPool, internalLogger);
        object = this.recordedDataQueueHandler;
        Object object2 = new PathUtils(internalLogger, bitmapCachesManager, null, null, null, 28, null);
        Object object3 = new DrawableUtils(internalLogger, bitmapCachesManager, sdkCore.createSingleThreadExecutorService("drawables"), null, null, 24, null);
        Object object4 = new MD5HashGenerator(internalLogger);
        WebPImageCompression webPImageCompression = new WebPImageCompression(internalLogger);
        ResourceResolver resourceResolver = new ResourceResolver(bitmapCachesManager, (PathUtils)object2, null, (DrawableUtils)object3, webPImageCompression, internalLogger, (MD5HashGenerator)object4, (DataQueueHandler)object, applicationId, null, 516, null);
        object2 = new DecorViewMapper(defaultVWM, viewIdentifierResolver);
        object3 = new HiddenViewMapper(viewIdentifierResolver, viewBoundsResolver);
        object4 = new ViewUtilsInternal();
        object = new DefaultOnDrawListenerProducer(new SnapshotProducer(new DefaultImageWireframeHelper(internalLogger, resourceResolver, viewIdentifierResolver, new ViewUtilsInternal(), new ImageTypeResolver()), new TreeViewTraversal(mappers, defaultVWM, (HiddenViewMapper)object3, (WireframeMapper)object2, (ViewUtilsInternal)object4, internalLogger), new ComposedOptionSelectorDetector(CollectionsKt.plus((Collection)customOptionSelectorDetectors, (Object)new DefaultOptionSelectorDetector())), touchPrivacyManager, internalLogger), this.recordedDataQueueHandler, sdkCore, dynamicOptimizationEnabled);
        this.viewOnDrawInterceptor = new ViewOnDrawInterceptor(internalLogger, touchPrivacyManager, (OnDrawListenerProducer)object);
        this.windowCallbackInterceptor = new WindowCallbackInterceptor(this.recordedDataQueueHandler, this.viewOnDrawInterceptor, timeProvider, internalLogger, imagePrivacy, textAndInputPrivacy, touchPrivacyManager);
        this.sessionReplayLifecycleCallback = new SessionReplayLifecycleCallback(this);
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.internalLogger = internalLogger;
    }

    public /* synthetic */ SessionReplayRecorder(Application application, ResourcesWriter resourcesWriter, RumContextProvider rumContextProvider, TextAndInputPrivacy textAndInputPrivacy, ImagePrivacy imagePrivacy, TouchPrivacyManager touchPrivacyManager, RecordWriter recordWriter, TimeProvider timeProvider, List list, List list2, List list3, WindowInspector windowInspector, FeatureSdkCore featureSdkCore, ResourceDataStoreManager resourceDataStoreManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x200) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x800) != 0) {
            windowInspector = WindowInspector.INSTANCE;
        }
        this(application, resourcesWriter, rumContextProvider, textAndInputPrivacy, imagePrivacy, touchPrivacyManager, recordWriter, timeProvider, list, list2, list3, windowInspector, featureSdkCore, resourceDataStoreManager, bl);
    }

    @VisibleForTesting
    public SessionReplayRecorder(@NotNull Application appContext, @NotNull RumContextProvider rumContextProvider, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull ImagePrivacy imagePrivacy, @NotNull TouchPrivacyManager touchPrivacyManager, @NotNull RecordWriter recordWriter, @NotNull TimeProvider timeProvider, @NotNull List<? extends MapperTypeWrapper<?>> mappers, @NotNull List<? extends OptionSelectorDetector> customOptionSelectorDetectors, @NotNull WindowInspector windowInspector, @NotNull WindowCallbackInterceptor windowCallbackInterceptor, @NotNull LifecycleCallback sessionReplayLifecycleCallback, @NotNull ViewOnDrawInterceptor viewOnDrawInterceptor, @NotNull RecordedDataQueueHandler recordedDataQueueHandler, @NotNull ResourceDataStoreManager resourceDataStoreManager, @NotNull Handler uiHandler, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)rumContextProvider, (String)"rumContextProvider");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        Intrinsics.checkNotNullParameter((Object)recordWriter, (String)"recordWriter");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        Intrinsics.checkNotNullParameter(customOptionSelectorDetectors, (String)"customOptionSelectorDetectors");
        Intrinsics.checkNotNullParameter((Object)windowInspector, (String)"windowInspector");
        Intrinsics.checkNotNullParameter((Object)windowCallbackInterceptor, (String)"windowCallbackInterceptor");
        Intrinsics.checkNotNullParameter((Object)sessionReplayLifecycleCallback, (String)"sessionReplayLifecycleCallback");
        Intrinsics.checkNotNullParameter((Object)viewOnDrawInterceptor, (String)"viewOnDrawInterceptor");
        Intrinsics.checkNotNullParameter((Object)recordedDataQueueHandler, (String)"recordedDataQueueHandler");
        Intrinsics.checkNotNullParameter((Object)resourceDataStoreManager, (String)"resourceDataStoreManager");
        Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.appContext = appContext;
        this.rumContextProvider = rumContextProvider;
        this.textAndInputPrivacy = textAndInputPrivacy;
        this.imagePrivacy = imagePrivacy;
        this.touchPrivacyManager = touchPrivacyManager;
        this.recordWriter = recordWriter;
        this.timeProvider = timeProvider;
        this.mappers = mappers;
        this.customOptionSelectorDetectors = customOptionSelectorDetectors;
        this.windowInspector = windowInspector;
        this.recordedDataQueueHandler = recordedDataQueueHandler;
        this.viewOnDrawInterceptor = viewOnDrawInterceptor;
        this.windowCallbackInterceptor = windowCallbackInterceptor;
        this.sessionReplayLifecycleCallback = sessionReplayLifecycleCallback;
        this.uiHandler = uiHandler;
        this.internalLogger = internalLogger;
        this.resourceDataStoreManager = resourceDataStoreManager;
    }

    public /* synthetic */ SessionReplayRecorder(Application application, RumContextProvider rumContextProvider, TextAndInputPrivacy textAndInputPrivacy, ImagePrivacy imagePrivacy, TouchPrivacyManager touchPrivacyManager, RecordWriter recordWriter, TimeProvider timeProvider, List list, List list2, WindowInspector windowInspector, WindowCallbackInterceptor windowCallbackInterceptor, LifecycleCallback lifecycleCallback, ViewOnDrawInterceptor viewOnDrawInterceptor, RecordedDataQueueHandler recordedDataQueueHandler, ResourceDataStoreManager resourceDataStoreManager, Handler handler, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x200) != 0) {
            windowInspector = WindowInspector.INSTANCE;
        }
        this(application, rumContextProvider, textAndInputPrivacy, imagePrivacy, touchPrivacyManager, recordWriter, timeProvider, list, (List<? extends OptionSelectorDetector>)list2, windowInspector, windowCallbackInterceptor, lifecycleCallback, viewOnDrawInterceptor, recordedDataQueueHandler, resourceDataStoreManager, handler, internalLogger);
    }

    @Override
    public void stopProcessingRecords() {
        this.recordedDataQueueHandler.clearAndStopProcessingQueue();
    }

    @Override
    public void registerCallbacks() {
        this.appContext.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.sessionReplayLifecycleCallback);
    }

    @Override
    public void unregisterCallbacks() {
        this.appContext.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.sessionReplayLifecycleCallback);
    }

    @Override
    public void resumeRecorders() {
        this.uiHandler.post(() -> SessionReplayRecorder.resumeRecorders$lambda$0(this));
    }

    @Override
    public void stopRecorders() {
        this.uiHandler.post(() -> SessionReplayRecorder.stopRecorders$lambda$1(this));
    }

    @Override
    @MainThread
    public void onWindowsAdded(@NotNull List<? extends Window> windows) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        if (this.shouldRecord) {
            List<View> decorViews = this.windowInspector.getGlobalWindowViews(this.internalLogger);
            this.windowCallbackInterceptor.intercept(windows, (Context)this.appContext);
            this.viewOnDrawInterceptor.intercept(decorViews, this.textAndInputPrivacy, this.imagePrivacy);
        }
    }

    @Override
    @MainThread
    public void onWindowsRemoved(@NotNull List<? extends Window> windows) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        if (this.shouldRecord) {
            List<View> decorViews = this.windowInspector.getGlobalWindowViews(this.internalLogger);
            this.windowCallbackInterceptor.stopIntercepting(windows);
            this.viewOnDrawInterceptor.intercept(decorViews, this.textAndInputPrivacy, this.imagePrivacy);
        }
    }

    private static final void resumeRecorders$lambda$0(SessionReplayRecorder this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.shouldRecord = true;
        List<Window> windows = this$0.sessionReplayLifecycleCallback.getCurrentWindows();
        List<View> decorViews = this$0.windowInspector.getGlobalWindowViews(this$0.internalLogger);
        this$0.windowCallbackInterceptor.intercept(windows, (Context)this$0.appContext);
        this$0.viewOnDrawInterceptor.intercept(decorViews, this$0.textAndInputPrivacy, this$0.imagePrivacy);
    }

    private static final void stopRecorders$lambda$1(SessionReplayRecorder this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.viewOnDrawInterceptor.stopIntercepting();
        this$0.windowCallbackInterceptor.stopIntercepting();
        this$0.shouldRecord = false;
    }
}

