/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.profiler.BenchmarkSpan;
import com.datadog.android.internal.profiler.BenchmarkSpanBuilder;
import com.datadog.android.internal.profiler.BenchmarkTracer;
import com.datadog.android.internal.profiler.GlobalBenchmark;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.R;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.internal.async.RecordedDataQueueRefs;
import com.datadog.android.sessionreplay.internal.recorder.Node;
import com.datadog.android.sessionreplay.internal.recorder.SnapshotProducer;
import com.datadog.android.sessionreplay.internal.recorder.TraversalStrategy;
import com.datadog.android.sessionreplay.internal.recorder.TreeViewTraversal;
import com.datadog.android.sessionreplay.internal.recorder.callback.DefaultInteropViewCallback;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.OptionSelectorDetector;
import com.datadog.android.sessionreplay.recorder.SystemInformation;
import com.datadog.android.sessionreplay.utils.ImageWireframeHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ0\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0002J2\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0012H\u0002J\u0018\u0010)\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/SnapshotProducer;", "", "imageWireframeHelper", "Lcom/datadog/android/sessionreplay/utils/ImageWireframeHelper;", "treeViewTraversal", "Lcom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal;", "optionSelectorDetector", "Lcom/datadog/android/sessionreplay/recorder/OptionSelectorDetector;", "touchPrivacyManager", "Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/sessionreplay/utils/ImageWireframeHelper;Lcom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal;Lcom/datadog/android/sessionreplay/recorder/OptionSelectorDetector;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;Lcom/datadog/android/api/InternalLogger;)V", "convertViewToNode", "Lcom/datadog/android/sessionreplay/internal/recorder/Node;", "view", "Landroid/view/View;", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "parents", "Ljava/util/LinkedList;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "recordedDataQueueRefs", "Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueRefs;", "logInvalidPrivacyLevelError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "produce", "rootView", "systemInformation", "Lcom/datadog/android/sessionreplay/recorder/SystemInformation;", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "resolveChildMappingContext", "parent", "Landroid/view/ViewGroup;", "parentMappingContext", "resolvePrivacyOverrides", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nSnapshotProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotProducer.kt\ncom/datadog/android/sessionreplay/internal/recorder/SnapshotProducer\n+ 2 BenchmarkExt.kt\ncom/datadog/android/sessionreplay/internal/recorder/BenchmarkExtKt\n+ 3 BenchmarkSpanExt.kt\ncom/datadog/android/internal/profiler/BenchmarkSpanExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n24#2:160\n22#2:161\n23#3,13:162\n36#3:176\n1#4:175\n*S KotlinDebug\n*F\n+ 1 SnapshotProducer.kt\ncom/datadog/android/sessionreplay/internal/recorder/SnapshotProducer\n*L\n68#1:160\n68#1:161\n68#1:162,13\n68#1:176\n*E\n"})
public final class SnapshotProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageWireframeHelper imageWireframeHelper;
    @NotNull
    private final TreeViewTraversal treeViewTraversal;
    @NotNull
    private final OptionSelectorDetector optionSelectorDetector;
    @NotNull
    private final TouchPrivacyManager touchPrivacyManager;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String INVALID_PRIVACY_LEVEL_ERROR = "Invalid privacy level";

    public SnapshotProducer(@NotNull ImageWireframeHelper imageWireframeHelper, @NotNull TreeViewTraversal treeViewTraversal, @NotNull OptionSelectorDetector optionSelectorDetector, @NotNull TouchPrivacyManager touchPrivacyManager, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)imageWireframeHelper, (String)"imageWireframeHelper");
        Intrinsics.checkNotNullParameter((Object)treeViewTraversal, (String)"treeViewTraversal");
        Intrinsics.checkNotNullParameter((Object)optionSelectorDetector, (String)"optionSelectorDetector");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.imageWireframeHelper = imageWireframeHelper;
        this.treeViewTraversal = treeViewTraversal;
        this.optionSelectorDetector = optionSelectorDetector;
        this.touchPrivacyManager = touchPrivacyManager;
        this.internalLogger = internalLogger;
    }

    @UiThread
    @Nullable
    public final Node produce(@NotNull View rootView, @NotNull SystemInformation systemInformation, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull ImagePrivacy imagePrivacy, @NotNull RecordedDataQueueRefs recordedDataQueueRefs) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)systemInformation, (String)"systemInformation");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)recordedDataQueueRefs, (String)"recordedDataQueueRefs");
        return this.convertViewToNode(rootView, new MappingContext(systemInformation, this.imageWireframeHelper, textAndInputPrivacy, imagePrivacy, this.touchPrivacyManager, false, new DefaultInteropViewCallback(this.treeViewTraversal, recordedDataQueueRefs), 32, null), new LinkedList<MobileSegment.Wireframe>(), recordedDataQueueRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @UiThread
    private final Node convertViewToNode(View view, MappingContext mappingContext, LinkedList<MobileSegment.Wireframe> parents, RecordedDataQueueRefs recordedDataQueueRefs) {
        Node node;
        void additionalProperties$iv$iv;
        void spanName$iv;
        String string = view.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view::class.java.simpleName");
        String string2 = string;
        boolean isContainer$iv = view instanceof ViewGroup;
        boolean $i$f$withinSRBenchmarkSpan = false;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"attribute.container", (Object)String.valueOf(isContainer$iv)));
        boolean $i$f$withinBenchmarkSpan = false;
        BenchmarkTracer tracer$iv$iv = GlobalBenchmark.INSTANCE.get().getTracer("dd-sdk-android");
        BenchmarkSpanBuilder spanBuilder$iv$iv = tracer$iv$iv.spanBuilder((String)spanName$iv, (Map)additionalProperties$iv$iv);
        BenchmarkSpan span$iv$iv = spanBuilder$iv$iv.startSpan();
        try {
            BenchmarkSpan $this$convertViewToNode_u24lambda_u242 = span$iv$iv;
            boolean bl = false;
            MappingContext localMappingContext = this.resolvePrivacyOverrides(view, mappingContext);
            TreeViewTraversal.TraversedTreeView traversedTreeView = this.treeViewTraversal.traverse(view, localMappingContext, recordedDataQueueRefs);
            TraversalStrategy nextTraversalStrategy = traversedTreeView.getNextActionStrategy();
            List<MobileSegment.Wireframe> resolvedWireframes2 = traversedTreeView.getMappedWireframes();
            if (nextTraversalStrategy == TraversalStrategy.STOP_AND_DROP_NODE) {
                Node node2 = null;
                return node2;
            }
            if (nextTraversalStrategy == TraversalStrategy.STOP_AND_RETURN_NODE) {
                Node node3 = new Node(resolvedWireframes2, null, parents, 2, null);
                return node3;
            }
            LinkedList<Node> childNodes = new LinkedList<Node>();
            if (view instanceof ViewGroup && ((ViewGroup)view).getChildCount() > 0 && nextTraversalStrategy == TraversalStrategy.TRAVERSE_ALL_CHILDREN) {
                LinkedList<MobileSegment.Wireframe> linkedList;
                MappingContext childMappingContext = this.resolveChildMappingContext((ViewGroup)view, localMappingContext);
                LinkedList<MobileSegment.Wireframe> $this$convertViewToNode_u24lambda_u242_u24lambda_u240 = linkedList = new LinkedList<MobileSegment.Wireframe>((Collection)parents);
                boolean bl2 = false;
                $this$convertViewToNode_u24lambda_u242_u24lambda_u240.addAll((Collection)resolvedWireframes2);
                LinkedList<MobileSegment.Wireframe> parentsCopy = linkedList;
                int n = ((ViewGroup)view).getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view2;
                    View view3 = view2 = ((ViewGroup)view).getChildAt(i);
                    if (view3 == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.getChildAt(i) ?: continue");
                    View viewChild = view2;
                    if (this.convertViewToNode(viewChild, childMappingContext, parentsCopy, recordedDataQueueRefs) != null) {
                        Node it;
                        boolean bl3 = false;
                        childNodes.add(it);
                    }
                }
            }
            node = new Node(resolvedWireframes2, (List<Node>)childNodes, (List<? extends MobileSegment.Wireframe>)parents);
        }
        finally {
            span$iv$iv.stop();
        }
        return node;
    }

    private final MappingContext resolveChildMappingContext(ViewGroup parent, MappingContext parentMappingContext) {
        return this.optionSelectorDetector.isOptionSelector(parent) ? MappingContext.copy$default(parentMappingContext, null, null, null, null, null, true, null, 95, null) : parentMappingContext;
    }

    private final MappingContext resolvePrivacyOverrides(View view, MappingContext mappingContext) {
        Object privacy;
        Object object;
        try {
            object = view.getTag(R.id.datadog_image_privacy);
            privacy = object instanceof String ? (String)object : null;
            privacy = privacy == null ? mappingContext.getImagePrivacy() : ImagePrivacy.valueOf((String)privacy);
        }
        catch (IllegalArgumentException e) {
            this.logInvalidPrivacyLevelError(e);
            privacy = mappingContext.getImagePrivacy();
        }
        Object imagePrivacy = privacy;
        try {
            Object object2 = view.getTag(R.id.datadog_text_and_input_privacy);
            String privacy2 = object2 instanceof String ? (String)object2 : null;
            object = privacy2 == null ? mappingContext.getTextAndInputPrivacy() : TextAndInputPrivacy.valueOf(privacy2);
        }
        catch (IllegalArgumentException e) {
            this.logInvalidPrivacyLevelError(e);
            object = mappingContext.getTextAndInputPrivacy();
        }
        Object textAndInputPrivacy = object;
        return MappingContext.copy$default(mappingContext, null, null, (TextAndInputPrivacy)textAndInputPrivacy, (ImagePrivacy)imagePrivacy, null, false, null, 115, null);
    }

    private final void logInvalidPrivacyLevelError(Exception e) {
        Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)logInvalidPrivacyLevelError.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/SnapshotProducer$Companion;", "", "()V", "INVALID_PRIVACY_LEVEL_ERROR", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

