/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureScopeExtKt;
import com.datadog.android.core.metrics.MethodCallSamplingRate;
import com.datadog.android.sessionreplay.MapperTypeWrapper;
import com.datadog.android.sessionreplay.R;
import com.datadog.android.sessionreplay.TouchPrivacy;
import com.datadog.android.sessionreplay.internal.async.RecordedDataQueueRefs;
import com.datadog.android.sessionreplay.internal.recorder.TraversalStrategy;
import com.datadog.android.sessionreplay.internal.recorder.TreeViewTraversal;
import com.datadog.android.sessionreplay.internal.recorder.ViewUtilsInternal;
import com.datadog.android.sessionreplay.internal.recorder.mapper.HiddenViewMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.QueueStatusCallback;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.TraverseAllChildrenMapper;
import com.datadog.android.sessionreplay.recorder.mapper.WireframeMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.NoOpAsyncJobStatusCallback;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eBK\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0003R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal;", "", "mappers", "", "Lcom/datadog/android/sessionreplay/MapperTypeWrapper;", "defaultViewMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/WireframeMapper;", "Landroid/view/View;", "hiddenViewMapper", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/HiddenViewMapper;", "decorViewMapper", "viewUtilsInternal", "Lcom/datadog/android/sessionreplay/internal/recorder/ViewUtilsInternal;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/util/List;Lcom/datadog/android/sessionreplay/recorder/mapper/WireframeMapper;Lcom/datadog/android/sessionreplay/internal/recorder/mapper/HiddenViewMapper;Lcom/datadog/android/sessionreplay/recorder/mapper/WireframeMapper;Lcom/datadog/android/sessionreplay/internal/recorder/ViewUtilsInternal;Lcom/datadog/android/api/InternalLogger;)V", "findMapperForView", "view", "isDecorView", "", "isHidden", "traverse", "Lcom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal$TraversedTreeView;", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "recordedDataQueueRefs", "Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueRefs;", "updateTouchOverrideAreas", "", "Companion", "TraversedTreeView", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nTreeViewTraversal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeViewTraversal.kt\ncom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n288#2,2:167\n*S KotlinDebug\n*F\n+ 1 TreeViewTraversal.kt\ncom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal\n*L\n117#1:167,2\n*E\n"})
public final class TreeViewTraversal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MapperTypeWrapper<?>> mappers;
    @NotNull
    private final WireframeMapper<View> defaultViewMapper;
    @NotNull
    private final HiddenViewMapper hiddenViewMapper;
    @NotNull
    private final WireframeMapper<View> decorViewMapper;
    @NotNull
    private final ViewUtilsInternal viewUtilsInternal;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String METHOD_CALL_MAP_PREFIX = "Map with";

    public TreeViewTraversal(@NotNull List<? extends MapperTypeWrapper<?>> mappers, @NotNull WireframeMapper<? super View> defaultViewMapper, @NotNull HiddenViewMapper hiddenViewMapper, @NotNull WireframeMapper<? super View> decorViewMapper, @NotNull ViewUtilsInternal viewUtilsInternal, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(mappers, (String)"mappers");
        Intrinsics.checkNotNullParameter(defaultViewMapper, (String)"defaultViewMapper");
        Intrinsics.checkNotNullParameter((Object)hiddenViewMapper, (String)"hiddenViewMapper");
        Intrinsics.checkNotNullParameter(decorViewMapper, (String)"decorViewMapper");
        Intrinsics.checkNotNullParameter((Object)viewUtilsInternal, (String)"viewUtilsInternal");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.mappers = mappers;
        this.defaultViewMapper = defaultViewMapper;
        this.hiddenViewMapper = hiddenViewMapper;
        this.decorViewMapper = decorViewMapper;
        this.viewUtilsInternal = viewUtilsInternal;
        this.internalLogger = internalLogger;
    }

    @UiThread
    @NotNull
    public final TraversedTreeView traverse(@NotNull View view, @NotNull MappingContext mappingContext, @NotNull RecordedDataQueueRefs recordedDataQueueRefs) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)recordedDataQueueRefs, (String)"recordedDataQueueRefs");
        if (this.viewUtilsInternal.isNotVisible$dd_sdk_android_session_replay_release(view) || this.viewUtilsInternal.isSystemNoise$dd_sdk_android_session_replay_release(view)) {
            return new TraversedTreeView(CollectionsKt.emptyList(), TraversalStrategy.STOP_AND_DROP_NODE);
        }
        TraversalStrategy traversalStrategy = null;
        NoOpAsyncJobStatusCallback noOpCallback = new NoOpAsyncJobStatusCallback();
        AsyncJobStatusCallback jobStatusCallback = null;
        Ref.ObjectRef mapper = new Ref.ObjectRef();
        mapper.element = this.findMapperForView(view);
        this.updateTouchOverrideAreas(view, mappingContext);
        if (this.isHidden(view)) {
            traversalStrategy = TraversalStrategy.STOP_AND_RETURN_NODE;
            mapper.element = this.hiddenViewMapper;
            jobStatusCallback = noOpCallback;
        } else if (mapper.element != null) {
            jobStatusCallback = new QueueStatusCallback(recordedDataQueueRefs);
            traversalStrategy = mapper.element instanceof TraverseAllChildrenMapper ? TraversalStrategy.TRAVERSE_ALL_CHILDREN : TraversalStrategy.STOP_AND_RETURN_NODE;
        } else if (this.isDecorView(view)) {
            traversalStrategy = TraversalStrategy.TRAVERSE_ALL_CHILDREN;
            mapper.element = this.decorViewMapper;
            jobStatusCallback = noOpCallback;
        } else if (view instanceof ViewGroup) {
            traversalStrategy = TraversalStrategy.TRAVERSE_ALL_CHILDREN;
            mapper.element = this.defaultViewMapper;
            jobStatusCallback = noOpCallback;
        } else {
            traversalStrategy = TraversalStrategy.STOP_AND_RETURN_NODE;
            mapper.element = this.defaultViewMapper;
            jobStatusCallback = noOpCallback;
            String string = view.getClass().getCanonicalName();
            if (string == null) {
                string = view.getClass().getName();
            }
            String viewType = string;
            this.internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.TELEMETRY, (Function0)new Function0<String>(viewType){
                final /* synthetic */ String $viewType;
                {
                    this.$viewType = $viewType;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "No mapper found for view " + this.$viewType;
                }
            }, null, true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"replay.widget.type", (Object)viewType)));
        }
        List resolvedWireframes2 = (List)FeatureScopeExtKt.measureMethodCallPerf((InternalLogger)this.internalLogger, this.getClass(), (String)("Map with " + mapper.element.getClass().getSimpleName()), (float)MethodCallSamplingRate.RARE.getRate(), (Function0)((Function0)new Function0<List<? extends MobileSegment.Wireframe>>((Ref.ObjectRef<WireframeMapper<View>>)mapper, view, mappingContext, jobStatusCallback, this){
            final /* synthetic */ Ref.ObjectRef<WireframeMapper<View>> $mapper;
            final /* synthetic */ View $view;
            final /* synthetic */ MappingContext $mappingContext;
            final /* synthetic */ AsyncJobStatusCallback $jobStatusCallback;
            final /* synthetic */ TreeViewTraversal this$0;
            {
                this.$mapper = $mapper;
                this.$view = $view;
                this.$mappingContext = $mappingContext;
                this.$jobStatusCallback = $jobStatusCallback;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<MobileSegment.Wireframe> invoke() {
                return ((WireframeMapper)this.$mapper.element).map(this.$view, this.$mappingContext, this.$jobStatusCallback, TreeViewTraversal.access$getInternalLogger$p(this.this$0));
            }
        }));
        return new TraversedTreeView(resolvedWireframes2, traversalStrategy);
    }

    private final boolean isDecorView(View view) {
        ViewParent viewParent = view.getParent();
        if (viewParent == null) {
            return true;
        }
        ViewParent viewParent2 = viewParent;
        return !View.class.isAssignableFrom(viewParent2.getClass());
    }

    private final WireframeMapper<View> findMapperForView(View view) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.mappers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MapperTypeWrapper it = (MapperTypeWrapper)element$iv;
                boolean bl = false;
                if (!it.supportsView(view)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        MapperTypeWrapper mapperTypeWrapper = v0;
        return mapperTypeWrapper != null ? mapperTypeWrapper.getUnsafeMapper() : null;
    }

    private final boolean isHidden(View view) {
        return Intrinsics.areEqual((Object)view.getTag(R.id.datadog_hidden), (Object)true);
    }

    @UiThread
    private final void updateTouchOverrideAreas(View view, MappingContext mappingContext) {
        Object touchPrivacy = view.getTag(R.id.datadog_touch_privacy);
        if (touchPrivacy != null) {
            int[] locationOnScreen = new int[2];
            view.getLocationOnScreen(locationOnScreen);
            int x = locationOnScreen[0];
            int y = locationOnScreen[1];
            Rect viewArea = new Rect(x - view.getPaddingLeft(), y - view.getPaddingTop(), x + view.getWidth() + view.getPaddingRight(), y + view.getHeight() + view.getPaddingBottom());
            try {
                String string = touchPrivacy.toString();
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string2 = string.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                TouchPrivacy privacyLevel = TouchPrivacy.valueOf(string2);
                mappingContext.getTouchPrivacyManager().addTouchOverrideArea(viewArea, privacyLevel);
            }
            catch (IllegalArgumentException e) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)updateTouchOverrideAreas.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            }
        }
    }

    public static final /* synthetic */ InternalLogger access$getInternalLogger$p(TreeViewTraversal $this) {
        return $this.internalLogger;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal$Companion;", "", "()V", "METHOD_CALL_MAP_PREFIX", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/TreeViewTraversal$TraversedTreeView;", "", "mappedWireframes", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "nextActionStrategy", "Lcom/datadog/android/sessionreplay/internal/recorder/TraversalStrategy;", "(Ljava/util/List;Lcom/datadog/android/sessionreplay/internal/recorder/TraversalStrategy;)V", "getMappedWireframes", "()Ljava/util/List;", "getNextActionStrategy", "()Lcom/datadog/android/sessionreplay/internal/recorder/TraversalStrategy;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dd-sdk-android-session-replay_release"})
    public static final class TraversedTreeView {
        @NotNull
        private final List<MobileSegment.Wireframe> mappedWireframes;
        @NotNull
        private final TraversalStrategy nextActionStrategy;

        public TraversedTreeView(@NotNull List<? extends MobileSegment.Wireframe> mappedWireframes, @NotNull TraversalStrategy nextActionStrategy) {
            Intrinsics.checkNotNullParameter(mappedWireframes, (String)"mappedWireframes");
            Intrinsics.checkNotNullParameter((Object)((Object)nextActionStrategy), (String)"nextActionStrategy");
            this.mappedWireframes = mappedWireframes;
            this.nextActionStrategy = nextActionStrategy;
        }

        @NotNull
        public final List<MobileSegment.Wireframe> getMappedWireframes() {
            return this.mappedWireframes;
        }

        @NotNull
        public final TraversalStrategy getNextActionStrategy() {
            return this.nextActionStrategy;
        }

        @NotNull
        public final List<MobileSegment.Wireframe> component1() {
            return this.mappedWireframes;
        }

        @NotNull
        public final TraversalStrategy component2() {
            return this.nextActionStrategy;
        }

        @NotNull
        public final TraversedTreeView copy(@NotNull List<? extends MobileSegment.Wireframe> mappedWireframes, @NotNull TraversalStrategy nextActionStrategy) {
            Intrinsics.checkNotNullParameter(mappedWireframes, (String)"mappedWireframes");
            Intrinsics.checkNotNullParameter((Object)((Object)nextActionStrategy), (String)"nextActionStrategy");
            return new TraversedTreeView(mappedWireframes, nextActionStrategy);
        }

        public static /* synthetic */ TraversedTreeView copy$default(TraversedTreeView traversedTreeView, List list, TraversalStrategy traversalStrategy, int n, Object object) {
            if ((n & 1) != 0) {
                list = traversedTreeView.mappedWireframes;
            }
            if ((n & 2) != 0) {
                traversalStrategy = traversedTreeView.nextActionStrategy;
            }
            return traversedTreeView.copy(list, traversalStrategy);
        }

        @NotNull
        public String toString() {
            return "TraversedTreeView(mappedWireframes=" + this.mappedWireframes + ", nextActionStrategy=" + this.nextActionStrategy + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.mappedWireframes).hashCode();
            result2 = result2 * 31 + this.nextActionStrategy.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TraversedTreeView)) {
                return false;
            }
            TraversedTreeView traversedTreeView = (TraversedTreeView)other;
            if (!Intrinsics.areEqual(this.mappedWireframes, traversedTreeView.mappedWireframes)) {
                return false;
            }
            return this.nextActionStrategy == traversedTreeView.nextActionStrategy;
        }
    }
}

