/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.view.View;
import android.view.ViewTreeObserver;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.internal.recorder.OnDrawListenerProducer;
import com.datadog.android.sessionreplay.internal.recorder.ViewOnDrawInterceptor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0010J\u0014\u0010\u0017\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\u0016\u0010\u0018\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\fH\u0002R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "touchPrivacyManager", "Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "onDrawListenerProducer", "Lcom/datadog/android/sessionreplay/internal/recorder/OnDrawListenerProducer;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;Lcom/datadog/android/sessionreplay/internal/recorder/OnDrawListenerProducer;)V", "decorOnDrawListeners", "Ljava/util/WeakHashMap;", "Landroid/view/View;", "Landroid/view/ViewTreeObserver$OnDrawListener;", "getDecorOnDrawListeners$dd_sdk_android_session_replay_release", "()Ljava/util/WeakHashMap;", "intercept", "", "decorViews", "", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "stopIntercepting", "stopInterceptingAndRemove", "stopInterceptingSafe", "decorView", "listener", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nViewOnDrawInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewOnDrawInterceptor.kt\ncom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1855#2,2:90\n1855#2,2:92\n1855#2,2:94\n*S KotlinDebug\n*F\n+ 1 ViewOnDrawInterceptor.kt\ncom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor\n*L\n33#1:90,2\n60#1:92,2\n67#1:94,2\n*E\n"})
public final class ViewOnDrawInterceptor {
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final TouchPrivacyManager touchPrivacyManager;
    @NotNull
    private final OnDrawListenerProducer onDrawListenerProducer;
    @NotNull
    private final WeakHashMap<View, ViewTreeObserver.OnDrawListener> decorOnDrawListeners;

    public ViewOnDrawInterceptor(@NotNull InternalLogger internalLogger, @NotNull TouchPrivacyManager touchPrivacyManager, @NotNull OnDrawListenerProducer onDrawListenerProducer) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        Intrinsics.checkNotNullParameter((Object)onDrawListenerProducer, (String)"onDrawListenerProducer");
        this.internalLogger = internalLogger;
        this.touchPrivacyManager = touchPrivacyManager;
        this.onDrawListenerProducer = onDrawListenerProducer;
        this.decorOnDrawListeners = new WeakHashMap();
    }

    @NotNull
    public final WeakHashMap<View, ViewTreeObserver.OnDrawListener> getDecorOnDrawListeners$dd_sdk_android_session_replay_release() {
        return this.decorOnDrawListeners;
    }

    public final void intercept(@NotNull List<? extends View> decorViews, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull ImagePrivacy imagePrivacy) {
        Intrinsics.checkNotNullParameter(decorViews, (String)"decorViews");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        this.stopInterceptingAndRemove(decorViews);
        ViewTreeObserver.OnDrawListener onDrawListener = this.onDrawListenerProducer.create(decorViews, textAndInputPrivacy, imagePrivacy, this.touchPrivacyManager);
        Iterable $this$forEach$iv = decorViews;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View decorView = (View)element$iv;
            boolean bl = false;
            ViewTreeObserver viewTreeObserver = decorView.getViewTreeObserver();
            if (viewTreeObserver == null || !viewTreeObserver.isAlive()) continue;
            try {
                viewTreeObserver.addOnDrawListener(onDrawListener);
                ((Map)this.decorOnDrawListeners).put(decorView, onDrawListener);
            }
            catch (IllegalStateException e) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)intercept.1.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            }
        }
        onDrawListener.onDraw();
    }

    public final void stopIntercepting(@NotNull List<? extends View> decorViews) {
        Intrinsics.checkNotNullParameter(decorViews, (String)"decorViews");
        this.stopInterceptingAndRemove(decorViews);
    }

    public final void stopIntercepting() {
        Set<Map.Entry<View, ViewTreeObserver.OnDrawListener>> set = this.decorOnDrawListeners.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"decorOnDrawListeners.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(decorView, listener)");
            View decorView = (View)entry.getKey();
            ViewTreeObserver.OnDrawListener listener = (ViewTreeObserver.OnDrawListener)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)decorView, (String)"decorView");
            Intrinsics.checkNotNullExpressionValue((Object)listener, (String)"listener");
            this.stopInterceptingSafe(decorView, listener);
        }
        this.decorOnDrawListeners.clear();
    }

    private final void stopInterceptingAndRemove(List<? extends View> decorViews) {
        Iterable $this$forEach$iv = decorViews;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewTreeObserver.OnDrawListener listener;
            View decorView = (View)element$iv;
            boolean bl = false;
            if (this.decorOnDrawListeners.remove(decorView) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)listener, (String)"listener");
            this.stopInterceptingSafe(decorView, listener);
        }
    }

    private final void stopInterceptingSafe(View decorView, ViewTreeObserver.OnDrawListener listener) {
        if (decorView.getViewTreeObserver().isAlive()) {
            try {
                decorView.getViewTreeObserver().removeOnDrawListener(listener);
            }
            catch (IllegalStateException e) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)stopInterceptingSafe.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            }
        }
    }
}

