/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.annotation.SuppressLint;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewStub;
import androidx.appcompat.widget.ActionBarContextView;
import androidx.appcompat.widget.Toolbar;
import com.datadog.android.internal.utils.IntExtKt;
import com.datadog.android.sessionreplay.internal.recorder.ViewUtilsInternal;
import com.datadog.android.sessionreplay.internal.recorder.resources.DefaultImageWireframeHelper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0019J-\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"J%\u0010#\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b$R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/ViewUtilsInternal;", "", "()V", "systemViewIds", "", "", "getSystemViewIds", "()Ljava/util/Set;", "systemViewIds$delegate", "Lkotlin/Lazy;", "getCenterHorizontalOffset", "", "viewWidth", "drawableWidth", "getCenterVerticalOffset", "viewHeight", "drawableHeight", "isNotVisible", "", "view", "Landroid/view/View;", "isNotVisible$dd_sdk_android_session_replay_release", "isSystemNoise", "isSystemNoise$dd_sdk_android_session_replay_release", "isToolbar", "isToolbar$dd_sdk_android_session_replay_release", "resolveCompoundDrawableBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "drawable", "Landroid/graphics/drawable/Drawable;", "pixelsDensity", "", "position", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper$CompoundDrawablePositions;", "resolveCompoundDrawableBounds$dd_sdk_android_session_replay_release", "resolveDrawableBounds", "resolveDrawableBounds$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
public final class ViewUtilsInternal {
    @NotNull
    private final Lazy systemViewIds$delegate = LazyKt.lazy((Function0)systemViewIds.2.INSTANCE);

    private final Set<Integer> getSystemViewIds() {
        Lazy lazy = this.systemViewIds$delegate;
        return (Set)lazy.getValue();
    }

    public final boolean isNotVisible$dd_sdk_android_session_replay_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return !view.isShown() || view.getWidth() <= 0 || view.getHeight() <= 0;
    }

    @SuppressLint(value={"RestrictedApi"})
    public final boolean isSystemNoise$dd_sdk_android_session_replay_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return this.getSystemViewIds().contains(view.getId()) || view instanceof ViewStub || view instanceof ActionBarContextView;
    }

    public final boolean isToolbar$dd_sdk_android_session_replay_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return Toolbar.class.isAssignableFrom(view.getClass()) || android.widget.Toolbar.class.isAssignableFrom(view.getClass());
    }

    @NotNull
    public final GlobalBounds resolveDrawableBounds$dd_sdk_android_session_replay_release(@NotNull View view, @NotNull Drawable drawable, float pixelsDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int[] coordinates = new int[2];
        view.getLocationOnScreen(coordinates);
        long x = IntExtKt.densityNormalized((int)coordinates[0], (float)pixelsDensity);
        long y = IntExtKt.densityNormalized((int)coordinates[1], (float)pixelsDensity);
        long width = IntExtKt.densityNormalized((int)drawable.getIntrinsicWidth(), (float)pixelsDensity);
        long height = IntExtKt.densityNormalized((int)drawable.getIntrinsicHeight(), (float)pixelsDensity);
        return new GlobalBounds(x, y, width, height);
    }

    @NotNull
    public final GlobalBounds resolveCompoundDrawableBounds$dd_sdk_android_session_replay_release(@NotNull View view, @NotNull Drawable drawable, float pixelsDensity, @NotNull DefaultImageWireframeHelper.CompoundDrawablePositions position) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        int[] coordinates = new int[2];
        view.getLocationOnScreen(coordinates);
        long viewXPosition = IntExtKt.densityNormalized((int)coordinates[0], (float)pixelsDensity);
        long viewYPosition = IntExtKt.densityNormalized((int)coordinates[1], (float)pixelsDensity);
        long drawableWidth = IntExtKt.densityNormalized((int)drawable.getIntrinsicWidth(), (float)pixelsDensity);
        long drawableHeight = IntExtKt.densityNormalized((int)drawable.getIntrinsicHeight(), (float)pixelsDensity);
        long viewWidth = IntExtKt.densityNormalized((int)view.getWidth(), (float)pixelsDensity);
        long viewHeight = IntExtKt.densityNormalized((int)view.getHeight(), (float)pixelsDensity);
        long viewPaddingStart = IntExtKt.densityNormalized((int)view.getPaddingStart(), (float)pixelsDensity);
        long viewPaddingTop = IntExtKt.densityNormalized((int)view.getPaddingTop(), (float)pixelsDensity);
        long viewPaddingBottom = IntExtKt.densityNormalized((int)view.getPaddingBottom(), (float)pixelsDensity);
        long viewPaddingEnd = IntExtKt.densityNormalized((int)view.getPaddingEnd(), (float)pixelsDensity);
        long xPosition = 0L;
        long yPosition = 0L;
        switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                xPosition = viewPaddingStart;
                yPosition = this.getCenterVerticalOffset(viewHeight, drawableHeight);
                break;
            }
            case 2: {
                xPosition = this.getCenterHorizontalOffset(viewWidth, drawableWidth);
                yPosition = viewPaddingTop;
                break;
            }
            case 3: {
                xPosition = viewWidth - (drawableWidth + viewPaddingEnd);
                yPosition = this.getCenterVerticalOffset(viewHeight, drawableHeight);
                break;
            }
            case 4: {
                xPosition = this.getCenterHorizontalOffset(viewWidth, drawableWidth);
                yPosition = viewHeight - (drawableHeight + viewPaddingBottom);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new GlobalBounds(xPosition += viewXPosition, yPosition += viewYPosition, drawableWidth, drawableHeight);
    }

    private final long getCenterHorizontalOffset(long viewWidth, long drawableWidth) {
        return viewWidth / (long)2 - drawableWidth / (long)2;
    }

    private final long getCenterVerticalOffset(long viewHeight, long drawableHeight) {
        return viewHeight / (long)2 - drawableHeight / (long)2;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DefaultImageWireframeHelper.CompoundDrawablePositions.values().length];
            try {
                nArray[DefaultImageWireframeHelper.CompoundDrawablePositions.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultImageWireframeHelper.CompoundDrawablePositions.TOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultImageWireframeHelper.CompoundDrawablePositions.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DefaultImageWireframeHelper.CompoundDrawablePositions.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

