/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder;

import android.content.Context;
import android.view.Window;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.internal.async.RecordedDataQueueHandler;
import com.datadog.android.sessionreplay.internal.recorder.ViewOnDrawInterceptor;
import com.datadog.android.sessionreplay.internal.recorder.callback.NoOpWindowCallback;
import com.datadog.android.sessionreplay.internal.recorder.callback.RecorderWindowCallback;
import com.datadog.android.sessionreplay.internal.utils.TimeProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0015J\u0014\u0010\u001a\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/WindowCallbackInterceptor;", "", "recordedDataQueueHandler", "Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler;", "viewOnDrawInterceptor", "Lcom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor;", "timeProvider", "Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "touchPrivacyManager", "Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "(Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler;Lcom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor;Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/ImagePrivacy;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;)V", "wrappedWindows", "Ljava/util/WeakHashMap;", "Landroid/view/Window;", "intercept", "", "windows", "", "appContext", "Landroid/content/Context;", "stopIntercepting", "unwrapWindowCallback", "window", "wrapWindowCallback", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nWindowCallbackInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowCallbackInterceptor.kt\ncom/datadog/android/sessionreplay/internal/recorder/WindowCallbackInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1855#2,2:81\n1855#2,2:83\n1855#2,2:85\n*S KotlinDebug\n*F\n+ 1 WindowCallbackInterceptor.kt\ncom/datadog/android/sessionreplay/internal/recorder/WindowCallbackInterceptor\n*L\n33#1:81,2\n40#1:83,2\n47#1:85,2\n*E\n"})
public final class WindowCallbackInterceptor {
    @NotNull
    private final RecordedDataQueueHandler recordedDataQueueHandler;
    @NotNull
    private final ViewOnDrawInterceptor viewOnDrawInterceptor;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final ImagePrivacy imagePrivacy;
    @NotNull
    private final TextAndInputPrivacy textAndInputPrivacy;
    @NotNull
    private final TouchPrivacyManager touchPrivacyManager;
    @NotNull
    private final WeakHashMap<Window, Object> wrappedWindows;

    public WindowCallbackInterceptor(@NotNull RecordedDataQueueHandler recordedDataQueueHandler, @NotNull ViewOnDrawInterceptor viewOnDrawInterceptor, @NotNull TimeProvider timeProvider, @NotNull InternalLogger internalLogger, @NotNull ImagePrivacy imagePrivacy, @NotNull TextAndInputPrivacy textAndInputPrivacy, @NotNull TouchPrivacyManager touchPrivacyManager) {
        Intrinsics.checkNotNullParameter((Object)recordedDataQueueHandler, (String)"recordedDataQueueHandler");
        Intrinsics.checkNotNullParameter((Object)viewOnDrawInterceptor, (String)"viewOnDrawInterceptor");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        this.recordedDataQueueHandler = recordedDataQueueHandler;
        this.viewOnDrawInterceptor = viewOnDrawInterceptor;
        this.timeProvider = timeProvider;
        this.internalLogger = internalLogger;
        this.imagePrivacy = imagePrivacy;
        this.textAndInputPrivacy = textAndInputPrivacy;
        this.touchPrivacyManager = touchPrivacyManager;
        this.wrappedWindows = new WeakHashMap();
    }

    public final void intercept(@NotNull List<? extends Window> windows, @NotNull Context appContext) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Iterable $this$forEach$iv = windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window window = (Window)element$iv;
            boolean bl = false;
            this.wrapWindowCallback(window, appContext);
            ((Map)this.wrappedWindows).put(window, null);
        }
    }

    public final void stopIntercepting(@NotNull List<? extends Window> windows) {
        Intrinsics.checkNotNullParameter(windows, (String)"windows");
        Iterable $this$forEach$iv = windows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window it = (Window)element$iv;
            boolean bl = false;
            this.unwrapWindowCallback(it);
            this.wrappedWindows.remove(it);
        }
    }

    public final void stopIntercepting() {
        Set<Map.Entry<Window, Object>> set = this.wrappedWindows.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"wrappedWindows.entries");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            this.unwrapWindowCallback((Window)k);
        }
        this.wrappedWindows.clear();
    }

    private final void wrapWindowCallback(Window window, Context appContext) {
        Window.Callback callback = window.getCallback();
        if (callback == null) {
            callback = new NoOpWindowCallback();
        }
        Window.Callback toWrap = callback;
        window.setCallback((Window.Callback)new RecorderWindowCallback(appContext, this.recordedDataQueueHandler, toWrap, this.timeProvider, this.viewOnDrawInterceptor, this.internalLogger, this.textAndInputPrivacy, this.imagePrivacy, this.touchPrivacyManager, null, null, 0L, 0L, null, 15872, null));
    }

    private final void unwrapWindowCallback(Window window) {
        Window.Callback callback = window.getCallback();
        if (callback instanceof RecorderWindowCallback) {
            Window.Callback wrappedCallback = ((RecorderWindowCallback)callback).getWrappedCallback$dd_sdk_android_session_replay_release();
            if (!(wrappedCallback instanceof NoOpWindowCallback)) {
                window.setCallback(wrappedCallback);
            } else {
                window.setCallback(null);
            }
        }
    }
}

