/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.callback;

import android.app.Activity;
import android.app.Dialog;
import android.view.Window;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.datadog.android.sessionreplay.internal.recorder.callback.OnWindowRefreshedCallback;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/callback/RecorderFragmentLifecycleCallback;", "Landroidx/fragment/app/FragmentManager$FragmentLifecycleCallbacks;", "onWindowRefreshedCallback", "Lcom/datadog/android/sessionreplay/internal/recorder/callback/OnWindowRefreshedCallback;", "(Lcom/datadog/android/sessionreplay/internal/recorder/callback/OnWindowRefreshedCallback;)V", "getWindowsToRecord", "", "Landroid/view/Window;", "f", "Landroidx/fragment/app/Fragment;", "onFragmentPaused", "", "fm", "Landroidx/fragment/app/FragmentManager;", "onFragmentResumed", "Landroidx/fragment/app/DialogFragment;", "dd-sdk-android-session-replay_release"})
public final class RecorderFragmentLifecycleCallback
extends FragmentManager.FragmentLifecycleCallbacks {
    @NotNull
    private final OnWindowRefreshedCallback onWindowRefreshedCallback;

    public RecorderFragmentLifecycleCallback(@NotNull OnWindowRefreshedCallback onWindowRefreshedCallback) {
        Intrinsics.checkNotNullParameter((Object)onWindowRefreshedCallback, (String)"onWindowRefreshedCallback");
        this.onWindowRefreshedCallback = onWindowRefreshedCallback;
    }

    public void onFragmentResumed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
            Intrinsics.checkNotNullParameter((Object)f, (String)"f");
            super.onFragmentResumed(fm, f);
            List<Window> list = this.getWindowsToRecord(f);
            if (list == null) break block0;
            List<Window> it = list;
            boolean bl = false;
            this.onWindowRefreshedCallback.onWindowsAdded(it);
        }
    }

    public void onFragmentPaused(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        List<Window> list = this.getWindowsToRecord(f);
        if (list != null) {
            List<Window> it = list;
            boolean bl = false;
            this.onWindowRefreshedCallback.onWindowsRemoved(it);
        }
        super.onFragmentPaused(fm, f);
    }

    private final List<Window> getWindowsToRecord(Fragment f) {
        if (f instanceof DialogFragment && ((DialogFragment)f).getContext() != null) {
            return this.getWindowsToRecord((DialogFragment)f);
        }
        return null;
    }

    private final List<Window> getWindowsToRecord(DialogFragment $this$getWindowsToRecord) {
        Window ownerActivityWindow;
        Activity dialogOwnerActivity;
        Dialog dialog = $this$getWindowsToRecord.getDialog();
        Window dialogWindow = dialog != null ? dialog.getWindow() : null;
        Dialog dialog2 = $this$getWindowsToRecord.getDialog();
        Activity activity = dialogOwnerActivity = dialog2 != null ? dialog2.getOwnerActivity() : null;
        Object object = ownerActivityWindow = activity != null ? activity.getWindow() : null;
        if (dialogWindow == null || dialogOwnerActivity == null || ownerActivityWindow == null) {
            return null;
        }
        return !Intrinsics.areEqual((Object)dialogWindow, (Object)ownerActivityWindow) ? CollectionsKt.listOf((Object)dialogWindow) : null;
    }
}

