/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.callback;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.graphics.Point;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.MainThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.TouchPrivacyManager;
import com.datadog.android.sessionreplay.internal.async.RecordedDataQueueHandler;
import com.datadog.android.sessionreplay.internal.async.TouchEventRecordedDataQueueItem;
import com.datadog.android.sessionreplay.internal.recorder.ViewOnDrawInterceptor;
import com.datadog.android.sessionreplay.internal.recorder.WindowInspector;
import com.datadog.android.sessionreplay.internal.recorder.callback.MotionEventUtils;
import com.datadog.android.sessionreplay.internal.recorder.callback.RecorderWindowCallback;
import com.datadog.android.sessionreplay.internal.utils.TimeProvider;
import com.datadog.android.sessionreplay.model.MobileSegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \\2\u00020\u0001:\u0001\\B\u008b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0014\b\u0002\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010-\u001a\u00020*2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010\u00150\u0015H\u0096\u0001J\u0019\u00100\u001a\u00020*2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010101H\u0096\u0001J\u0019\u00102\u001a\u00020*2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010101H\u0096\u0001J\u0019\u00103\u001a\u00020*2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010404H\u0096\u0001J\u0012\u00105\u001a\u00020*2\b\u00106\u001a\u0004\u0018\u00010\u0015H\u0017J\u0019\u00107\u001a\u00020*2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010\u00150\u0015H\u0096\u0001J\b\u00108\u001a\u000209H\u0003J\u0010\u0010:\u001a\u0002092\u0006\u00106\u001a\u00020\u0015H\u0003J\u0014\u0010;\u001a\u0002092\n\u0010<\u001a\u00060=j\u0002`>H\u0002J\u0019\u0010?\u001a\u0002092\u000e\u0010.\u001a\n /*\u0004\u0018\u00010@0@H\u0096\u0001J\u0019\u0010A\u001a\u0002092\u000e\u0010.\u001a\n /*\u0004\u0018\u00010@0@H\u0096\u0001J\t\u0010B\u001a\u000209H\u0096\u0001J\t\u0010C\u001a\u000209H\u0096\u0001J\u001b\u0010D\u001a\u00020*2\u0006\u0010.\u001a\u00020E2\b\b\u0001\u0010F\u001a\u00020GH\u0096\u0001J\u0013\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010.\u001a\u00020EH\u0097\u0001J\t\u0010J\u001a\u000209H\u0096\u0001J\u001b\u0010K\u001a\u00020*2\u0006\u0010.\u001a\u00020E2\b\b\u0001\u0010F\u001a\u00020LH\u0096\u0001J\u001b\u0010M\u001a\u00020*2\u0006\u0010.\u001a\u00020E2\b\b\u0001\u0010F\u001a\u00020GH\u0096\u0001J\u001b\u0010N\u001a\u0002092\u0006\u0010.\u001a\u00020E2\b\b\u0001\u0010F\u001a\u00020GH\u0096\u0001J'\u0010O\u001a\u00020*2\u0006\u0010.\u001a\u00020E2\n\b\u0001\u0010F\u001a\u0004\u0018\u00010I2\b\b\u0001\u0010P\u001a\u00020GH\u0096\u0001J\t\u0010Q\u001a\u00020*H\u0096\u0001J\u0019\u0010Q\u001a\u00020*2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010R0RH\u0096\u0001J\u0019\u0010S\u001a\u0002092\u000e\u0010.\u001a\n /*\u0004\u0018\u00010T0TH\u0096\u0001J\u0010\u0010U\u001a\u0002092\u0006\u0010V\u001a\u00020*H\u0016J\u001b\u0010W\u001a\u0004\u0018\u00010@2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010X0XH\u0097\u0001J#\u0010W\u001a\u0004\u0018\u00010@2\u000e\u0010.\u001a\n /*\u0004\u0018\u00010X0X2\u0006\u0010F\u001a\u00020EH\u0097\u0001J\u0018\u0010Y\u001a\u0002092\u0006\u00106\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020[H\u0002R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006]"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/callback/RecorderWindowCallback;", "Landroid/view/Window$Callback;", "appContext", "Landroid/content/Context;", "recordedDataQueueHandler", "Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler;", "wrappedCallback", "timeProvider", "Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;", "viewOnDrawInterceptor", "Lcom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "privacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "touchPrivacyManager", "Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;", "copyEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "motionEventUtils", "Lcom/datadog/android/sessionreplay/internal/recorder/callback/MotionEventUtils;", "motionUpdateThresholdInNs", "", "flushPositionBufferThresholdInNs", "windowInspector", "Lcom/datadog/android/sessionreplay/internal/recorder/WindowInspector;", "(Landroid/content/Context;Lcom/datadog/android/sessionreplay/internal/async/RecordedDataQueueHandler;Landroid/view/Window$Callback;Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;Lcom/datadog/android/sessionreplay/internal/recorder/ViewOnDrawInterceptor;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Lcom/datadog/android/sessionreplay/ImagePrivacy;Lcom/datadog/android/sessionreplay/internal/TouchPrivacyManager;Lkotlin/jvm/functions/Function1;Lcom/datadog/android/sessionreplay/internal/recorder/callback/MotionEventUtils;JJLcom/datadog/android/sessionreplay/internal/recorder/WindowInspector;)V", "lastOnMoveUpdateTimeInNs", "lastPerformedFlushTimeInNs", "pixelsDensity", "", "pointerInteractions", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$MobileRecord;", "getPointerInteractions$dd_sdk_android_session_replay_release", "()Ljava/util/List;", "setPointerInteractions$dd_sdk_android_session_replay_release", "(Ljava/util/List;)V", "shouldRecordMotion", "", "getWrappedCallback$dd_sdk_android_session_replay_release", "()Landroid/view/Window$Callback;", "dispatchGenericMotionEvent", "p0", "kotlin.jvm.PlatformType", "dispatchKeyEvent", "Landroid/view/KeyEvent;", "dispatchKeyShortcutEvent", "dispatchPopulateAccessibilityEvent", "Landroid/view/accessibility/AccessibilityEvent;", "dispatchTouchEvent", "event", "dispatchTrackballEvent", "flushPositions", "", "handleEvent", "logOrRethrowWrappedCallbackException", "e", "Ljava/lang/NullPointerException;", "Lkotlin/NullPointerException;", "onActionModeFinished", "Landroid/view/ActionMode;", "onActionModeStarted", "onAttachedToWindow", "onContentChanged", "onCreatePanelMenu", "", "p1", "Landroid/view/Menu;", "onCreatePanelView", "Landroid/view/View;", "onDetachedFromWindow", "onMenuItemSelected", "Landroid/view/MenuItem;", "onMenuOpened", "onPanelClosed", "onPreparePanel", "p2", "onSearchRequested", "Landroid/view/SearchEvent;", "onWindowAttributesChanged", "Landroid/view/WindowManager$LayoutParams;", "onWindowFocusChanged", "hasFocus", "onWindowStartingActionMode", "Landroid/view/ActionMode$Callback;", "updatePositions", "eventType", "Lcom/datadog/android/sessionreplay/model/MobileSegment$PointerEventType;", "Companion", "dd-sdk-android-session-replay_release"})
public final class RecorderWindowCallback
implements Window.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RecordedDataQueueHandler recordedDataQueueHandler;
    @NotNull
    private final Window.Callback wrappedCallback;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final ViewOnDrawInterceptor viewOnDrawInterceptor;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final TextAndInputPrivacy privacy;
    @NotNull
    private final ImagePrivacy imagePrivacy;
    @NotNull
    private final TouchPrivacyManager touchPrivacyManager;
    @NotNull
    private final Function1<MotionEvent, MotionEvent> copyEvent;
    @NotNull
    private final MotionEventUtils motionEventUtils;
    private final long motionUpdateThresholdInNs;
    private final long flushPositionBufferThresholdInNs;
    @NotNull
    private final WindowInspector windowInspector;
    private final float pixelsDensity;
    @NotNull
    private List<MobileSegment.MobileRecord> pointerInteractions;
    private long lastOnMoveUpdateTimeInNs;
    private long lastPerformedFlushTimeInNs;
    private boolean shouldRecordMotion;
    private static final boolean EVENT_CONSUMED = true;
    private static final long MOTION_UPDATE_DELAY_THRESHOLD_NS = TimeUnit.MILLISECONDS.toNanos(16L);
    private static final long FLUSH_BUFFER_THRESHOLD_NS = MOTION_UPDATE_DELAY_THRESHOLD_NS * (long)10;
    @NotNull
    public static final String MOTION_EVENT_WAS_NULL_ERROR_MESSAGE = "RecorderWindowCallback: intercepted null motion event";
    @NotNull
    public static final String FAIL_TO_PROCESS_MOTION_EVENT_ERROR_MESSAGE = "RecorderWindowCallback: wrapped callback failed to handle the motion event";

    public RecorderWindowCallback(@NotNull Context appContext, @NotNull RecordedDataQueueHandler recordedDataQueueHandler, @NotNull Window.Callback wrappedCallback, @NotNull TimeProvider timeProvider, @NotNull ViewOnDrawInterceptor viewOnDrawInterceptor, @NotNull InternalLogger internalLogger, @NotNull TextAndInputPrivacy privacy, @NotNull ImagePrivacy imagePrivacy, @NotNull TouchPrivacyManager touchPrivacyManager, @NotNull Function1<? super MotionEvent, MotionEvent> copyEvent, @NotNull MotionEventUtils motionEventUtils, long motionUpdateThresholdInNs, long flushPositionBufferThresholdInNs, @NotNull WindowInspector windowInspector) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)recordedDataQueueHandler, (String)"recordedDataQueueHandler");
        Intrinsics.checkNotNullParameter((Object)wrappedCallback, (String)"wrappedCallback");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)viewOnDrawInterceptor, (String)"viewOnDrawInterceptor");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)privacy, (String)"privacy");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)touchPrivacyManager, (String)"touchPrivacyManager");
        Intrinsics.checkNotNullParameter(copyEvent, (String)"copyEvent");
        Intrinsics.checkNotNullParameter((Object)motionEventUtils, (String)"motionEventUtils");
        Intrinsics.checkNotNullParameter((Object)windowInspector, (String)"windowInspector");
        this.recordedDataQueueHandler = recordedDataQueueHandler;
        this.wrappedCallback = wrappedCallback;
        this.timeProvider = timeProvider;
        this.viewOnDrawInterceptor = viewOnDrawInterceptor;
        this.internalLogger = internalLogger;
        this.privacy = privacy;
        this.imagePrivacy = imagePrivacy;
        this.touchPrivacyManager = touchPrivacyManager;
        this.copyEvent = copyEvent;
        this.motionEventUtils = motionEventUtils;
        this.motionUpdateThresholdInNs = motionUpdateThresholdInNs;
        this.flushPositionBufferThresholdInNs = flushPositionBufferThresholdInNs;
        this.windowInspector = windowInspector;
        this.pixelsDensity = appContext.getResources().getDisplayMetrics().density;
        this.pointerInteractions = new LinkedList();
        this.lastPerformedFlushTimeInNs = System.nanoTime();
    }

    public /* synthetic */ RecorderWindowCallback(Context context, RecordedDataQueueHandler recordedDataQueueHandler, Window.Callback callback, TimeProvider timeProvider, ViewOnDrawInterceptor viewOnDrawInterceptor, InternalLogger internalLogger, TextAndInputPrivacy textAndInputPrivacy, ImagePrivacy imagePrivacy, TouchPrivacyManager touchPrivacyManager, Function1 function1, MotionEventUtils motionEventUtils, long l, long l2, WindowInspector windowInspector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x400) != 0) {
            motionEventUtils = MotionEventUtils.INSTANCE;
        }
        if ((n & 0x800) != 0) {
            l = MOTION_UPDATE_DELAY_THRESHOLD_NS;
        }
        if ((n & 0x1000) != 0) {
            l2 = FLUSH_BUFFER_THRESHOLD_NS;
        }
        if ((n & 0x2000) != 0) {
            windowInspector = WindowInspector.INSTANCE;
        }
        this(context, recordedDataQueueHandler, callback, timeProvider, viewOnDrawInterceptor, internalLogger, textAndInputPrivacy, imagePrivacy, touchPrivacyManager, (Function1<? super MotionEvent, MotionEvent>)function1, motionEventUtils, l, l2, windowInspector);
    }

    @NotNull
    public final Window.Callback getWrappedCallback$dd_sdk_android_session_replay_release() {
        return this.wrappedCallback;
    }

    public boolean dispatchGenericMotionEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchGenericMotionEvent(p0);
    }

    public boolean dispatchKeyEvent(KeyEvent p0) {
        return this.wrappedCallback.dispatchKeyEvent(p0);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent p0) {
        return this.wrappedCallback.dispatchKeyShortcutEvent(p0);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent p0) {
        return this.wrappedCallback.dispatchPopulateAccessibilityEvent(p0);
    }

    public boolean dispatchTrackballEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchTrackballEvent(p0);
    }

    public void onActionModeFinished(ActionMode p0) {
        this.wrappedCallback.onActionModeFinished(p0);
    }

    public void onActionModeStarted(ActionMode p0) {
        this.wrappedCallback.onActionModeStarted(p0);
    }

    public void onAttachedToWindow() {
        this.wrappedCallback.onAttachedToWindow();
    }

    public void onContentChanged() {
        this.wrappedCallback.onContentChanged();
    }

    public boolean onCreatePanelMenu(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onCreatePanelMenu(p0, p1);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public View onCreatePanelView(int p0) {
        return this.wrappedCallback.onCreatePanelView(p0);
    }

    public void onDetachedFromWindow() {
        this.wrappedCallback.onDetachedFromWindow();
    }

    public boolean onMenuItemSelected(int p0, @NonNull @NotNull MenuItem p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onMenuItemSelected(p0, p1);
    }

    public boolean onMenuOpened(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onMenuOpened(p0, p1);
    }

    public void onPanelClosed(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.wrappedCallback.onPanelClosed(p0, p1);
    }

    public boolean onPreparePanel(int p0, @Nullable @org.jetbrains.annotations.Nullable View p1, @NonNull @NotNull Menu p2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return this.wrappedCallback.onPreparePanel(p0, p1, p2);
    }

    public boolean onSearchRequested() {
        return this.wrappedCallback.onSearchRequested();
    }

    public boolean onSearchRequested(SearchEvent p0) {
        return this.wrappedCallback.onSearchRequested(p0);
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams p0) {
        this.wrappedCallback.onWindowAttributesChanged(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0) {
        return this.wrappedCallback.onWindowStartingActionMode(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0, int p1) {
        return this.wrappedCallback.onWindowStartingActionMode(p0, p1);
    }

    @NotNull
    public final List<MobileSegment.MobileRecord> getPointerInteractions$dd_sdk_android_session_replay_release() {
        return this.pointerInteractions;
    }

    public final void setPointerInteractions$dd_sdk_android_session_replay_release(@NotNull List<MobileSegment.MobileRecord> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.pointerInteractions = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public boolean dispatchTouchEvent(@org.jetbrains.annotations.Nullable MotionEvent event) {
        boolean bl;
        if (event != null) {
            if (event.getAction() == 0) {
                Point touchLocation = new Point((int)event.getX(), (int)event.getY());
                this.shouldRecordMotion = this.touchPrivacyManager.shouldRecordTouch$dd_sdk_android_session_replay_release(touchLocation);
            }
            if (this.shouldRecordMotion) {
                MotionEvent copy = (MotionEvent)this.copyEvent.invoke((Object)event);
                try {
                    this.handleEvent(copy);
                }
                finally {
                    copy.recycle();
                }
            }
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)dispatchTouchEvent.1.INSTANCE, null, (boolean)false, null, (int)48, null);
        }
        try {
            bl = this.wrappedCallback.dispatchTouchEvent(event);
        }
        catch (NullPointerException e) {
            this.logOrRethrowWrappedCallbackException(e);
            bl = true;
        }
        return bl;
    }

    @MainThread
    private final void handleEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.lastPerformedFlushTimeInNs = System.nanoTime();
                this.updatePositions(event, MobileSegment.PointerEventType.DOWN);
                this.lastOnMoveUpdateTimeInNs = 0L;
                break;
            }
            case 2: {
                if (System.nanoTime() - this.lastOnMoveUpdateTimeInNs >= this.motionUpdateThresholdInNs) {
                    this.updatePositions(event, MobileSegment.PointerEventType.MOVE);
                    this.lastOnMoveUpdateTimeInNs = System.nanoTime();
                }
                if (System.nanoTime() - this.lastPerformedFlushTimeInNs < this.flushPositionBufferThresholdInNs) break;
                this.flushPositions();
                break;
            }
            case 1: {
                this.updatePositions(event, MobileSegment.PointerEventType.UP);
                this.flushPositions();
                this.lastOnMoveUpdateTimeInNs = 0L;
            }
        }
    }

    private final void updatePositions(MotionEvent event, MobileSegment.PointerEventType eventType) {
        int n = event.getPointerCount();
        for (int pointerIndex = 0; pointerIndex < n; ++pointerIndex) {
            long pointerId = event.getPointerId(pointerIndex);
            float pointerAbsoluteX = this.motionEventUtils.getPointerAbsoluteX(event, pointerIndex);
            float pointerAbsoluteY = this.motionEventUtils.getPointerAbsoluteY(event, pointerIndex);
            this.pointerInteractions.add(new MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord(this.timeProvider.getDeviceTimestamp(), new MobileSegment.MobileIncrementalData.PointerInteractionData(eventType, MobileSegment.PointerType.TOUCH, pointerId, LongExtKt.densityNormalized((long)((long)pointerAbsoluteX), (float)this.pixelsDensity), LongExtKt.densityNormalized((long)((long)pointerAbsoluteY), (float)this.pixelsDensity))));
        }
    }

    @MainThread
    private final void flushPositions() {
        if (this.pointerInteractions.isEmpty()) {
            return;
        }
        TouchEventRecordedDataQueueItem touchEventRecordedDataQueueItem = this.recordedDataQueueHandler.addTouchEventItem(new ArrayList(this.pointerInteractions));
        if (touchEventRecordedDataQueueItem == null) {
            return;
        }
        TouchEventRecordedDataQueueItem item = touchEventRecordedDataQueueItem;
        if (item.isReady$dd_sdk_android_session_replay_release()) {
            this.recordedDataQueueHandler.tryToConsumeItems();
        }
        this.pointerInteractions.clear();
        this.lastPerformedFlushTimeInNs = System.nanoTime();
    }

    private final void logOrRethrowWrappedCallbackException(NullPointerException e) {
        String string = e.getMessage();
        if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Parameter specified as non-null is null", (boolean)false, (int)2, null) : false)) {
            throw e;
        }
        InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)logOrRethrowWrappedCallbackException.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        List<View> rootViews = this.windowInspector.getGlobalWindowViews(this.internalLogger);
        if (!((Collection)rootViews).isEmpty()) {
            this.viewOnDrawInterceptor.stopIntercepting();
            this.viewOnDrawInterceptor.intercept(rootViews, this.privacy, this.imagePrivacy);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/callback/RecorderWindowCallback$Companion;", "", "()V", "EVENT_CONSUMED", "", "FAIL_TO_PROCESS_MOTION_EVENT_ERROR_MESSAGE", "", "FLUSH_BUFFER_THRESHOLD_NS", "", "getFLUSH_BUFFER_THRESHOLD_NS$dd_sdk_android_session_replay_release", "()J", "MOTION_EVENT_WAS_NULL_ERROR_MESSAGE", "MOTION_UPDATE_DELAY_THRESHOLD_NS", "getMOTION_UPDATE_DELAY_THRESHOLD_NS$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getMOTION_UPDATE_DELAY_THRESHOLD_NS$dd_sdk_android_session_replay_release() {
            return MOTION_UPDATE_DELAY_THRESHOLD_NS;
        }

        public final long getFLUSH_BUFFER_THRESHOLD_NS$dd_sdk_android_session_replay_release() {
            return FLUSH_BUFFER_THRESHOLD_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

