/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.UiThread;
import androidx.appcompat.widget.ActionBarContainer;
import androidx.appcompat.widget.DatadogActionBarContainerAccessor;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.BaseViewGroupMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/ActionBarContainerMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseViewGroupMapper;", "Landroidx/appcompat/widget/ActionBarContainer;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "map", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nActionBarContainerMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionBarContainerMapper.kt\ncom/datadog/android/sessionreplay/internal/recorder/mapper/ActionBarContainerMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class ActionBarContainerMapper
extends BaseViewGroupMapper<ActionBarContainer> {
    public ActionBarContainerMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull ActionBarContainer view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        MobileSegment.ShapeStyle shapeStyle;
        Drawable background;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Drawable drawable = background = new DatadogActionBarContainerAccessor(view).getBackgroundDrawable();
        if (drawable != null) {
            Drawable it = drawable;
            boolean bl = false;
            shapeStyle = this.resolveShapeStyle(it, view.getAlpha(), internalLogger);
        } else {
            shapeStyle = null;
        }
        MobileSegment.ShapeStyle shapeStyle2 = shapeStyle;
        Long id2 = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, "backgroundDrawable");
        if (shapeStyle2 != null && id2 != null) {
            float density = mappingContext.getSystemInformation().getScreenDensity();
            GlobalBounds bounds = this.getViewBoundsResolver().resolveViewGlobalBounds((View)view, density);
            return CollectionsKt.listOf((Object)new MobileSegment.Wireframe.ShapeWireframe(id2, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), null, shapeStyle2, null, 32, null));
        }
        return CollectionsKt.emptyList();
    }
}

