/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.widget.NumberPicker;
import androidx.annotation.RequiresApi;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.mapper.BaseWireframeMapper;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b!\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004JH\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0015H\u0004J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000fH\u0004J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0002H\u0004J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0004\u00a8\u0006)"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/BasePickerMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseWireframeMapper;", "Landroid/widget/NumberPicker;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "provideDividerWireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$ShapeWireframe;", "id", "", "x", "y", "width", "height", "color", "", "provideLabelWireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$TextWireframe;", "labelValue", "textSize", "textColor", "resolveDividerHeight", "screenDensity", "", "resolveDividerPaddingEnd", "view", "resolveDividerPaddingStart", "resolvePadding", "resolveSelectedLabelYPos", "viewGlobalBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "labelHeight", "resolveSelectedTextColor", "resolveTextSize", "Companion", "dd-sdk-android-session-replay_release"})
@RequiresApi(value=29)
public abstract class BasePickerMapper
extends BaseWireframeMapper<NumberPicker> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREV_INDEX_KEY_NAME = "numeric_picker_prev_index";
    @NotNull
    public static final String SELECTED_INDEX_KEY_NAME = "numeric_picker_selected_index";
    @NotNull
    public static final String NEXT_INDEX_KEY_NAME = "numeric_picker_next_index";
    @NotNull
    public static final String DIVIDER_TOP_KEY_NAME = "numeric_picker_divider_top";
    @NotNull
    public static final String DIVIDER_BOTTOM_KEY_NAME = "numeric_picker_divider_bottom";
    public static final long DIVIDER_HEIGHT_IN_PX = 6L;
    public static final long PADDING_IN_PX = 10L;
    @NotNull
    public static final String FONT_FAMILY = "Roboto, sans-serif";

    public BasePickerMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
    }

    protected final long resolveTextSize(@NotNull NumberPicker view, float screenDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return LongExtKt.densityNormalized((long)((long)view.getTextSize()), (float)screenDensity);
    }

    protected final long resolvePadding(float screenDensity) {
        return LongExtKt.densityNormalized((long)10L, (float)screenDensity);
    }

    protected final long resolveDividerPaddingStart(@NotNull NumberPicker view, float screenDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return LongExtKt.densityNormalized((long)view.getPaddingStart(), (float)screenDensity);
    }

    protected final long resolveDividerPaddingEnd(@NotNull NumberPicker view, float screenDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return LongExtKt.densityNormalized((long)view.getPaddingEnd(), (float)screenDensity);
    }

    protected final long resolveDividerHeight(float screenDensity) {
        return LongExtKt.densityNormalized((long)6L, (float)screenDensity);
    }

    protected final long resolveSelectedLabelYPos(@NotNull GlobalBounds viewGlobalBounds, long labelHeight) {
        Intrinsics.checkNotNullParameter((Object)viewGlobalBounds, (String)"viewGlobalBounds");
        return viewGlobalBounds.getY() + (viewGlobalBounds.getHeight() - labelHeight) / (long)2;
    }

    @NotNull
    protected final String resolveSelectedTextColor(@NotNull NumberPicker view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return this.getColorStringFormatter().formatColorAndAlphaAsHexString(view.getTextColor(), 255);
    }

    @NotNull
    protected final MobileSegment.Wireframe.TextWireframe provideLabelWireframe(long id2, long x, long y, long height, long width, @NotNull String labelValue, long textSize, @NotNull String textColor) {
        Intrinsics.checkNotNullParameter((Object)labelValue, (String)"labelValue");
        Intrinsics.checkNotNullParameter((Object)textColor, (String)"textColor");
        return new MobileSegment.Wireframe.TextWireframe(id2, x, y, width, height, null, null, null, labelValue, new MobileSegment.TextStyle(FONT_FAMILY, textSize, textColor), new MobileSegment.TextPosition(null, new MobileSegment.Alignment(MobileSegment.Horizontal.CENTER, MobileSegment.Vertical.CENTER), 1, null), 224, null);
    }

    @NotNull
    protected final MobileSegment.Wireframe.ShapeWireframe provideDividerWireframe(long id2, long x, long y, long width, long height, @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new MobileSegment.Wireframe.ShapeWireframe(id2, x, y, width, height, null, new MobileSegment.ShapeStyle(color, null, null, 6, null), null, 160, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/BasePickerMapper$Companion;", "", "()V", "DIVIDER_BOTTOM_KEY_NAME", "", "DIVIDER_HEIGHT_IN_PX", "", "DIVIDER_TOP_KEY_NAME", "FONT_FAMILY", "NEXT_INDEX_KEY_NAME", "PADDING_IN_PX", "PREV_INDEX_KEY_NAME", "SELECTED_INDEX_KEY_NAME", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

