/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.os.Build;
import android.view.View;
import android.widget.CompoundButton;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.internal.recorder.mapper.CheckableCompoundButtonMapper;
import com.datadog.android.sessionreplay.internal.recorder.mapper.CheckableTextViewMapper;
import com.datadog.android.sessionreplay.recorder.mapper.TextViewMapper;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b \u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001dB;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0017\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableCompoundButtonMapper;", "T", "Landroid/widget/CompoundButton;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableTextViewMapper;", "textWireframeMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;Lcom/datadog/android/api/InternalLogger;)V", "cloneCheckableDrawable", "Landroid/graphics/drawable/Drawable;", "view", "drawable", "(Landroid/widget/CompoundButton;Landroid/graphics/drawable/Drawable;)Landroid/graphics/drawable/Drawable;", "getCheckableDrawable", "(Landroid/widget/CompoundButton;)Landroid/graphics/drawable/Drawable;", "resolveCheckableBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "pixelsDensity", "", "(Landroid/widget/CompoundButton;F)Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "Companion", "dd-sdk-android-session-replay_release"})
public abstract class CheckableCompoundButtonMapper<T extends CompoundButton>
extends CheckableTextViewMapper<T> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final InternalLogger internalLogger;
    public static final long DEFAULT_CHECKABLE_HEIGHT_IN_DP = 32L;
    @NotNull
    public static final String GET_DRAWABLE_FAIL_MESSAGE = "Failed to get buttonDrawable from the checkable compound button.";
    @NotNull
    public static final String NULL_BUTTON_DRAWABLE_MSG = "ButtonDrawable of the compound button is null";
    @Nullable
    private static final Field mButtonDrawableField;

    public CheckableCompoundButtonMapper(@NotNull TextViewMapper<? super T> textWireframeMapper, @NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(textWireframeMapper, (String)"textWireframeMapper");
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        super(textWireframeMapper, viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
        this.internalLogger = internalLogger;
    }

    @Override
    @UiThread
    @NotNull
    public GlobalBounds resolveCheckableBounds(@NotNull T view, float pixelsDensity) {
        long l;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        GlobalBounds viewGlobalBounds = this.getViewBoundsResolver().resolveViewGlobalBounds((View)view, pixelsDensity);
        if (Build.VERSION.SDK_INT >= 23) {
            Drawable drawable = view.getButtonDrawable();
            l = drawable != null ? LongExtKt.densityNormalized((long)drawable.getIntrinsicHeight(), (float)pixelsDensity) : 32L;
        } else {
            l = 32L;
        }
        long checkBoxHeight = l;
        return new GlobalBounds(viewGlobalBounds.getX(), viewGlobalBounds.getY() + (viewGlobalBounds.getHeight() - checkBoxHeight) / (long)2, checkBoxHeight, checkBoxHeight);
    }

    @Override
    @Nullable
    public Drawable getCheckableDrawable(@NotNull T view) {
        Object object;
        block7: {
            Object object2;
            block5: {
                block6: {
                    Intrinsics.checkNotNullParameter(view, (String)"view");
                    if (Build.VERSION.SDK_INT < 23) break block5;
                    int checkableDrawableIndex = view.isChecked() ? 0 : 1;
                    object = view.getButtonDrawable();
                    if (object == null) break block6;
                    Drawable it = object;
                    boolean bl = false;
                    Drawable.ConstantState constantState = it.getConstantState();
                    DrawableContainer.DrawableContainerState drawableContainerState = constantState instanceof DrawableContainer.DrawableContainerState ? (DrawableContainer.DrawableContainerState)constantState : null;
                    Object object3 = drawableContainerState != null ? drawableContainerState.getChild(checkableDrawableIndex) : null;
                    object = object3;
                    if (object3 != null) break block7;
                }
                boolean bl = false;
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)getCheckableDrawable.originCheckableDrawable.2.1.INSTANCE, null, (boolean)false, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"replay.compound.view", (Object)view.getClass().getCanonicalName())), (int)24, null);
                object = null;
                break block7;
            }
            try {
                Field field = mButtonDrawableField;
                object2 = field != null ? field.get(view) : null;
                object2 = object2 instanceof Drawable ? (Drawable)object2 : null;
            }
            catch (IllegalAccessException e) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)getCheckableDrawable.originCheckableDrawable.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
                object2 = null;
            }
            catch (IllegalArgumentException e) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)getCheckableDrawable.originCheckableDrawable.4.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
                object2 = null;
            }
            object = object2;
        }
        Object originCheckableDrawable2 = object;
        return originCheckableDrawable2;
    }

    @Override
    @Nullable
    public Drawable cloneCheckableDrawable(@NotNull T view, @NotNull Drawable drawable) {
        Drawable.ConstantState constantState;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Drawable.ConstantState constantState2 = drawable.getConstantState();
        if (constantState2 != null && (constantState2 = constantState2.newDrawable(view.getResources())) != null) {
            Drawable.ConstantState constantState3;
            Drawable.ConstantState $this$cloneCheckableDrawable_u24lambda_u243 = constantState3 = constantState2;
            boolean bl = false;
            $this$cloneCheckableDrawable_u24lambda_u243.setState(view.getDrawableState());
            ColorStateList colorStateList = view.getButtonTintList();
            if (colorStateList != null) {
                ColorStateList it = colorStateList;
                boolean bl2 = false;
                $this$cloneCheckableDrawable_u24lambda_u243.setTintList(it);
            }
            constantState = constantState3;
        } else {
            constantState = null;
        }
        return constantState;
    }

    static {
        Field field;
        Companion = new Companion(null);
        try {
            Field $this$mButtonDrawableField_u24lambda_u244 = field = CompoundButton.class.getDeclaredField("mButtonDrawable");
            boolean bl = false;
            $this$mButtonDrawableField_u24lambda_u244.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        catch (SecurityException e) {
            field = null;
        }
        catch (NullPointerException e) {
            field = null;
        }
        mButtonDrawableField = field;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableCompoundButtonMapper$Companion;", "", "()V", "DEFAULT_CHECKABLE_HEIGHT_IN_DP", "", "GET_DRAWABLE_FAIL_MESSAGE", "", "NULL_BUTTON_DRAWABLE_MSG", "mButtonDrawableField", "Ljava/lang/reflect/Field;", "getMButtonDrawableField$dd_sdk_android_session_replay_release$annotations", "getMButtonDrawableField$dd_sdk_android_session_replay_release", "()Ljava/lang/reflect/Field;", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Field getMButtonDrawableField$dd_sdk_android_session_replay_release() {
            return mButtonDrawableField;
        }

        public static /* synthetic */ void getMButtonDrawableField$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

