/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.internal.recorder.mapper.CheckableWireframeMapper;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.TextViewMapper;
import com.datadog.android.sessionreplay.recorder.resources.DrawableCopier;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ImageWireframeHelper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 6*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u00016B3\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0014J'\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0003\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\u001dJ+\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010#\u001a\u00020$H'\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010(J3\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0017\u00a2\u0006\u0002\u0010,J%\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0017\u00a2\u0006\u0002\u0010.J\u001f\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u00101\u001a\u00020'H\u0014\u00a2\u0006\u0002\u00102J\u001f\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u00101\u001a\u00020'H\u0014\u00a2\u0006\u0002\u00105R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableTextViewMapper;", "T", "Landroid/widget/TextView;", "Landroid/widget/Checkable;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableWireframeMapper;", "textWireframeMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "cloneCheckableDrawable", "Landroid/graphics/drawable/Drawable;", "view", "drawable", "(Landroid/widget/TextView;Landroid/graphics/drawable/Drawable;)Landroid/graphics/drawable/Drawable;", "createCheckableDrawableWireFrames", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "(Landroid/widget/TextView;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;)Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "getCheckableDrawable", "(Landroid/widget/TextView;)Landroid/graphics/drawable/Drawable;", "resolveCheckable", "", "(Landroid/widget/TextView;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;)Ljava/util/List;", "resolveCheckableBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "pixelsDensity", "", "(Landroid/widget/TextView;F)Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "resolveCheckableColor", "", "(Landroid/widget/TextView;)Ljava/lang/String;", "resolveMainWireframes", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/widget/TextView;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;Lcom/datadog/android/api/InternalLogger;)Ljava/util/List;", "resolveMaskedCheckable", "(Landroid/widget/TextView;Lcom/datadog/android/sessionreplay/recorder/MappingContext;)Ljava/util/List;", "resolveNotCheckedShapeBorder", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeBorder;", "checkBoxColor", "(Landroid/widget/TextView;Ljava/lang/String;)Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeBorder;", "resolveNotCheckedShapeStyle", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeStyle;", "(Landroid/widget/TextView;Ljava/lang/String;)Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeStyle;", "Companion", "dd-sdk-android-session-replay_release"})
public abstract class CheckableTextViewMapper<T extends TextView>
extends CheckableWireframeMapper<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextViewMapper<T> textWireframeMapper;
    @NotNull
    public static final String CHECKABLE_KEY_NAME = "checkable";
    public static final long CHECKABLE_BORDER_WIDTH = 1L;
    public static final int CHECK_BOX_CHECKED_DRAWABLE_INDEX = 0;
    public static final int CHECK_BOX_NOT_CHECKED_DRAWABLE_INDEX = 1;

    public CheckableTextViewMapper(@NotNull TextViewMapper<? super T> textWireframeMapper, @NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter(textWireframeMapper, (String)"textWireframeMapper");
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
        this.textWireframeMapper = textWireframeMapper;
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> resolveMainWireframes(@NotNull T view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return this.textWireframeMapper.map(view, mappingContext, asyncJobStatusCallback, internalLogger);
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> resolveCheckable(@NotNull T view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        return CollectionsKt.listOfNotNull((Object)this.createCheckableDrawableWireFrames(view, mappingContext, asyncJobStatusCallback));
    }

    @Override
    @UiThread
    @Nullable
    public List<MobileSegment.Wireframe> resolveMaskedCheckable(@NotNull T view, @NotNull MappingContext mappingContext) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Long l = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, CHECKABLE_KEY_NAME);
        if (l == null) {
            return null;
        }
        long checkableId = l;
        String checkBoxColor = this.resolveCheckableColor(view);
        GlobalBounds checkBoxBounds = this.resolveCheckableBounds(view, mappingContext.getSystemInformation().getScreenDensity());
        MobileSegment.ShapeBorder shapeBorder = this.resolveNotCheckedShapeBorder(view, checkBoxColor);
        MobileSegment.ShapeStyle shapeStyle = this.resolveNotCheckedShapeStyle(view, checkBoxColor);
        long l2 = checkBoxBounds.getX();
        long l3 = checkBoxBounds.getY();
        long l4 = checkBoxBounds.getWidth();
        long l5 = checkBoxBounds.getHeight();
        return CollectionsKt.listOf((Object)new MobileSegment.Wireframe.ShapeWireframe(checkableId, l2, l3, l4, l5, null, shapeStyle, shapeBorder, 32, null));
    }

    @UiThread
    @NotNull
    public abstract GlobalBounds resolveCheckableBounds(@NotNull T var1, float var2);

    @UiThread
    private final MobileSegment.Wireframe createCheckableDrawableWireFrames(T view, MappingContext mappingContext, AsyncJobStatusCallback asyncJobStatusCallback) {
        MobileSegment.Wireframe wireframe;
        Drawable drawable = this.getCheckableDrawable(view);
        if (drawable != null) {
            Drawable it = drawable;
            boolean bl = false;
            GlobalBounds checkBoxBounds = this.resolveCheckableBounds(view, mappingContext.getSystemInformation().getScreenDensity());
            DrawableCopier drawableCopier = (arg_0, arg_1) -> CheckableTextViewMapper.createCheckableDrawableWireFrames$lambda$1$lambda$0(this, view, it, arg_0, arg_1);
            ImageWireframeHelper imageWireframeHelper = mappingContext.getImageWireframeHelper();
            ImagePrivacy imagePrivacy = this.mapInputPrivacyToImagePrivacy(mappingContext.getTextAndInputPrivacy());
            long l = checkBoxBounds.getX();
            long l2 = checkBoxBounds.getY();
            int n = it.getIntrinsicWidth();
            int n2 = it.getIntrinsicHeight();
            MobileSegment.WireframeClip wireframeClip = new MobileSegment.WireframeClip(null, null, null, null, 15, null);
            wireframe = ImageWireframeHelper.DefaultImpls.createImageWireframeByDrawable$default(imageWireframeHelper, (View)view, imagePrivacy, 0, l, l2, n, n2, true, it, drawableCopier, asyncJobStatusCallback, wireframeClip, null, null, null, null, 16384, null);
        } else {
            wireframe = null;
        }
        return wireframe;
    }

    @Nullable
    public abstract Drawable cloneCheckableDrawable(@NotNull T var1, @NotNull Drawable var2);

    @UiThread
    @Nullable
    public abstract Drawable getCheckableDrawable(@NotNull T var1);

    @NotNull
    protected String resolveCheckableColor(@NotNull T view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        return this.getColorStringFormatter().formatColorAndAlphaAsHexString(view.getCurrentTextColor(), 255);
    }

    @Nullable
    protected MobileSegment.ShapeStyle resolveNotCheckedShapeStyle(@NotNull T view, @NotNull String checkBoxColor) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)checkBoxColor, (String)"checkBoxColor");
        return null;
    }

    @Nullable
    protected MobileSegment.ShapeBorder resolveNotCheckedShapeBorder(@NotNull T view, @NotNull String checkBoxColor) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)checkBoxColor, (String)"checkBoxColor");
        return new MobileSegment.ShapeBorder(checkBoxColor, 1L);
    }

    private static final Drawable createCheckableDrawableWireFrames$lambda$1$lambda$0(CheckableTextViewMapper this$0, TextView $view, Drawable $it, Drawable drawable, Resources resources) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"<anonymous parameter 1>");
        return this$0.cloneCheckableDrawable($view, $it);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableTextViewMapper$Companion;", "", "()V", "CHECKABLE_BORDER_WIDTH", "", "CHECKABLE_KEY_NAME", "", "CHECK_BOX_CHECKED_DRAWABLE_INDEX", "", "CHECK_BOX_NOT_CHECKED_DRAWABLE_INDEX", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

