/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.view.View;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.BaseWireframeMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ3\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J+\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H'\u00a2\u0006\u0002\u0010\u001eJ3\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H'\u00a2\u0006\u0002\u0010\u0018J%\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013H'\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableWireframeMapper;", "T", "Landroid/view/View;", "Landroid/widget/Checkable;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseWireframeMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "map", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/view/View;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;Lcom/datadog/android/api/InternalLogger;)Ljava/util/List;", "mapInputPrivacyToImagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "inputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "resolveCheckable", "(Landroid/view/View;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;)Ljava/util/List;", "resolveMainWireframes", "resolveMaskedCheckable", "(Landroid/view/View;Lcom/datadog/android/sessionreplay/recorder/MappingContext;)Ljava/util/List;", "dd-sdk-android-session-replay_release"})
public abstract class CheckableWireframeMapper<T extends View>
extends BaseWireframeMapper<T> {
    public CheckableWireframeMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull T view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        List<MobileSegment.Wireframe> checkableWireframes;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        List<MobileSegment.Wireframe> mainWireframes = this.resolveMainWireframes(view, mappingContext, asyncJobStatusCallback, internalLogger);
        List<MobileSegment.Wireframe> list = checkableWireframes = mappingContext.getTextAndInputPrivacy() != TextAndInputPrivacy.MASK_SENSITIVE_INPUTS ? this.resolveMaskedCheckable(view, mappingContext) : this.resolveCheckable(view, mappingContext, asyncJobStatusCallback);
        if (list != null) {
            List<MobileSegment.Wireframe> wireframes = list;
            boolean bl = false;
            return CollectionsKt.plus((Collection)mainWireframes, (Iterable)wireframes);
        }
        return mainWireframes;
    }

    @NotNull
    protected final ImagePrivacy mapInputPrivacyToImagePrivacy(@NotNull TextAndInputPrivacy inputPrivacy) {
        ImagePrivacy imagePrivacy;
        Intrinsics.checkNotNullParameter((Object)inputPrivacy, (String)"inputPrivacy");
        switch (WhenMappings.$EnumSwitchMapping$0[inputPrivacy.ordinal()]) {
            case 1: {
                imagePrivacy = ImagePrivacy.MASK_NONE;
                break;
            }
            case 2: 
            case 3: {
                imagePrivacy = ImagePrivacy.MASK_ALL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return imagePrivacy;
    }

    @UiThread
    @NotNull
    public abstract List<MobileSegment.Wireframe> resolveMainWireframes(@NotNull T var1, @NotNull MappingContext var2, @NotNull AsyncJobStatusCallback var3, @NotNull InternalLogger var4);

    @UiThread
    @Nullable
    public abstract List<MobileSegment.Wireframe> resolveMaskedCheckable(@NotNull T var1, @NotNull MappingContext var2);

    @UiThread
    @NotNull
    public abstract List<MobileSegment.Wireframe> resolveCheckable(@NotNull T var1, @NotNull MappingContext var2, @NotNull AsyncJobStatusCallback var3);

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAndInputPrivacy.values().length];
            try {
                nArray[TextAndInputPrivacy.MASK_SENSITIVE_INPUTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAndInputPrivacy.MASK_ALL_INPUTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAndInputPrivacy.MASK_ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

