/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.view.View;
import android.widget.CheckedTextView;
import androidx.annotation.UiThread;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.internal.recorder.mapper.CheckableTextViewMapper;
import com.datadog.android.sessionreplay.recorder.mapper.TextViewMapper;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0002H\u0015\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckedTextViewMapper;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableTextViewMapper;", "Landroid/widget/CheckedTextView;", "textWireframeMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "cloneCheckableDrawable", "Landroid/graphics/drawable/Drawable;", "view", "drawable", "getCheckableDrawable", "resolveCheckableBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "pixelsDensity", "", "resolveCheckableColor", "", "dd-sdk-android-session-replay_release"})
public class CheckedTextViewMapper
extends CheckableTextViewMapper<CheckedTextView> {
    public CheckedTextViewMapper(@NotNull TextViewMapper<? super CheckedTextView> textWireframeMapper, @NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter(textWireframeMapper, (String)"textWireframeMapper");
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(textWireframeMapper, viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
    }

    @Override
    @UiThread
    @NotNull
    protected String resolveCheckableColor(@NotNull CheckedTextView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ColorStateList colorStateList = view.getCheckMarkTintList();
        int color = colorStateList != null ? colorStateList.getDefaultColor() : view.getCurrentTextColor();
        return this.getColorStringFormatter().formatColorAndAlphaAsHexString(color, 255);
    }

    @Override
    @UiThread
    @NotNull
    public GlobalBounds resolveCheckableBounds(@NotNull CheckedTextView view, float pixelsDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        GlobalBounds viewGlobalBounds = this.getViewBoundsResolver().resolveViewGlobalBounds((View)view, pixelsDensity);
        long textViewPaddingRight = LongExtKt.densityNormalized((long)view.getTotalPaddingRight(), (float)pixelsDensity);
        long checkBoxHeight = 0L;
        Drawable checkMarkDrawable = view.getCheckMarkDrawable();
        if (checkMarkDrawable != null && checkMarkDrawable.getIntrinsicHeight() > 0) {
            int height = checkMarkDrawable.getIntrinsicHeight() - view.getTotalPaddingTop() - view.getTotalPaddingBottom();
            checkBoxHeight = LongExtKt.densityNormalized((long)height, (float)pixelsDensity);
        }
        return new GlobalBounds(viewGlobalBounds.getX() + viewGlobalBounds.getWidth() - textViewPaddingRight, viewGlobalBounds.getY(), checkBoxHeight, checkBoxHeight);
    }

    @Override
    @Nullable
    public Drawable getCheckableDrawable(@NotNull CheckedTextView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int checkableDrawableIndex = view.isChecked() ? 0 : 1;
        Drawable drawable = view.getCheckMarkDrawable();
        Drawable.ConstantState constantState = drawable != null ? drawable.getConstantState() : null;
        DrawableContainer.DrawableContainerState drawableContainerState = constantState instanceof DrawableContainer.DrawableContainerState ? (DrawableContainer.DrawableContainerState)constantState : null;
        return drawableContainerState != null ? drawableContainerState.getChild(checkableDrawableIndex) : null;
    }

    @Override
    @Nullable
    public Drawable cloneCheckableDrawable(@NotNull CheckedTextView view, @NotNull Drawable drawable) {
        Drawable.ConstantState constantState;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Drawable.ConstantState constantState2 = drawable.getConstantState();
        if (constantState2 != null && (constantState2 = constantState2.newDrawable(view.getResources())) != null) {
            Drawable.ConstantState constantState3;
            Drawable.ConstantState $this$cloneCheckableDrawable_u24lambda_u241 = constantState3 = constantState2;
            boolean bl = false;
            $this$cloneCheckableDrawable_u24lambda_u241.setState(view.getDrawableState());
            ColorStateList colorStateList = view.getCheckMarkTintList();
            if (colorStateList != null) {
                ColorStateList it = colorStateList;
                boolean bl2 = false;
                $this$cloneCheckableDrawable_u24lambda_u241.setTintList(view.getCheckMarkTintList());
            }
            constantState = constantState3;
        } else {
            constantState = null;
        }
        return constantState;
    }
}

