/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.view.View;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.internal.recorder.mapper.ViewWireframeMapper;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.WireframeMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.DefaultViewIdentifierResolver;
import com.datadog.android.sessionreplay.utils.NoOpAsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/DecorViewMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/WireframeMapper;", "Landroid/view/View;", "viewWireframeMapper", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/ViewWireframeMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "(Lcom/datadog/android/sessionreplay/internal/recorder/mapper/ViewWireframeMapper;Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;)V", "addShapeStyleFromThemeIfNeeded", "", "themeColor", "", "wireframes", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "map", "", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nDecorViewMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecorViewMapper.kt\ncom/datadog/android/sessionreplay/internal/recorder/mapper/DecorViewMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n800#2,11:109\n288#2,2:120\n*S KotlinDebug\n*F\n+ 1 DecorViewMapper.kt\ncom/datadog/android/sessionreplay/internal/recorder/mapper/DecorViewMapper\n*L\n82#1:109,11\n83#1:120,2\n*E\n"})
public final class DecorViewMapper
implements WireframeMapper<View> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewWireframeMapper viewWireframeMapper;
    @NotNull
    private final ViewIdentifierResolver viewIdentifierResolver;
    @NotNull
    public static final String POP_UP_DECOR_VIEW_CLASS_NAME_SUFFIX = "popupdecorview";
    @NotNull
    public static final String WINDOW_WIREFRAME_COLOR = "#000000FF";
    public static final float WINDOW_WIREFRAME_OPACITY = 0.6f;
    @NotNull
    public static final String WINDOW_KEY_NAME = "window";

    public DecorViewMapper(@NotNull ViewWireframeMapper viewWireframeMapper, @NotNull ViewIdentifierResolver viewIdentifierResolver) {
        Intrinsics.checkNotNullParameter((Object)viewWireframeMapper, (String)"viewWireframeMapper");
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        this.viewWireframeMapper = viewWireframeMapper;
        this.viewIdentifierResolver = viewIdentifierResolver;
    }

    public /* synthetic */ DecorViewMapper(ViewWireframeMapper viewWireframeMapper, ViewIdentifierResolver viewIdentifierResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            viewIdentifierResolver = DefaultViewIdentifierResolver.INSTANCE;
        }
        this(viewWireframeMapper, viewIdentifierResolver);
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull View view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        List wireframes;
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
            Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
            Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
            wireframes = CollectionsKt.toMutableList((Collection)this.viewWireframeMapper.map(view, mappingContext, (AsyncJobStatusCallback)new NoOpAsyncJobStatusCallback(), internalLogger));
            if (mappingContext.getSystemInformation().getThemeColor() != null) {
                this.addShapeStyleFromThemeIfNeeded(mappingContext.getSystemInformation().getThemeColor(), wireframes, view);
            }
            String decorClassName = view.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)decorClassName, (String)"decorClassName");
            Object object = decorClassName;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (StringsKt.endsWith$default((String)string, (String)POP_UP_DECOR_VIEW_CLASS_NAME_SUFFIX, (boolean)false, (int)2, null) || (object = this.viewIdentifierResolver.resolveChildUniqueIdentifier(view, WINDOW_KEY_NAME)) == null) break block1;
            long it = ((Number)object).longValue();
            boolean bl = false;
            MobileSegment.Wireframe.ShapeWireframe windowWireframe = new MobileSegment.Wireframe.ShapeWireframe(it, 0L, 0L, mappingContext.getSystemInformation().getScreenBounds().getWidth(), mappingContext.getSystemInformation().getScreenBounds().getHeight(), null, new MobileSegment.ShapeStyle(WINDOW_WIREFRAME_COLOR, Float.valueOf(0.6f), null, 4, null), null, 160, null);
            wireframes.add(0, windowWireframe);
        }
        return wireframes;
    }

    /*
     * WARNING - void declaration
     */
    private final void addShapeStyleFromThemeIfNeeded(String themeColor, List<MobileSegment.Wireframe> wireframes, View view) {
        Object v0;
        block4: {
            void $this$firstOrNull$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = wireframes;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MobileSegment.Wireframe.ShapeWireframe)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MobileSegment.Wireframe.ShapeWireframe it = (MobileSegment.Wireframe.ShapeWireframe)element$iv;
                boolean bl = false;
                if (!(it.getShapeStyle() != null)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        MobileSegment.Wireframe.ShapeWireframe rootNonEmptyWireframe = v0;
        if (rootNonEmptyWireframe == null) {
            MobileSegment.ShapeStyle shapeStyle = new MobileSegment.ShapeStyle(themeColor, Float.valueOf(view.getAlpha()), null, 4, null);
            int n = wireframes.size();
            for (int i = 0; i < n; ++i) {
                MobileSegment.Wireframe oldWireframe = wireframes.get(i);
                if (!(oldWireframe instanceof MobileSegment.Wireframe.ShapeWireframe)) continue;
                wireframes.set(i, MobileSegment.Wireframe.ShapeWireframe.copy$default((MobileSegment.Wireframe.ShapeWireframe)oldWireframe, 0L, 0L, 0L, 0L, 0L, null, shapeStyle, null, 191, null));
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/DecorViewMapper$Companion;", "", "()V", "POP_UP_DECOR_VIEW_CLASS_NAME_SUFFIX", "", "WINDOW_KEY_NAME", "WINDOW_WIREFRAME_COLOR", "WINDOW_WIREFRAME_OPACITY", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

