/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.view.View;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.WireframeMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/HiddenViewMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/WireframeMapper;", "Landroid/view/View;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;)V", "getViewBoundsResolver", "()Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "getViewIdentifierResolver", "()Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "map", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "Companion", "dd-sdk-android-session-replay_release"})
public final class HiddenViewMapper
implements WireframeMapper<View> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewIdentifierResolver viewIdentifierResolver;
    @NotNull
    private final ViewBoundsResolver viewBoundsResolver;
    @NotNull
    public static final String HIDDEN_VIEW_PLACEHOLDER_TEXT = "Hidden";
    @NotNull
    private static final String HIDDEN_KEY_NAME = "hidden";

    public HiddenViewMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ViewBoundsResolver viewBoundsResolver) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        this.viewIdentifierResolver = viewIdentifierResolver;
        this.viewBoundsResolver = viewBoundsResolver;
    }

    @NotNull
    public final ViewIdentifierResolver getViewIdentifierResolver() {
        return this.viewIdentifierResolver;
    }

    @NotNull
    public final ViewBoundsResolver getViewBoundsResolver() {
        return this.viewBoundsResolver;
    }

    @Override
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull View view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Long l = this.viewIdentifierResolver.resolveChildUniqueIdentifier(view, HIDDEN_KEY_NAME);
        if (l == null) {
            return CollectionsKt.emptyList();
        }
        long id2 = l;
        float density = mappingContext.getSystemInformation().getScreenDensity();
        GlobalBounds viewGlobalBounds = this.viewBoundsResolver.resolveViewGlobalBounds(view, density);
        return CollectionsKt.listOf((Object)new MobileSegment.Wireframe.PlaceholderWireframe(id2, viewGlobalBounds.getX(), viewGlobalBounds.getY(), viewGlobalBounds.getWidth(), viewGlobalBounds.getHeight(), null, HIDDEN_VIEW_PLACEHOLDER_TEXT, 32, null));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/HiddenViewMapper$Companion;", "", "()V", "HIDDEN_KEY_NAME", "", "HIDDEN_VIEW_PLACEHOLDER_TEXT", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

