/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.view.View;
import android.widget.NumberPicker;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.recorder.mapper.BasePickerMapper;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.SystemInformation;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0011\u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017JN\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010(\u001a\u00020$*\u00020\u000fH\u0002J\f\u0010)\u001a\u00020$*\u00020\u000fH\u0002\u00a8\u0006+"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/NumberPickerMapper;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/BasePickerMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "map", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "Landroid/widget/NumberPicker;", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "systemInformation", "Lcom/datadog/android/sessionreplay/recorder/SystemInformation;", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "prevIndexLabelId", "", "topDividerId", "selectedIndexLabelId", "bottomDividerId", "nextIndexLabelId", "resolveLabelValue", "", "numberPicker", "index", "", "resolveNextLabelValue", "resolvePrevLabelValue", "resolveSelectedLabelValue", "getNextIndex", "getPrevIndex", "Companion", "dd-sdk-android-session-replay_release"})
@RequiresApi(value=29)
public class NumberPickerMapper
extends BasePickerMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DEFAULT_MASKED_TEXT_VALUE = "xxx";

    public NumberPickerMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull NumberPicker view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Long prevIndexLabelId = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, "numeric_picker_prev_index");
        Long selectedIndexLabelId = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, "numeric_picker_selected_index");
        Long topDividerId = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, "numeric_picker_divider_top");
        Long bottomDividerId = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, "numeric_picker_divider_bottom");
        Long nextIndexLabelId = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, "numeric_picker_next_index");
        if (selectedIndexLabelId != null && topDividerId != null && bottomDividerId != null && prevIndexLabelId != null && nextIndexLabelId != null) {
            return this.map(view, mappingContext.getSystemInformation(), mappingContext.getTextAndInputPrivacy(), prevIndexLabelId, topDividerId, selectedIndexLabelId, bottomDividerId, nextIndexLabelId);
        }
        return CollectionsKt.emptyList();
    }

    private final List<MobileSegment.Wireframe> map(NumberPicker view, SystemInformation systemInformation, TextAndInputPrivacy textAndInputPrivacy, long prevIndexLabelId, long topDividerId, long selectedIndexLabelId, long bottomDividerId, long nextIndexLabelId) {
        List list;
        float screenDensity = systemInformation.getScreenDensity();
        GlobalBounds viewGlobalBounds = this.getViewBoundsResolver().resolveViewGlobalBounds((View)view, screenDensity);
        long textSize = this.resolveTextSize(view, screenDensity);
        long labelHeight = textSize * (long)2;
        long paddingStart = this.resolveDividerPaddingStart(view, screenDensity);
        long paddingEnd = this.resolveDividerPaddingEnd(view, screenDensity);
        String textColor = this.resolveSelectedTextColor(view);
        String nextPrevLabelTextColor = this.getColorStringFormatter().formatColorAndAlphaAsHexString(view.getTextColor(), 64);
        long padding = this.resolvePadding(screenDensity);
        long selectedLabelYPos = this.resolveSelectedLabelYPos(viewGlobalBounds, labelHeight);
        long dividerHeight = this.resolveDividerHeight(screenDensity);
        long topDividerYPos = selectedLabelYPos - dividerHeight - padding;
        long bottomDividerYPos = selectedLabelYPos + labelHeight + padding;
        long prevLabelYPos = topDividerYPos - labelHeight - padding;
        long nextLabelYPos = bottomDividerYPos + padding;
        long dividerWidth = viewGlobalBounds.getWidth() - paddingEnd - paddingStart;
        long dividerXPos = viewGlobalBounds.getX() + paddingStart;
        MobileSegment.Wireframe.TextWireframe prevValueLabelWireframe = this.provideLabelWireframe(prevIndexLabelId, viewGlobalBounds.getX(), prevLabelYPos, labelHeight, viewGlobalBounds.getWidth(), this.resolvePrevLabelValue(view), textSize, nextPrevLabelTextColor);
        MobileSegment.Wireframe.ShapeWireframe topDividerWireframe = this.provideDividerWireframe(topDividerId, dividerXPos, topDividerYPos, dividerWidth, dividerHeight, textColor);
        MobileSegment.Wireframe.TextWireframe selectedValueLabelWireframe = this.provideLabelWireframe(selectedIndexLabelId, viewGlobalBounds.getX(), selectedLabelYPos, labelHeight, viewGlobalBounds.getWidth(), this.resolveSelectedLabelValue(view), textSize, textColor);
        MobileSegment.Wireframe.ShapeWireframe bottomDividerWireframe = this.provideDividerWireframe(bottomDividerId, dividerXPos, bottomDividerYPos, dividerWidth, dividerHeight, textColor);
        MobileSegment.Wireframe.TextWireframe nextValueLabelWireframe = this.provideLabelWireframe(nextIndexLabelId, viewGlobalBounds.getX(), nextLabelYPos, labelHeight, viewGlobalBounds.getWidth(), this.resolveNextLabelValue(view), textSize, nextPrevLabelTextColor);
        if (textAndInputPrivacy == TextAndInputPrivacy.MASK_SENSITIVE_INPUTS) {
            Object[] objectArray = new MobileSegment.Wireframe[]{prevValueLabelWireframe, topDividerWireframe, selectedValueLabelWireframe, bottomDividerWireframe, nextValueLabelWireframe};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Object[] objectArray = new MobileSegment.Wireframe[]{topDividerWireframe, MobileSegment.Wireframe.TextWireframe.copy$default(selectedValueLabelWireframe, 0L, 0L, 0L, 0L, 0L, null, null, null, DEFAULT_MASKED_TEXT_VALUE, null, null, 1791, null), bottomDividerWireframe};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    private final String resolvePrevLabelValue(NumberPicker view) {
        return this.resolveLabelValue(view, this.getPrevIndex(view));
    }

    private final String resolveNextLabelValue(NumberPicker view) {
        return this.resolveLabelValue(view, this.getNextIndex(view));
    }

    private final String resolveSelectedLabelValue(NumberPicker view) {
        return this.resolveLabelValue(view, view.getValue());
    }

    private final int getPrevIndex(NumberPicker $this$getPrevIndex) {
        return $this$getPrevIndex.getValue() > $this$getPrevIndex.getMinValue() ? $this$getPrevIndex.getValue() - 1 : $this$getPrevIndex.getMaxValue();
    }

    private final int getNextIndex(NumberPicker $this$getNextIndex) {
        return $this$getNextIndex.getValue() < $this$getNextIndex.getMaxValue() ? $this$getNextIndex.getValue() + 1 : $this$getNextIndex.getMinValue();
    }

    private final String resolveLabelValue(NumberPicker numberPicker, int index) {
        int normalizedIndex = index - numberPicker.getMinValue();
        if (numberPicker.getDisplayedValues() != null && numberPicker.getDisplayedValues().length > normalizedIndex) {
            String string = numberPicker.getDisplayedValues()[normalizedIndex];
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"numberPicker.displayedValues[normalizedIndex]");
            return string;
        }
        return String.valueOf(index);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/NumberPickerMapper$Companion;", "", "()V", "DEFAULT_MASKED_TEXT_VALUE", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

