/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.content.res.ColorStateList;
import android.os.Build;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.BaseAsyncBackgroundWireframeMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\b\u0010\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00016B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ/\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001cJ!\u0010\u001d\u001a\u0004\u0018\u00010\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0004\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010$J3\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0017\u00a2\u0006\u0002\u0010-JS\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0012012\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a2\u0006\u0002\u00102J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00028\u0000H\u0003\u00a2\u0006\u0002\u00103J\u0015\u00105\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00103R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00067"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/ProgressBarWireframeMapper;", "P", "Landroid/widget/ProgressBar;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseAsyncBackgroundWireframeMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "showProgressWhenMaskUserInput", "", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;Z)V", "getShowProgressWhenMaskUserInput", "()Z", "buildActiveTrackWireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "trackBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "normalizedProgress", "", "trackColor", "", "(Landroid/widget/ProgressBar;Lcom/datadog/android/sessionreplay/utils/GlobalBounds;FI)Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "buildNonActiveTrackWireframe", "(Landroid/widget/ProgressBar;Lcom/datadog/android/sessionreplay/utils/GlobalBounds;I)Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "getColor", "colorStateList", "Landroid/content/res/ColorStateList;", "state", "", "(Landroid/content/res/ColorStateList;[I)Ljava/lang/Integer;", "getDefaultColor", "(Landroid/widget/ProgressBar;)I", "map", "", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/widget/ProgressBar;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;Lcom/datadog/android/api/InternalLogger;)Ljava/util/List;", "mapDeterminate", "", "wireframes", "", "(Ljava/util/List;Landroid/widget/ProgressBar;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/utils/GlobalBounds;IF)V", "(Landroid/widget/ProgressBar;)F", "normalizedProgressAndroidO", "normalizedProgressLegacy", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nProgressBarWireframeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressBarWireframeMapper.kt\ncom/datadog/android/sessionreplay/internal/recorder/mapper/ProgressBarWireframeMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public class ProgressBarWireframeMapper<P extends ProgressBar>
extends BaseAsyncBackgroundWireframeMapper<P> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean showProgressWhenMaskUserInput;
    public static final int NIGHT_MODE_COLOR = 0xFFFFFF;
    public static final int DAY_MODE_COLOR = 0;
    @NotNull
    public static final String ACTIVE_TRACK_KEY_NAME = "seekbar_active_track";
    @NotNull
    public static final String NON_ACTIVE_TRACK_KEY_NAME = "seekbar_non_active_track";
    @NotNull
    public static final String THUMB_KEY_NAME = "seekbar_thumb";
    public static final int THUMB_SHAPE_CORNER_RADIUS = 10;
    public static final long TRACK_HEIGHT_IN_PX = 8L;

    public ProgressBarWireframeMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper, boolean showProgressWhenMaskUserInput) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
        this.showProgressWhenMaskUserInput = showProgressWhenMaskUserInput;
    }

    public final boolean getShowProgressWhenMaskUserInput() {
        return this.showProgressWhenMaskUserInput;
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull P view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        boolean showProgress;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        List wireframes = new ArrayList();
        wireframes.addAll((Collection)super.map((View)view, mappingContext, asyncJobStatusCallback, internalLogger));
        float screenDensity = mappingContext.getSystemInformation().getScreenDensity();
        GlobalBounds viewPaddedBounds = this.getViewBoundsResolver().resolveViewPaddedBounds((View)view, screenDensity);
        long trackHeight = LongExtKt.densityNormalized((long)8L, (float)screenDensity);
        GlobalBounds trackBounds = new GlobalBounds(viewPaddedBounds.getX(), viewPaddedBounds.getY() + (viewPaddedBounds.getHeight() - trackHeight) / (long)2, viewPaddedBounds.getWidth(), trackHeight);
        int defaultColor = this.getDefaultColor(view);
        ColorStateList colorStateList = view.getProgressTintList();
        int[] nArray = view.getDrawableState();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"view.drawableState");
        Integer n = this.getColor(colorStateList, nArray);
        int trackColor = n != null ? n : defaultColor;
        MobileSegment.Wireframe wireframe = this.buildNonActiveTrackWireframe(view, trackBounds, trackColor);
        if (wireframe != null) {
            MobileSegment.Wireframe p0 = wireframe;
            boolean bl = false;
            wireframes.add(p0);
        }
        boolean hasProgress = !view.isIndeterminate();
        boolean bl = showProgress = mappingContext.getTextAndInputPrivacy() == TextAndInputPrivacy.MASK_SENSITIVE_INPUTS || mappingContext.getTextAndInputPrivacy() == TextAndInputPrivacy.MASK_ALL_INPUTS && this.showProgressWhenMaskUserInput;
        if (hasProgress && showProgress) {
            float normalizedProgress = this.normalizedProgress(view);
            this.mapDeterminate(wireframes, view, mappingContext, asyncJobStatusCallback, internalLogger, trackBounds, trackColor, normalizedProgress);
        }
        return wireframes;
    }

    protected void mapDeterminate(@NotNull List<MobileSegment.Wireframe> wireframes, @NotNull P view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger, @NotNull GlobalBounds trackBounds, int trackColor, float normalizedProgress) {
        block0: {
            Intrinsics.checkNotNullParameter(wireframes, (String)"wireframes");
            Intrinsics.checkNotNullParameter(view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
            Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
            Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
            Intrinsics.checkNotNullParameter((Object)trackBounds, (String)"trackBounds");
            MobileSegment.Wireframe wireframe = this.buildActiveTrackWireframe(view, trackBounds, normalizedProgress, trackColor);
            if (wireframe == null) break block0;
            MobileSegment.Wireframe p0 = wireframe;
            boolean bl = false;
            wireframes.add(p0);
        }
    }

    private final MobileSegment.Wireframe buildNonActiveTrackWireframe(P view, GlobalBounds trackBounds, int trackColor) {
        Long l = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, NON_ACTIVE_TRACK_KEY_NAME);
        if (l == null) {
            return null;
        }
        long nonActiveTrackId = l;
        String backgroundColor = this.getColorStringFormatter().formatColorAndAlphaAsHexString(trackColor, 64);
        return new MobileSegment.Wireframe.ShapeWireframe(nonActiveTrackId, trackBounds.getX(), trackBounds.getY(), trackBounds.getWidth(), trackBounds.getHeight(), null, new MobileSegment.ShapeStyle(backgroundColor, Float.valueOf(view.getAlpha()), null, 4, null), null, 160, null);
    }

    private final MobileSegment.Wireframe buildActiveTrackWireframe(P view, GlobalBounds trackBounds, float normalizedProgress, int trackColor) {
        Long l = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, ACTIVE_TRACK_KEY_NAME);
        if (l == null) {
            return null;
        }
        long activeTrackId = l;
        String backgroundColor = this.getColorStringFormatter().formatColorAndAlphaAsHexString(trackColor, 255);
        return new MobileSegment.Wireframe.ShapeWireframe(activeTrackId, trackBounds.getX(), trackBounds.getY(), (long)((float)trackBounds.getWidth() * normalizedProgress), trackBounds.getHeight(), null, new MobileSegment.ShapeStyle(backgroundColor, Float.valueOf(view.getAlpha()), null, 4, null), null, 160, null);
    }

    private final float normalizedProgress(P view) {
        return Build.VERSION.SDK_INT >= 26 ? this.normalizedProgressAndroidO(view) : this.normalizedProgressLegacy(view);
    }

    private final float normalizedProgressLegacy(P view) {
        float range = view.getMax();
        return view.getMax() == 0 ? 0.0f : (float)view.getProgress() / range;
    }

    @RequiresApi(value=26)
    private final float normalizedProgressAndroidO(P view) {
        float range = (float)view.getMax() - (float)view.getMin();
        return range == 0.0f ? 0.0f : (float)(view.getProgress() - view.getMin()) / range;
    }

    @Nullable
    protected final Integer getColor(@Nullable ColorStateList colorStateList, @NotNull int[] state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ColorStateList colorStateList2 = colorStateList;
        return colorStateList2 != null ? Integer.valueOf(colorStateList2.getColorForState(state, colorStateList.getDefaultColor())) : null;
    }

    protected final int getDefaultColor(@NotNull P view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        int uiModeFlags = view.getResources().getConfiguration().uiMode & 0x30;
        return uiModeFlags == 32 ? 0xFFFFFF : 0;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/ProgressBarWireframeMapper$Companion;", "", "()V", "ACTIVE_TRACK_KEY_NAME", "", "DAY_MODE_COLOR", "", "NIGHT_MODE_COLOR", "NON_ACTIVE_TRACK_KEY_NAME", "THUMB_KEY_NAME", "THUMB_SHAPE_CORNER_RADIUS", "TRACK_HEIGHT_IN_PX", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

