/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.content.res.ColorStateList;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.IntExtKt;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.recorder.mapper.ProgressBarWireframeMapper;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ:\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JN\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006$"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/SeekBarWireframeMapper;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/ProgressBarWireframeMapper;", "Landroid/widget/SeekBar;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "buildThumbWireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "trackBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "normalizedProgress", "", "trackHeight", "", "screenDensity", "thumbColor", "", "mapDeterminate", "", "wireframes", "", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "trackColor", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nSeekBarWireframeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeekBarWireframeMapper.kt\ncom/datadog/android/sessionreplay/internal/recorder/mapper/SeekBarWireframeMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public class SeekBarWireframeMapper
extends ProgressBarWireframeMapper<SeekBar> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int NIGHT_MODE_COLOR = 0xFFFFFF;
    public static final int DAY_MODE_COLOR = 0;
    @NotNull
    public static final String ACTIVE_TRACK_KEY_NAME = "seekbar_active_track";
    @NotNull
    public static final String NON_ACTIVE_TRACK_KEY_NAME = "seekbar_non_active_track";
    @NotNull
    public static final String THUMB_KEY_NAME = "seekbar_thumb";
    public static final int THUMB_SHAPE_CORNER_RADIUS = 10;
    public static final long TRACK_HEIGHT_IN_PX = 8L;

    public SeekBarWireframeMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper, false);
    }

    @Override
    protected void mapDeterminate(@NotNull List<MobileSegment.Wireframe> wireframes, @NotNull SeekBar view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger, @NotNull GlobalBounds trackBounds, int trackColor, float normalizedProgress) {
        block1: {
            Intrinsics.checkNotNullParameter(wireframes, (String)"wireframes");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
            Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
            Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
            Intrinsics.checkNotNullParameter((Object)trackBounds, (String)"trackBounds");
            super.mapDeterminate(wireframes, (ProgressBar)view, mappingContext, asyncJobStatusCallback, internalLogger, trackBounds, trackColor, normalizedProgress);
            if (mappingContext.getTextAndInputPrivacy() != TextAndInputPrivacy.MASK_SENSITIVE_INPUTS) break block1;
            float screenDensity = mappingContext.getSystemInformation().getScreenDensity();
            long trackHeight = LongExtKt.densityNormalized((long)8L, (float)screenDensity);
            ColorStateList colorStateList = view.getThumbTintList();
            int[] nArray = view.getDrawableState();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"view.drawableState");
            Integer n = this.getColor(colorStateList, nArray);
            int thumbColor = n != null ? n.intValue() : this.getDefaultColor((ProgressBar)view);
            MobileSegment.Wireframe wireframe = this.buildThumbWireframe(view, trackBounds, normalizedProgress, trackHeight, screenDensity, thumbColor);
            if (wireframe != null) {
                MobileSegment.Wireframe p0 = wireframe;
                boolean bl = false;
                wireframes.add(p0);
            }
        }
    }

    private final MobileSegment.Wireframe buildThumbWireframe(SeekBar view, GlobalBounds trackBounds, float normalizedProgress, long trackHeight, float screenDensity, int thumbColor) {
        Long l = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, THUMB_KEY_NAME);
        if (l == null) {
            return null;
        }
        long thumbId = l;
        String backgroundColor = this.getColorStringFormatter().formatColorAndAlphaAsHexString(thumbColor, 255);
        long thumbWidth = IntExtKt.densityNormalized((int)view.getThumb().getBounds().width(), (float)screenDensity);
        long thumbHeight = IntExtKt.densityNormalized((int)view.getThumb().getBounds().height(), (float)screenDensity);
        return new MobileSegment.Wireframe.ShapeWireframe(thumbId, trackBounds.getX() + (long)((float)trackBounds.getWidth() * normalizedProgress) - thumbWidth / (long)2, trackBounds.getY() + trackHeight / (long)2 - thumbHeight / (long)2, thumbWidth, thumbHeight, null, new MobileSegment.ShapeStyle(backgroundColor, Float.valueOf(view.getAlpha()), Math.max(thumbWidth / (long)2, thumbHeight / (long)2)), null, 160, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/SeekBarWireframeMapper$Companion;", "", "()V", "ACTIVE_TRACK_KEY_NAME", "", "DAY_MODE_COLOR", "", "NIGHT_MODE_COLOR", "NON_ACTIVE_TRACK_KEY_NAME", "THUMB_KEY_NAME", "THUMB_SHAPE_CORNER_RADIUS", "TRACK_HEIGHT_IN_PX", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

