/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.mapper;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.UiThread;
import androidx.appcompat.widget.SwitchCompat;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.IntExtKt;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.internal.recorder.mapper.CheckableWireframeMapper;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.TextViewMapper;
import com.datadog.android.sessionreplay.recorder.resources.DrawableCopier;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ImageWireframeHelper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002./B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J \u0010 \u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0002J&\u0010%\u001a\u0018\u0012\b\u0012\u00060\u0018j\u0002`'\u0012\b\u0012\u00060\u0018j\u0002`(\u0018\u00010&2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u001cH\u0002J&\u0010-\u001a\u0018\u0012\b\u0012\u00060\u0018j\u0002`'\u0012\b\u0012\u00060\u0018j\u0002`(\u0018\u00010&2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/SwitchCompatMapper;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/CheckableWireframeMapper;", "Landroidx/appcompat/widget/SwitchCompat;", "textWireframeMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "createSwitchCompatDrawableWireFrames", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "createThumbWireframe", "prevIndex", "", "createTrackWireframe", "resolveCheckable", "resolveCheckableColor", "", "resolveMainWireframes", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "resolveMaskedCheckable", "resolveThumbBounds", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/SwitchCompatMapper$GlobalBoundsInPx;", "pixelsDensity", "", "resolveThumbSizeInPx", "Lkotlin/Pair;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/Width;", "Lcom/datadog/android/sessionreplay/internal/recorder/mapper/Height;", "resolveTrackBounds", "resolveTrackShapeStyle", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeStyle;", "checkBoxColor", "resolveTrackSizeInPx", "Companion", "GlobalBoundsInPx", "dd-sdk-android-session-replay_release"})
public class SwitchCompatMapper
extends CheckableWireframeMapper<SwitchCompat> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextViewMapper<SwitchCompat> textWireframeMapper;
    @NotNull
    public static final String THUMB_KEY_NAME = "thumb";
    @NotNull
    public static final String TRACK_KEY_NAME = "track";

    public SwitchCompatMapper(@NotNull TextViewMapper<? super SwitchCompat> textWireframeMapper, @NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter(textWireframeMapper, (String)"textWireframeMapper");
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
        this.textWireframeMapper = textWireframeMapper;
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> resolveMainWireframes(@NotNull SwitchCompat view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return this.textWireframeMapper.map((SwitchCompat)((TextView)view), mappingContext, asyncJobStatusCallback, internalLogger);
    }

    private final List<MobileSegment.Wireframe> createSwitchCompatDrawableWireFrames(SwitchCompat view, MappingContext mappingContext, AsyncJobStatusCallback asyncJobStatusCallback) {
        int index = 0;
        MobileSegment.Wireframe thumbWireframe = this.createThumbWireframe(view, index, mappingContext, asyncJobStatusCallback);
        if (thumbWireframe != null) {
            ++index;
        }
        MobileSegment.Wireframe trackWireframe = this.createTrackWireframe(view, index, mappingContext, asyncJobStatusCallback);
        Object[] objectArray = new MobileSegment.Wireframe[]{trackWireframe, thumbWireframe};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final MobileSegment.Wireframe createTrackWireframe(SwitchCompat view, int prevIndex, MappingContext mappingContext, AsyncJobStatusCallback asyncJobStatusCallback) {
        GlobalBoundsInPx trackBounds;
        GlobalBoundsInPx globalBoundsInPx = trackBounds = this.resolveTrackBounds(view, mappingContext.getSystemInformation().getScreenDensity());
        if (globalBoundsInPx != null) {
            GlobalBoundsInPx it = globalBoundsInPx;
            boolean bl = false;
            Drawable trackDrawable = view.getTrackDrawable();
            DrawableCopier drawableCopier = (arg_0, arg_1) -> SwitchCompatMapper.createTrackWireframe$lambda$3$lambda$2(view, arg_0, arg_1);
            ImageWireframeHelper imageWireframeHelper = mappingContext.getImageWireframeHelper();
            ImagePrivacy imagePrivacy = this.mapInputPrivacyToImagePrivacy(mappingContext.getTextAndInputPrivacy());
            int n = prevIndex + 1;
            long l = IntExtKt.densityNormalized((int)it.getX(), (float)mappingContext.getSystemInformation().getScreenDensity());
            long l2 = IntExtKt.densityNormalized((int)it.getY(), (float)mappingContext.getSystemInformation().getScreenDensity());
            int n2 = it.getWidth();
            int n3 = it.getHeight();
            View view2 = (View)view;
            Intrinsics.checkNotNullExpressionValue((Object)trackDrawable, (String)"trackDrawable");
            return ImageWireframeHelper.DefaultImpls.createImageWireframeByDrawable$default(imageWireframeHelper, view2, imagePrivacy, n, l, l2, n2, n3, true, trackDrawable, drawableCopier, asyncJobStatusCallback, null, null, null, null, null, 18432, null);
        }
        return null;
    }

    private final MobileSegment.Wireframe createThumbWireframe(SwitchCompat view, int prevIndex, MappingContext mappingContext, AsyncJobStatusCallback asyncJobStatusCallback) {
        MobileSegment.Wireframe wireframe;
        GlobalBoundsInPx thumbBounds = this.resolveThumbBounds(view, mappingContext.getSystemInformation().getScreenDensity());
        Drawable thumbDrawable = view.getThumbDrawable();
        DrawableCopier drawableCopier = (arg_0, arg_1) -> SwitchCompatMapper.createThumbWireframe$lambda$6(view, arg_0, arg_1);
        GlobalBoundsInPx globalBoundsInPx = thumbBounds;
        if (globalBoundsInPx != null) {
            GlobalBoundsInPx it = globalBoundsInPx;
            boolean bl = false;
            ImageWireframeHelper imageWireframeHelper = mappingContext.getImageWireframeHelper();
            ImagePrivacy imagePrivacy = this.mapInputPrivacyToImagePrivacy(mappingContext.getTextAndInputPrivacy());
            int n = prevIndex + 1;
            long l = IntExtKt.densityNormalized((int)it.getX(), (float)mappingContext.getSystemInformation().getScreenDensity());
            long l2 = IntExtKt.densityNormalized((int)it.getY(), (float)mappingContext.getSystemInformation().getScreenDensity());
            int n2 = thumbDrawable.getIntrinsicWidth();
            int n3 = thumbDrawable.getIntrinsicHeight();
            View view2 = (View)view;
            Intrinsics.checkNotNullExpressionValue((Object)thumbDrawable, (String)"thumbDrawable");
            wireframe = ImageWireframeHelper.DefaultImpls.createImageWireframeByDrawable$default(imageWireframeHelper, view2, imagePrivacy, n, l, l2, n2, n3, true, thumbDrawable, drawableCopier, asyncJobStatusCallback, null, null, null, null, null, 16384, null);
        } else {
            wireframe = null;
        }
        return wireframe;
    }

    private final GlobalBoundsInPx resolveThumbBounds(SwitchCompat view, float pixelsDensity) {
        GlobalBounds viewGlobalBounds = this.getViewBoundsResolver().resolveViewGlobalBounds((View)view, pixelsDensity);
        Pair<Integer, Integer> pair = this.resolveThumbSizeInPx(view);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> thumbDimensions = pair;
        int thumbLeft = (int)((float)viewGlobalBounds.getX() * pixelsDensity) + view.getThumbDrawable().getBounds().left;
        int thumbTop = (int)((float)viewGlobalBounds.getY() * pixelsDensity) + view.getThumbDrawable().getBounds().top;
        return new GlobalBoundsInPx(thumbLeft, thumbTop, ((Number)thumbDimensions.getFirst()).intValue(), ((Number)thumbDimensions.getSecond()).intValue());
    }

    private final GlobalBoundsInPx resolveTrackBounds(SwitchCompat view, float pixelsDensity) {
        GlobalBoundsInPx globalBoundsInPx;
        GlobalBounds viewGlobalBounds = this.getViewBoundsResolver().resolveViewGlobalBounds((View)view, pixelsDensity);
        Pair<Integer, Integer> pair = this.resolveTrackSizeInPx(view);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> trackSize = pair;
        Drawable drawable = view.getTrackDrawable();
        if (drawable != null) {
            Drawable it = drawable;
            boolean bl = false;
            globalBoundsInPx = new GlobalBoundsInPx((int)((float)viewGlobalBounds.getX() * pixelsDensity) + it.getBounds().left, (int)((float)viewGlobalBounds.getY() * pixelsDensity) + it.getBounds().top, ((Number)trackSize.getFirst()).intValue(), ((Number)trackSize.getSecond()).intValue());
        } else {
            globalBoundsInPx = null;
        }
        return globalBoundsInPx;
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> resolveCheckable(@NotNull SwitchCompat view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        return this.createSwitchCompatDrawableWireFrames(view, mappingContext, asyncJobStatusCallback);
    }

    @Override
    @UiThread
    @Nullable
    public List<MobileSegment.Wireframe> resolveMaskedCheckable(@NotNull SwitchCompat view, @NotNull MappingContext mappingContext) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        float pixelsDensity = mappingContext.getSystemInformation().getScreenDensity();
        List wireframes = new ArrayList();
        GlobalBoundsInPx globalBoundsInPx = this.resolveTrackBounds(view, pixelsDensity);
        if (globalBoundsInPx == null) {
            return null;
        }
        GlobalBoundsInPx trackBounds = globalBoundsInPx;
        String checkableColor = this.resolveCheckableColor(view);
        Long trackId = this.getViewIdentifierResolver().resolveChildUniqueIdentifier((View)view, TRACK_KEY_NAME);
        if (trackId != null) {
            MobileSegment.ShapeStyle trackShapeStyle = this.resolveTrackShapeStyle(view, checkableColor);
            long l = IntExtKt.densityNormalized((int)trackBounds.getX(), (float)pixelsDensity);
            long l2 = IntExtKt.densityNormalized((int)trackBounds.getY(), (float)pixelsDensity);
            long l3 = IntExtKt.densityNormalized((int)trackBounds.getWidth(), (float)pixelsDensity);
            long l4 = IntExtKt.densityNormalized((int)trackBounds.getHeight(), (float)pixelsDensity);
            MobileSegment.Wireframe.ShapeWireframe trackWireframe = new MobileSegment.Wireframe.ShapeWireframe(trackId, l, l2, l3, l4, null, trackShapeStyle, null, 32, null);
            wireframes.add(trackWireframe);
        }
        return wireframes;
    }

    private final String resolveCheckableColor(SwitchCompat view) {
        return this.getColorStringFormatter().formatColorAndAlphaAsHexString(view.getCurrentTextColor(), 255);
    }

    private final MobileSegment.ShapeStyle resolveTrackShapeStyle(SwitchCompat view, String checkBoxColor) {
        return new MobileSegment.ShapeStyle(checkBoxColor, Float.valueOf(view.getAlpha()), null, 4, null);
    }

    private final Pair<Integer, Integer> resolveThumbSizeInPx(SwitchCompat view) {
        Pair pair;
        Drawable drawable = view.getThumbDrawable();
        if (drawable != null) {
            Drawable it = drawable;
            boolean bl = false;
            pair = new Pair((Object)it.getIntrinsicWidth(), (Object)it.getIntrinsicHeight());
        } else {
            pair = null;
        }
        return pair;
    }

    private final Pair<Integer, Integer> resolveTrackSizeInPx(SwitchCompat view) {
        Pair pair;
        Drawable drawable = view.getTrackDrawable();
        if (drawable != null) {
            Drawable it = drawable;
            boolean bl = false;
            pair = new Pair((Object)it.getBounds().width(), (Object)it.getBounds().height());
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Drawable createTrackWireframe$lambda$3$lambda$2(SwitchCompat $view, Drawable originalDrawable, Resources resources) {
        Drawable.ConstantState constantState;
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)originalDrawable, (String)"originalDrawable");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Drawable.ConstantState constantState2 = originalDrawable.getConstantState();
        if (constantState2 != null && (constantState2 = constantState2.newDrawable(resources)) != null) {
            Drawable.ConstantState constantState3;
            Drawable.ConstantState $this$createTrackWireframe_u24lambda_u243_u24lambda_u242_u24lambda_u241 = constantState3 = constantState2;
            boolean bl = false;
            $this$createTrackWireframe_u24lambda_u243_u24lambda_u242_u24lambda_u241.setState($view.getTrackDrawable().getState());
            $this$createTrackWireframe_u24lambda_u243_u24lambda_u242_u24lambda_u241.setBounds($view.getTrackDrawable().getBounds());
            ColorStateList colorStateList = $view.getTrackTintList();
            if (colorStateList != null) {
                ColorStateList tintList = colorStateList;
                boolean bl2 = false;
                $this$createTrackWireframe_u24lambda_u243_u24lambda_u242_u24lambda_u241.setTintList(tintList);
            }
            constantState = constantState3;
        } else {
            constantState = null;
        }
        return constantState;
    }

    private static final Drawable createThumbWireframe$lambda$6(SwitchCompat $view, Drawable originalDrawable, Resources resources) {
        Drawable.ConstantState constantState;
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)originalDrawable, (String)"originalDrawable");
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Drawable.ConstantState constantState2 = originalDrawable.getConstantState();
        if (constantState2 != null && (constantState2 = constantState2.newDrawable(resources)) != null) {
            Drawable.ConstantState constantState3;
            Drawable.ConstantState $this$createThumbWireframe_u24lambda_u246_u24lambda_u245 = constantState3 = constantState2;
            boolean bl = false;
            $this$createThumbWireframe_u24lambda_u246_u24lambda_u245.setState($view.getThumbDrawable().getState());
            $this$createThumbWireframe_u24lambda_u246_u24lambda_u245.setBounds($view.getThumbDrawable().getBounds());
            ColorStateList colorStateList = $view.getThumbTintList();
            if (colorStateList != null) {
                ColorStateList it = colorStateList;
                boolean bl2 = false;
                $this$createThumbWireframe_u24lambda_u246_u24lambda_u245.setTintList(it);
            }
            constantState = constantState3;
        } else {
            constantState = null;
        }
        return constantState;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/SwitchCompatMapper$Companion;", "", "()V", "THUMB_KEY_NAME", "", "TRACK_KEY_NAME", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/mapper/SwitchCompatMapper$GlobalBoundsInPx;", "", "x", "", "y", "width", "height", "(IIII)V", "getHeight", "()I", "getWidth", "getX", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "dd-sdk-android-session-replay_release"})
    public static final class GlobalBoundsInPx {
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public GlobalBoundsInPx(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.width;
        }

        public final int component4() {
            return this.height;
        }

        @NotNull
        public final GlobalBoundsInPx copy(int x, int y, int width, int height) {
            return new GlobalBoundsInPx(x, y, width, height);
        }

        public static /* synthetic */ GlobalBoundsInPx copy$default(GlobalBoundsInPx globalBoundsInPx, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = globalBoundsInPx.x;
            }
            if ((n5 & 2) != 0) {
                n2 = globalBoundsInPx.y;
            }
            if ((n5 & 4) != 0) {
                n3 = globalBoundsInPx.width;
            }
            if ((n5 & 8) != 0) {
                n4 = globalBoundsInPx.height;
            }
            return globalBoundsInPx.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "GlobalBoundsInPx(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.x);
            result2 = result2 * 31 + Integer.hashCode(this.y);
            result2 = result2 * 31 + Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GlobalBoundsInPx)) {
                return false;
            }
            GlobalBoundsInPx globalBoundsInPx = (GlobalBoundsInPx)other;
            if (this.x != globalBoundsInPx.x) {
                return false;
            }
            if (this.y != globalBoundsInPx.y) {
                return false;
            }
            if (this.width != globalBoundsInPx.width) {
                return false;
            }
            return this.height == globalBoundsInPx.height;
        }
    }
}

