/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.MainThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapCachesManager;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapPool;
import com.datadog.android.sessionreplay.internal.recorder.resources.Cache;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourcesLRUCache;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J'\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b J\u001d\u0010!\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0003J\u0015\u0010'\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0003R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapCachesManager;", "", "resourcesLRUCache", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/Cache;", "", "", "bitmapPool", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapPool;", "logger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/sessionreplay/internal/recorder/resources/Cache;Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapPool;Lcom/datadog/android/api/InternalLogger;)V", "isBitmapPoolRegisteredForCallbacks", "", "isResourcesCacheRegisteredForCallbacks", "generateResourceKeyFromDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "generateResourceKeyFromDrawable$dd_sdk_android_session_replay_release", "getBitmapByProperties", "Landroid/graphics/Bitmap;", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "getBitmapByProperties$dd_sdk_android_session_replay_release", "getFromResourceCache", "key", "getFromResourceCache$dd_sdk_android_session_replay_release", "putInBitmapPool", "", "bitmap", "putInBitmapPool$dd_sdk_android_session_replay_release", "putInResourceCache", "resourceId", "putInResourceCache$dd_sdk_android_session_replay_release", "registerBitmapPoolForCallbacks", "applicationContext", "Landroid/content/Context;", "registerCallbacks", "registerCallbacks$dd_sdk_android_session_replay_release", "registerResourceLruCacheForCallbacks", "dd-sdk-android-session-replay_release"})
public final class BitmapCachesManager {
    @NotNull
    private final Cache<String, byte[]> resourcesLRUCache;
    @NotNull
    private final BitmapPool bitmapPool;
    @NotNull
    private final InternalLogger logger;
    private boolean isResourcesCacheRegisteredForCallbacks;
    private boolean isBitmapPoolRegisteredForCallbacks;

    public BitmapCachesManager(@NotNull Cache<String, byte[]> resourcesLRUCache, @NotNull BitmapPool bitmapPool, @NotNull InternalLogger logger) {
        Intrinsics.checkNotNullParameter(resourcesLRUCache, (String)"resourcesLRUCache");
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.resourcesLRUCache = resourcesLRUCache;
        this.bitmapPool = bitmapPool;
        this.logger = logger;
    }

    @MainThread
    public final void registerCallbacks$dd_sdk_android_session_replay_release(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.registerResourceLruCacheForCallbacks(applicationContext);
        this.registerBitmapPoolForCallbacks(applicationContext);
    }

    @MainThread
    private final void registerResourceLruCacheForCallbacks(Context applicationContext) {
        if (this.isResourcesCacheRegisteredForCallbacks) {
            return;
        }
        if (this.resourcesLRUCache instanceof ComponentCallbacks2) {
            applicationContext.registerComponentCallbacks((ComponentCallbacks)this.resourcesLRUCache);
            this.isResourcesCacheRegisteredForCallbacks = true;
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)registerResourceLruCacheForCallbacks.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
    }

    @MainThread
    private final void registerBitmapPoolForCallbacks(Context applicationContext) {
        if (this.isBitmapPoolRegisteredForCallbacks) {
            return;
        }
        applicationContext.registerComponentCallbacks((ComponentCallbacks)this.bitmapPool);
        this.isBitmapPoolRegisteredForCallbacks = true;
    }

    public final void putInResourceCache$dd_sdk_android_session_replay_release(@NotNull String key, @NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        byte[] byArray = resourceId.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.resourcesLRUCache.put(key, byArray);
    }

    @Nullable
    public final String getFromResourceCache$dd_sdk_android_session_replay_release(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = this.resourcesLRUCache.get(key);
        if (byArray == null) {
            return null;
        }
        byte[] resourceId = byArray;
        return new String(resourceId, Charsets.UTF_8);
    }

    @Nullable
    public final String generateResourceKeyFromDrawable$dd_sdk_android_session_replay_release(@NotNull Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Cache<String, byte[]> cache = this.resourcesLRUCache;
        ResourcesLRUCache resourcesLRUCache = cache instanceof ResourcesLRUCache ? (ResourcesLRUCache)cache : null;
        return resourcesLRUCache != null ? resourcesLRUCache.generateKeyFromDrawable$dd_sdk_android_session_replay_release(drawable) : null;
    }

    public final void putInBitmapPool$dd_sdk_android_session_replay_release(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.bitmapPool.put(bitmap);
    }

    @Nullable
    public final Bitmap getBitmapByProperties$dd_sdk_android_session_replay_release(int width, int height, @NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.bitmapPool.getBitmapByProperties$dd_sdk_android_session_replay_release(width, height, config);
    }
}

